/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.segmentation.CSC;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.spellchecker.SpellCheckerMarker;
import org.omegat.filehooks.IFileHook;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.editor.EditorController;
import org.omegat.gui.editor.EditorTextArea3;
import org.omegat.gui.editor.IPopupMenuConstructor;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.main.ProjectUICommands;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;
import org.omegat.util.gui.RegexHighlightListener;
import org.omegat.util.gui.UIThreadsUtil;
import org.openide.awt.Mnemonics;

public class EditorPopups {
    public static void init(EditorController ec) {
        ec.registerPopupMenuConstructors(100, new SpellCheckerPopup(ec));
        ec.registerPopupMenuConstructors(200, new GoToSegmentPopup(ec));
        ec.registerPopupMenuConstructors(400, new DefaultPopup());
        ec.registerPopupMenuConstructors(450, new SegmentationPopup());
        ec.registerPopupMenuConstructors(500, new DuplicateSegmentsPopup(ec));
        ec.registerPopupMenuConstructors(600, new EmptyNoneTranslationPopup(ec));
        ec.registerPopupMenuConstructors(700, new InsertTagsPopup());
        ec.registerPopupMenuConstructors(700, new InsertBidiPopup(ec));
        int i = 0;
        for (Class<? extends IPopupMenuConstructor> plugin0 : PluginUtils.getEditorPopupClasses()) {
            try {
                Constructor<? extends IPopupMenuConstructor> cons = plugin0.getDeclaredConstructor(EditorController.class);
                IPopupMenuConstructor instance = cons.newInstance(ec);
                ec.registerPopupMenuConstructors(700 + i * 100, instance);
                ++i;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static IMenuReceiver createReceiver(JPopupMenu popup, int size, String label) {
        if (size <= 5) {
            return new JPopupMenuReceiver(popup);
        }
        if (size <= 20) {
            JMenu subMenu = new JMenu(label);
            popup.add(subMenu);
            return new JSubMenuReceiver(subMenu);
        }
        JMenu subMenu = new JMenu(label);
        popup.add(subMenu);
        return new JCharMenuReceiver(subMenu);
    }

    public static class InsertBidiPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;
        protected String[] names = new String[]{"TF_MENU_EDIT_INSERT_CHARS_LRM", "TF_MENU_EDIT_INSERT_CHARS_RLM", "TF_MENU_EDIT_INSERT_CHARS_LRE", "TF_MENU_EDIT_INSERT_CHARS_RLE", "TF_MENU_EDIT_INSERT_CHARS_PDF"};
        protected String[] inserts = new String[]{"\u200e", "\u200f", "\u202a", "\u202b", "\u202c"};

        public InsertBidiPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveTranslation) {
                return;
            }
            JMenu submenu = new JMenu(OStrings.getString("TF_MENU_EDIT_INSERT_CHARS"));
            for (int i = 0; i < this.names.length; ++i) {
                JMenuItem item = new JMenuItem(OStrings.getString(this.names[i]));
                final String insertText = this.inserts[i];
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Core.getEditor().insertText(insertText);
                    }
                });
                submenu.add(item);
            }
            menu.add(submenu);
        }
    }

    public static class InsertTagsPopup
    implements IPopupMenuConstructor {
        private static final char START_ITALICS = '\u2460';
        private static final char END_ITALICS = '\u2776';
        private static final String[] names = new String[]{"IT", "BOLD", "UL", "SUP", "SUB"};

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (sb != null && !isInActiveTranslation) {
                return;
            }
            if (comp instanceof EditorTextArea3) {
                List<TagUtil.Tag> allTags = TagUtil.getAllTagsMissingFromTarget();
                IMenuReceiver receiver = EditorPopups.createReceiver(menu, allTags.size(), StringUtil.format(OStrings.getString("TF_MENU_EDIT_TAG_INSERT_N"), ""));
                for (TagUtil.Tag tag0 : allTags) {
                    receiver.addItem(StringUtil.format(OStrings.getString("TF_MENU_EDIT_TAG_INSERT_N"), tag0.tag), e -> Core.getEditor().insertTag(tag0.tag));
                }
            }
            if (IFileHook.hookForFile(Core.getEditor().getCurrentFile(), Core.getProject()).supportsPseudoTags()) {
                JMenu format = new JMenu(OStrings.getString("EDITOR_PSEUDOTAGS_MAIN"));
                menu.add(format);
                for (int i = 0; i <= 4; ++i) {
                    String text1;
                    JMenuItem item;
                    String label;
                    if (comp.getSelectedText() == null) {
                        JMenuItem item2 = format.add(StringUtil.format(OStrings.getString("EDITOR_PSEUDOTAGS_START"), OStrings.getString("EDITOR_PSEUDOTAGS_" + names[i])) + (char)(9312 + i));
                        String tagStart = "" + (char)(9312 + i);
                        item2.addActionListener(this.createInsertActionListener(comp, tagStart));
                        item2 = format.add(StringUtil.format(OStrings.getString("EDITOR_PSEUDOTAGS_END"), OStrings.getString("EDITOR_PSEUDOTAGS_" + names[i])) + (char)(10102 + i));
                        String tagEnd = "" + (char)(10102 + i);
                        item2.addActionListener(this.createInsertActionListener(comp, tagEnd));
                        continue;
                    }
                    String text = comp.getSelectedText();
                    if (text.startsWith("" + (char)(9312 + i)) && text.endsWith("" + (char)(10102 + i))) {
                        text = text.substring(1);
                        label = (text = text.substring(0, text.length() - 1)).length() < 50 ? text : text.substring(0, 40) + "...";
                        item = format.add(StringUtil.format(OStrings.getString("EDITOR_PSEUDOTAGS_UNSET"), OStrings.getString("EDITOR_PSEUDOTAGS_" + names[i])) + label);
                        text1 = text;
                        item.addActionListener(this.createInsertActionListener(comp, text1));
                        continue;
                    }
                    label = text.length() < 50 ? "" + (char)(9312 + i) + text + (char)(10102 + i) : "" + (char)(9312 + i) + "..." + (char)(10102 + i);
                    item = format.add(StringUtil.format(OStrings.getString("EDITOR_PSEUDOTAGS_SET"), OStrings.getString("EDITOR_PSEUDOTAGS_" + names[i])) + label);
                    text1 = "" + (char)(9312 + i) + text + (char)(10102 + i);
                    item.addActionListener(this.createInsertActionListener(comp, text1));
                }
            }
            menu.addSeparator();
        }

        private ActionListener createInsertActionListener(JTextComponent comp, String text) {
            if (comp instanceof EditorTextArea3) {
                return e -> Core.getEditor().insertTag(text);
            }
            return e -> comp.replaceSelection(text);
        }
    }

    public static class EmptyNoneTranslationPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public EmptyNoneTranslationPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveEntry) {
                return;
            }
            menu.add(OStrings.getString("TRANS_POP_EMPTY_TRANSLATION")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerEmptyTranslation();
                }
            });
            menu.add(OStrings.getString("TRANS_POP_REMOVE_TRANSLATION")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerUntranslated();
                }
            });
            menu.add(OStrings.getString("TRANS_POP_IDENTICAL_TRANSLATION")).addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ec.registerIdenticalTranslation();
                }
            });
            menu.addSeparator();
        }
    }

    public static class DuplicateSegmentsPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;
        private static int MAX_ITEMS_PER_PAGE = 10;

        public DuplicateSegmentsPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!isInActiveEntry) {
                return;
            }
            SourceTextEntry ste = this.ec.getCurrentEntry();
            List<SourceTextEntry> dups = ste.getDuplicates();
            if (dups.isEmpty()) {
                return;
            }
            JMenuItem header = menu.add(StringUtil.format(OStrings.getString("MW_GO_TO_DUPLICATE_HEADER"), dups.size()));
            header.setEnabled(false);
            JMenu submenu = null;
            for (int i = 0; i < dups.size(); ++i) {
                final int entryNum = dups.get(i).entryNum();
                if (i > 0 && i % MAX_ITEMS_PER_PAGE == 0) {
                    JMenu newSubmenu = new JMenu(OStrings.getString("MW_MORE_SUBMENU"));
                    if (submenu == null) {
                        menu.add(newSubmenu);
                    } else {
                        submenu.add(newSubmenu);
                    }
                    submenu = newSubmenu;
                }
                String label = StringUtil.format(OStrings.getString("MW_GO_TO_DUPLICATE_ITEM"), entryNum);
                JMenuItem item = submenu == null ? menu.add(label) : submenu.add(label);
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ec.gotoEntry(entryNum);
                    }
                });
            }
            menu.addSeparator();
        }
    }

    public static class GoToSegmentPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public GoToSegmentPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, final int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (isInActiveEntry) {
                return;
            }
            JMenuItem item = menu.add(OStrings.getString("MW_PROMPT_SEG_NR_TITLE"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    comp.setCaretPosition(mousepos);
                    ec.goToSegmentAtLocation(comp.getCaretPosition());
                }
            });
            menu.addSeparator();
        }
    }

    public static class SegmentationPopup
    implements IPopupMenuConstructor {
        @Override
        public void addItems(JPopupMenu menu, JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            block14: {
                SourceTextEntry nextSte;
                if (isInActiveTranslation) {
                    return;
                }
                if (!isInActiveEntry) {
                    return;
                }
                menu.add(OStrings.getString("SEG_CUT")).addActionListener(e -> {
                    String before = sb.getSourceText().substring(0, mousepos - sb.getStartSourcePosition());
                    String after = sb.getSourceText().substring(mousepos - sb.getStartSourcePosition());
                    SegmentationPopup.addRule(true, before, after);
                });
                int segId = ((EditorController)Core.getEditor()).getSegmentIndexAtLocation(mousepos);
                SourceTextEntry curSte = Core.getProject().getAllEntries().get(segId);
                if (!curSte.isParagraphStart()) {
                    menu.add(OStrings.getString("SEG_MERGE_PREV")).addActionListener(e -> {
                        String before = Core.getProject().getAllEntries().get(segId - 1).getSrcText();
                        String after = curSte.getSrcText();
                        SegmentationPopup.addRule(false, before, "#OptSpace#" + after);
                    });
                }
                if (segId < Core.getProject().getAllEntries().size() - 1 && !(nextSte = Core.getProject().getAllEntries().get(segId + 1)).isParagraphStart()) {
                    menu.add(OStrings.getString("SEG_MERGE_NEXT")).addActionListener(e -> {
                        String before = curSte.getSrcText();
                        String after = nextSte.getSrcText();
                        SegmentationPopup.addRule(false, before, "#OptSpace#" + after);
                    });
                }
                try {
                    CSC current = (CSC)Core.getProject().getProjectProperties().getProjectSegmentationData();
                    if (current == null) {
                        current = (CSC)Preferences.getSegmentationData();
                    }
                    if (current == null) break block14;
                    block3: for (Map.Entry<String, Rule> templates : current.getTemplates().entrySet()) {
                        String toAdd;
                        String varName = null;
                        boolean before = true;
                        Matcher match = CSC.PATTERN_CSC_VARIABLE.matcher(templates.getValue().getBeforebreak());
                        while (match.find()) {
                            if (varName != null) continue block3;
                            varName = match.group(1);
                            before = true;
                        }
                        match = CSC.PATTERN_CSC_VARIABLE.matcher(templates.getValue().getAfterbreak());
                        while (match.find()) {
                            if (varName != null) continue block3;
                            varName = match.group(1);
                            before = false;
                        }
                        if (varName == null) continue;
                        CSC segData = current;
                        if (before) {
                            Pattern pBefore = Pattern.compile(CSC.PATTERN_CSC_VARIABLE.matcher(templates.getValue().getBeforebreak()).replaceAll("\\\\w+"));
                            match = pBefore.matcher(sb.getSourceText());
                            while (match.find()) {
                                if (mousepos - sb.getStartSourcePosition() < match.start() || mousepos - sb.getStartSourcePosition() > match.end()) continue;
                                toAdd = match.group(1);
                                menu.add("Add " + templates.getKey() + ": " + match.group(1)).addActionListener(e -> {
                                    segData.addTemplateApply(SegmentationPopup.getSpecificMapRule(segData), (String)templates.getKey(), toAdd);
                                    SegmentationPopup.saveToProject(segData);
                                });
                            }
                            continue;
                        }
                        Pattern pAfter = Pattern.compile(CSC.PATTERN_CSC_VARIABLE.matcher(templates.getValue().getAfterbreak()).replaceAll("\\\\w+"));
                        match = pAfter.matcher(sb.getSourceText());
                        while (match.find()) {
                            if (mousepos - sb.getStartSourcePosition() < match.start() || mousepos - sb.getStartSourcePosition() > match.end()) continue;
                            toAdd = match.group(1);
                            menu.add("Add " + templates.getKey() + ": " + match.group(1)).addActionListener(e -> {
                                segData.addTemplateApply(SegmentationPopup.getSpecificMapRule(segData), (String)templates.getKey(), toAdd);
                                SegmentationPopup.saveToProject(segData);
                            });
                        }
                    }
                }
                catch (ClassCastException current) {
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            menu.addSeparator();
        }

        private static void addRule(boolean isBreak, String before, String after) {
            if (before.contains(">")) {
                before = before.substring(before.lastIndexOf(">") + 1);
            }
            if (before.length() == 0) {
                JOptionPane.showMessageDialog(null, OStrings.getString("POPUP_SEGMENTATION_MSG_ERR_SPLIT_BEGIN"), OStrings.getString("TF_WARNING"), 2);
                return;
            }
            if (after.contains("<")) {
                after = after.substring(0, after.indexOf("<"));
            }
            if (after.length() == 0) {
                JOptionPane.showMessageDialog(null, OStrings.getString("POPUP_SEGMENTATION_MSG_ERR_SPLIT_END"), OStrings.getString("TF_WARNING"), 2);
                return;
            }
            if (after.startsWith(">")) {
                JOptionPane.showMessageDialog(null, OStrings.getString("POPUP_SEGMENTATION_MSG_ERR_SPLIT_INSIDE"), OStrings.getString("TF_WARNING"), 2);
                return;
            }
            JDialog dial = new JDialog((Frame)((Object)Core.getMainWindow()), true);
            dial.setLayout(new BoxLayout(dial.getContentPane(), 1));
            JPanel LINE_FIELDS = new JPanel();
            JPanel LINE_EMPTY = new JPanel();
            JPanel LINE_BTN = new JPanel();
            dial.add(LINE_FIELDS);
            dial.add(LINE_EMPTY);
            dial.add(LINE_BTN);
            final JLabel labelText = new JLabel("<html>" + before + "<font color=red>*</font>" + after + "</html>");
            LINE_EMPTY.add(labelText);
            LINE_BTN.setLayout(new FlowLayout(2));
            LINE_FIELDS.setLayout(new BoxLayout(LINE_FIELDS, 0));
            Box COL_LABEL = new Box(1);
            Box COL_FIELD = new Box(1);
            Box COL_BTN1 = new Box(1);
            Box COL_BTN2 = new Box(1);
            Box COL_BTN3 = new Box(1);
            LINE_FIELDS.add(COL_LABEL);
            LINE_FIELDS.add(COL_FIELD);
            LINE_FIELDS.add(COL_BTN1);
            LINE_FIELDS.add(COL_BTN2);
            LINE_FIELDS.add(COL_BTN3);
            before = StaticUtils.escapeNonRegex(before, null);
            after = StaticUtils.escapeNonRegex(after, null);
            before = before.replaceAll("\\s", "\\\\s");
            after = after.replaceAll("\\s", "\\\\s");
            after = after.replace("#OptSpace#", "\\s*");
            final JTextField fBefore = new JTextField(before);
            final JTextField fAfter = new JTextField(after);
            COL_LABEL.add(new JLabel(OStrings.getString("CORE_SRX_TABLE_COLUMN_Before_Break")));
            COL_FIELD.add(fBefore);
            JButton btnMoveDown = new JButton();
            COL_BTN1.add(btnMoveDown);
            Mnemonics.setLocalizedText(btnMoveDown, "\u2199 " + OStrings.getString("PF_MOVE_DOWN"));
            btnMoveDown.addActionListener(ev -> {
                Matcher m = Pattern.compile("\\\\?.\\z").matcher(fBefore.getText());
                if (m.find()) {
                    fBefore.setText(fBefore.getText().substring(0, m.start()));
                    fAfter.setText(m.group() + fAfter.getText());
                }
            });
            JButton btnBeforeRemoveFirst = new JButton(OStrings.getString("POPUP_SEGMENTATION_BTN_REMOVE_FIRST"));
            COL_BTN2.add(btnBeforeRemoveFirst);
            btnBeforeRemoveFirst.addActionListener(ev -> fBefore.setText(fBefore.getText().replaceFirst("\\A(\\\\.|\\P{L})*\\p{L}+(\\\\.|\\P{L})*", "")));
            JButton btnBeforeKeepOnlyLast = new JButton(OStrings.getString("POPUP_SEGMENTATION_BTN_KEEP_LAST"));
            COL_BTN3.add(btnBeforeKeepOnlyLast);
            btnBeforeKeepOnlyLast.addActionListener(ev -> {
                Matcher m = Pattern.compile("\\p{L}+(\\\\.|\\P{L})*\\z").matcher(fBefore.getText());
                if (m.find()) {
                    fBefore.setText("\\b" + m.group());
                }
            });
            COL_LABEL.add(new JLabel(OStrings.getString("CORE_SRX_TABLE_COLUMN_After_Break")));
            COL_FIELD.add(fAfter);
            JButton btnMoveUp = new JButton();
            COL_BTN1.add(btnMoveUp);
            Mnemonics.setLocalizedText(btnMoveUp, "\u2197 " + OStrings.getString("PF_MOVE_UP"));
            btnMoveUp.addActionListener(ev -> {
                Matcher m = Pattern.compile("\\A\\\\?.").matcher(fAfter.getText());
                if (m.find()) {
                    fAfter.setText(fAfter.getText().substring(m.end()));
                    fBefore.setText(fBefore.getText() + m.group());
                }
            });
            JButton btnAfterRemoveLast = new JButton(OStrings.getString("POPUP_SEGMENTATION_BTN_REMOVE_LAST"));
            COL_BTN2.add(btnAfterRemoveLast);
            btnAfterRemoveLast.addActionListener(ev -> fAfter.setText(fAfter.getText().replaceAll("(\\\\.)*\\p{L}+(\\\\.|\\P{L})*\\z", "")));
            JButton btnAfterKeepOnlyFirst = new JButton(OStrings.getString("POPUP_SEGMENTATION_BTN_KEEP_FIRST"));
            COL_BTN3.add(btnAfterKeepOnlyFirst);
            btnAfterKeepOnlyFirst.addActionListener(ev -> {
                Matcher m = Pattern.compile("\\A(\\\\.|\\P{L})*\\p{L}+(\\\\.|\\P{L})*").matcher(fAfter.getText());
                if (m.find()) {
                    fAfter.setText(m.group());
                }
            });
            DocumentListener refresh = new DocumentListener(){

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                }

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    SegmentationPopup.refreshLabel(labelText, fBefore, fAfter);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    SegmentationPopup.refreshLabel(labelText, fBefore, fAfter);
                }
            };
            fBefore.getDocument().addDocumentListener(refresh);
            fAfter.getDocument().addDocumentListener(refresh);
            fBefore.getDocument().addDocumentListener(new RegexHighlightListener(fBefore, 3));
            fAfter.getDocument().addDocumentListener(new RegexHighlightListener(fAfter, 3));
            JButton btnOk = new JButton();
            JButton btnCancel = new JButton();
            LINE_BTN.add(btnOk);
            LINE_BTN.add(btnCancel);
            Mnemonics.setLocalizedText(btnOk, OStrings.getString("BUTTON_OK"));
            Mnemonics.setLocalizedText(btnCancel, OStrings.getString("BUTTON_CANCEL"));
            btnCancel.addActionListener(e -> dial.dispose());
            btnOk.addActionListener(ev -> {
                ISegmentationData current = Core.getProject().getProjectProperties().getProjectSegmentationData();
                if (current == null) {
                    current = Preferences.getSegmentationData();
                }
                current.insertRule(0, SegmentationPopup.getSpecificMapRule(current), new Rule(isBreak, fBefore.getText(), fAfter.getText()));
                SegmentationPopup.saveToProject(current);
                dial.dispose();
            });
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            dial.pack();
            dial.setLocation((screenSize.width - dial.getWidth()) / 2, (screenSize.height - dial.getHeight()) / 2);
            dial.setVisible(true);
        }

        private static void refreshLabel(JLabel labelText, JTextField fBefore, JTextField fAfter) {
            String beforeText = fBefore.getText().replaceAll("\\\\s", " ").replaceAll("\\\\(.)", "$1");
            String afterText = fAfter.getText().replaceAll("\\\\s", " ").replaceAll("\\\\(.)", "$1");
            labelText.setText("<html>" + beforeText + "<font color=red>*</font>" + afterText + "</html>");
        }

        private static MapRule getSpecificMapRule(ISegmentationData segData) {
            List<MapRule> mapRules = segData.getMappingRules();
            MapRule mapRule0 = mapRules.get(0);
            if (!mapRule0.getLanguageCode().equals("CORE_SRX_RULES_SPECIFIC")) {
                mapRule0 = new MapRule("CORE_SRX_RULES_SPECIFIC", ".*", new ArrayList<Rule>());
                segData.insertMapRule(0, mapRule0);
            }
            return mapRule0;
        }

        private static void saveToProject(ISegmentationData data) {
            try {
                ISegmentationData.saveTo(data, new File(Core.getProject().getProjectProperties().getProjectInternal()));
                ProjectUICommands.projectReload();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(null, ex.getMessage(), OStrings.getString("TF_ERROR"), 0);
            }
        }
    }

    public static class DefaultPopup
    implements IPopupMenuConstructor {
        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            String selText = comp.getSelectedText();
            Clipboard omClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = omClipboard.getContents(this);
            boolean cutEnabled = false;
            boolean copyEnabled = false;
            boolean pasteEnabled = false;
            if (selText != null && comp.getSelectionStart() <= mousepos && mousepos <= comp.getSelectionEnd()) {
                if (isInActiveTranslation) {
                    cutEnabled = true;
                }
                copyEnabled = true;
            }
            if (contents != null && isInActiveTranslation) {
                pasteEnabled = true;
            }
            JMenuItem cutContextItem = menu.add(OStrings.getString("CCP_CUT"));
            if (cutEnabled) {
                cutContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.cut();
                    }
                });
            } else {
                cutContextItem.setEnabled(false);
            }
            JMenuItem copyContextItem = menu.add(OStrings.getString("CCP_COPY"));
            if (copyEnabled) {
                copyContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.copy();
                    }
                });
            } else {
                copyContextItem.setEnabled(false);
            }
            JMenuItem pasteContextItem = menu.add(OStrings.getString("CCP_PASTE"));
            if (pasteEnabled) {
                pasteContextItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        comp.paste();
                    }
                });
            } else {
                pasteContextItem.setEnabled(false);
            }
            menu.addSeparator();
            JMenuItem item = menu.add(OStrings.getString("GUI_GLOSSARYWINDOW_addentry"));
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Core.getGlossary().showCreateGlossaryEntryDialog();
                }
            });
            menu.addSeparator();
        }
    }

    public static class SpellCheckerPopup
    implements IPopupMenuConstructor {
        protected final EditorController ec;

        public SpellCheckerPopup(EditorController ec) {
            this.ec = ec;
        }

        @Override
        public void addItems(JPopupMenu menu, final JTextComponent comp, int mousepos, boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
            if (!this.ec.getSettings().isAutoSpellChecking()) {
                return;
            }
            if (!isInActiveTranslation) {
                return;
            }
            String translation = this.ec.getCurrentTranslation();
            Token tok = null;
            int relOffset = this.ec.getPositionInEntryTranslation(mousepos);
            for (Token t : Core.getProject().getTargetTokenizer().tokenizeWords(translation, ITokenizer.StemmingMode.NONE)) {
                if (t.getOffset() > relOffset || relOffset >= t.getOffset() + t.getLength()) continue;
                tok = t;
                break;
            }
            if (tok == null) {
                return;
            }
            final String word = tok.getTextFromString(translation);
            final int wordStart = mousepos - relOffset + tok.getOffset();
            final int wordLength = tok.getLength();
            final AbstractDocument xlDoc = (AbstractDocument)comp.getDocument();
            if (!Core.getSpellChecker().isCorrect(word)) {
                JMenuItem item;
                List<String> suggestions = Core.getSpellChecker().suggest(word);
                IMenuReceiver receiver = EditorPopups.createReceiver(menu, suggestions.size(), "Suggestions");
                for (final String replacement : suggestions) {
                    receiver.addItem(replacement, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            try {
                                int pos = comp.getCaretPosition();
                                xlDoc.replace(wordStart, wordLength, replacement, null);
                                comp.setCaretPosition(pos);
                            }
                            catch (BadLocationException exc) {
                                Log.log(exc);
                            }
                        }
                    });
                }
                if (suggestions.isEmpty()) {
                    item = menu.add(OStrings.getString("SC_NO_SUGGESTIONS"));
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                        }
                    });
                }
                menu.addSeparator();
                item = menu.add(OStrings.getString("SC_IGNORE_ALL"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addIgnoreWord(word, wordStart, false);
                    }
                });
                item = menu.add(OStrings.getString("SC_ADD_TO_DICTIONARY"));
                item.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        this.addIgnoreWord(word, wordStart, true);
                    }
                });
                menu.addSeparator();
            }
        }

        protected void addIgnoreWord(String word, int offset, boolean add) {
            UIThreadsUtil.mustBeSwingThread();
            if (add) {
                Core.getSpellChecker().learnWord(word);
            } else {
                Core.getSpellChecker().ignoreWord(word);
            }
            this.ec.remarkOneMarker(SpellCheckerMarker.class.getName());
        }
    }

    private static class JPopupMenuReceiver
    implements IMenuReceiver {
        private JPopupMenu menu;

        public JPopupMenuReceiver(JPopupMenu menu) {
            this.menu = menu;
        }

        @Override
        public JMenuItem addItem(String label, ActionListener listener) {
            JMenuItem item = this.menu.add(label);
            item.addActionListener(listener);
            return item;
        }
    }

    private static class JCharMenuReceiver
    implements IMenuReceiver {
        private JMenu menu;
        private Map<Character, JMenu> submenus = new TreeMap<Character, JMenu>();

        public JCharMenuReceiver(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public JMenuItem addItem(String label, ActionListener listener) {
            JMenu submenu0 = this.submenus.get(Character.valueOf(label.charAt(0)));
            if (submenu0 == null) {
                submenu0 = new JMenu(Character.toString(label.charAt(0)));
                this.submenus.put(Character.valueOf(label.charAt(0)), submenu0);
                this.menu.add(submenu0);
            }
            JMenuItem item = submenu0.add(label);
            item.addActionListener(listener);
            return item;
        }
    }

    private static class JSubMenuReceiver
    implements IMenuReceiver {
        private JMenu menu;

        public JSubMenuReceiver(JMenu menu) {
            this.menu = menu;
        }

        @Override
        public JMenuItem addItem(String label, ActionListener listener) {
            JMenuItem item = this.menu.add(label);
            item.addActionListener(listener);
            return item;
        }
    }

    public static interface IMenuReceiver {
        public JMenuItem addItem(String var1, ActionListener var2);
    }
}

