/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.text.Collator;
import java.util.Comparator;
import org.omegat.core.Core;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.util.OStrings;

public enum GlossarySortCriteria {
    ALPHABETIC("TF_OPTIONSMENU_GLOSSARY_SORT_ALPHA", 'A'),
    PRIORITY("TF_OPTIONSMENU_GLOSSARY_SORT_PRIO", 'P'),
    LENGTH("TF_OPTIONSMENU_GLOSSARY_SORT_LEN", 'L'),
    CASE("TF_OPTIONSMENU_GLOSSARY_SORT_CASE", 'C');

    public final String translated;
    public final char shortName;

    private GlossarySortCriteria(String tra, char sName) {
        this.translated = tra;
        this.shortName = sName;
    }

    public static GlossarySortCriteria forChar(char ch) {
        switch (ch) {
            case 'A': 
            case 'a': {
                return ALPHABETIC;
            }
            case 'L': 
            case 'l': {
                return LENGTH;
            }
            case 'P': 
            case 'p': {
                return PRIORITY;
            }
            case 'C': 
            case 'c': {
                return CASE;
            }
        }
        return null;
    }

    public Comparator<GlossaryEntryStore> buildComparator(boolean src, boolean desc) {
        if (desc) {
            Comparator<GlossaryEntryStore> cmp = this.buildComparator(src, false);
            return (a, b) -> cmp.compare((GlossaryEntryStore)b, (GlossaryEntryStore)a);
        }
        switch (this) {
            case PRIORITY: {
                return (o1, o2) -> {
                    int p1 = o1.getPriority() ? 1 : 2;
                    int p2 = o2.getPriority() ? 1 : 2;
                    return p1 - p2;
                };
            }
            case ALPHABETIC: {
                if (src) {
                    Collator cmp = Collator.getInstance(Core.getProject().getProjectProperties().getSourceLanguage().getLocale());
                    return (a, b) -> cmp.compare(a.getSrcText().toLowerCase(), b.getSrcText().toLowerCase());
                }
                Collator cmp = Collator.getInstance(Core.getProject().getProjectProperties().getTargetLanguage().getLocale());
                return (a, b) -> cmp.compare(a.getLocText().toLowerCase(), b.getLocText().toLowerCase());
            }
            case CASE: {
                if (src) {
                    return (a, b) -> GlossarySortCriteria.caseCompare(a.getSrcText(), b.getSrcText());
                }
                return (a, b) -> GlossarySortCriteria.caseCompare(a.getLocText(), b.getLocText());
            }
            case LENGTH: {
                if (src) {
                    return (a, b) -> Integer.compare(a.getSrcText().length(), b.getSrcText().length());
                }
                return (a, b) -> Integer.compare(a.getLocText().length(), b.getLocText().length());
            }
        }
        return null;
    }

    public static int caseCompare(String a, String b) {
        int i = 0;
        while (i < a.length()) {
            int ib;
            int ia;
            if (i >= b.length()) {
                return 0;
            }
            int n = Character.isLowerCase(a.charAt(i)) ? 2 : (ia = Character.isUpperCase(a.charAt(i)) ? 1 : 0);
            int n2 = Character.isLowerCase(b.charAt(i)) ? 2 : (ib = Character.isUpperCase(b.charAt(i)) ? 1 : 0);
            if (ia != ib) {
                return ia - ib;
            }
            ++i;
        }
        return 0;
    }

    public static Comparator<GlossaryEntryStore> buildSourceComparator(String spec) {
        char[] specArray = spec.substring(0, spec.indexOf(";")).toCharArray();
        Comparator[] comps = new Comparator[specArray.length];
        for (int i = 0; i < specArray.length; ++i) {
            comps[i] = GlossarySortCriteria.forChar(specArray[i]).buildComparator(true, Character.isLowerCase(specArray[i]));
        }
        return (a, b) -> {
            for (int i = 0; i < specArray.length; ++i) {
                int cmp = comps[i].compare(a, b);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        };
    }

    public static Comparator<GlossaryEntryStore> buildTargetComparator(String spec) {
        char[] specArray = spec.substring(spec.indexOf(";") + 1).toCharArray();
        Comparator[] comps = new Comparator[specArray.length];
        for (int i = 0; i < specArray.length; ++i) {
            comps[i] = GlossarySortCriteria.forChar(specArray[i]).buildComparator(false, Character.isLowerCase(specArray[i]));
        }
        return (a, b) -> {
            for (int i = 0; i < specArray.length; ++i) {
                int cmp = comps[i].compare(a, b);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        };
    }

    public static Comparator<GlossaryEntryStore> buildFullComparator(String spec) {
        int i;
        char[] specArray = spec.toCharArray();
        Comparator[] comps = new Comparator[specArray.length - 1];
        for (i = 0; i < spec.indexOf(";"); ++i) {
            comps[i] = GlossarySortCriteria.forChar(specArray[i]).buildComparator(true, Character.isLowerCase(specArray[i]));
        }
        for (i = spec.indexOf(";") + 1; i < spec.length(); ++i) {
            comps[i - 1] = GlossarySortCriteria.forChar(specArray[i]).buildComparator(false, Character.isLowerCase(specArray[i]));
        }
        return (a, b) -> {
            for (int i = 0; i <= 5; ++i) {
                int cmp = comps[i].compare(a, b);
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        };
    }

    public static class WithDirection {
        public GlossarySortCriteria criteria;
        public boolean desc = false;

        public WithDirection(GlossarySortCriteria criteria, boolean desc) {
            this.criteria = criteria;
            this.desc = desc;
        }

        public String toString() {
            return (this.desc ? "-" : "+") + OStrings.getString(this.criteria.translated);
        }

        public char shortName() {
            if (this.desc) {
                return Character.toLowerCase(this.criteria.shortName);
            }
            return this.criteria.shortName;
        }
    }
}

