/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.search;

import gen.core.filters.Filters;
import java.awt.Color;
import java.awt.Dimension;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.ProjectOptions;
import org.omegat.core.search.DirectorySearcher;
import org.omegat.core.search.Searcher;
import org.omegat.filters2.master.FilterMaster;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.gui.main.MainWindow;
import org.omegat.gui.search.SearchModeBox;
import org.omegat.gui.search.SearchWindow;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.OmegaTFileChooser;
import org.openide.awt.Mnemonics;

public class DirectorySearchWindow
extends SearchWindow {
    private static final Map<String, Set<String>> theMap = new HashMap<String, Set<String>>();
    private SearchWindow.SetRef setRef;
    private ProjectOptions options = null;
    private JComboBox m_searchField;
    private JTextField m_dirField;
    private JButton m_dirButton;
    private JCheckBox m_recursiveCB;

    @Override
    public void refreshLists(boolean removeContents) {
        String selected = removeContents ? "" : this.m_searchField.getSelectedItem().toString();
        this.m_searchField.removeAllItems();
        this.m_searchField.addItem(selected);
        this.setRef.theSet = theMap.get("SW_SEARCH_TEXT:" + this.m_modePanel.searchTypeString());
        for (String item : this.setRef.theSet) {
            this.m_searchField.addItem(SearchModeBox.MemorizedExpression.forString(item));
        }
        this.m_searchField.setSelectedItem(selected);
    }

    public DirectorySearchWindow(MainWindow par, String startText) {
        super(par, startText);
        this.refreshLists(true);
        if (startText != null) {
            this.m_searchField.setSelectedItem(startText);
        }
        JTextComponent searchFieldArea = (JTextComponent)this.m_searchField.getEditor().getEditorComponent();
        searchFieldArea.addMouseListener(new SearchWindow.PopupFactory(searchFieldArea));
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, searchFieldArea));
        this.options = Core.getProject().getProjectProperties();
    }

    public DirectorySearchWindow(ProjectOptions options, File destDir, String startText) {
        super(null, startText);
        this.options = options;
        this.refreshLists(true);
        if (startText != null) {
            this.m_searchField.setSelectedItem(startText);
        }
        JTextComponent searchFieldArea = (JTextComponent)this.m_searchField.getEditor().getEditorComponent();
        searchFieldArea.addMouseListener(new SearchWindow.PopupFactory(searchFieldArea));
        this.m_modePanel.addModeChangeListener(new SearchWindow.RegexModeSwitchListener(this, this.m_modePanel, searchFieldArea));
        if (destDir != null) {
            this.m_dirField.setText(destDir.toString());
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Syntax: java -cp OmegaT.jar org.omegat.gui.search.DirectorySearchWindow [source lang] [target lang]? [directory]? [text]?");
            System.exit(1);
        }
        PluginUtils.loadPlugins(null);
        Filters filterMasterConfig = FilterMaster.loadConfig(StaticUtils.getConfigDir());
        if (filterMasterConfig == null) {
            filterMasterConfig = FilterMaster.createDefaultFiltersConfig();
        }
        Core.setFilterMaster(new FilterMaster(filterMasterConfig));
        ProjectOptions opt = new ProjectOptions();
        opt.setSourceLanguage(args[0]);
        if (args.length > 1) {
            opt.setTargetLanguage(args[1]);
        }
        File destDir = null;
        if (args.length > 2) {
            destDir = new File(args[2]);
        }
        String text = null;
        if (args.length > 3) {
            destDir = new File(args[3]);
        }
        DirectorySearchWindow dsw = new DirectorySearchWindow(opt, destDir, text);
        dsw.setDefaultCloseOperation(3);
        dsw.setVisible(true);
    }

    @Override
    protected String getScopeText() {
        return OStrings.getString("SW_HELP_SCOPE_DIRECTORY");
    }

    @Override
    protected boolean isReplace() {
        return false;
    }

    @Override
    protected JComponent textPanel(String startText) {
        JLabel m_searchLabel = new JLabel();
        Mnemonics.setLocalizedText(m_searchLabel, OStrings.getString("SW_SEARCH_TEXT"));
        this.m_searchField = new JComboBox();
        this.m_searchField.setEditable(true);
        this.m_searchField.addActionListener(ev -> {
            try {
                SearchModeBox.MemorizedExpression item = (SearchModeBox.MemorizedExpression)this.m_searchField.getSelectedItem();
                item.applyTo(this.m_modePanel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        if (startText != null) {
            this.m_searchField.setSelectedItem(startText);
        }
        Box bSearch = Box.createHorizontalBox();
        bSearch.add(m_searchLabel);
        bSearch.add(this.m_searchField);
        this.setRef = new SearchWindow.SetRef(theMap.get("SW_SEARCH_TEXT:EXACT"));
        bSearch.add(this.createMemorizeButton(this.getY(), true, this.m_searchField, null, "SW_SEARCH_TEXT", this.setRef));
        bSearch.add(Box.createHorizontalStrut(10));
        bSearch.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_ZONE_TEXT")));
        return bSearch;
    }

    @Override
    public JComboBox getMainSearchTextField() {
        return this.m_searchField;
    }

    @Override
    protected String[] getFormatVariablesList() {
        return new String[]{"${preamble}", "${creationId}", "${creationDate}", "${sourceText}", "${fileName}", "${fileNameOnly}", "${filePath}", "${fileShortPath}"};
    }

    @Override
    protected String getFormatOptionName() {
        return "search_window_template_directory";
    }

    @Override
    protected String getFormatOptionDefaultValue() {
        return "${preamble}\n${sourceText}\n\n-----------------------\n";
    }

    @Override
    public Box wherePanel() {
        JLabel m_dirLabel = new JLabel();
        Mnemonics.setLocalizedText(m_dirLabel, OStrings.getString("SW_LOCATION"));
        this.m_dirField = new JTextField(50);
        this.m_dirField.setEditable(false);
        this.m_dirField.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.getPreferredSize().height));
        this.m_dirButton = new JButton();
        Mnemonics.setLocalizedText(this.m_dirButton, OStrings.getString("SW_BROWSE"));
        this.m_recursiveCB = new JCheckBox();
        Mnemonics.setLocalizedText(this.m_recursiveCB, OStrings.getString("SW_DIR_RECURSIVE"));
        this.m_recursiveCB.setSelected(true);
        Box bDir = Box.createHorizontalBox();
        bDir.add(m_dirLabel);
        bDir.add(this.m_dirField);
        bDir.add(Box.createHorizontalStrut(10));
        bDir.add(this.m_dirButton);
        bDir.add(this.m_recursiveCB);
        bDir.add(Box.createHorizontalGlue());
        bDir.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), OStrings.getString("SW_LOCATION")));
        this.m_dirButton.addActionListener(e -> this.doBrowseDirectory());
        return bDir;
    }

    @Override
    protected void loadPreferences() {
        super.loadPreferences();
        String searchDir = Preferences.getPreference("search_window_dir");
        if (!StringUtil.isEmpty(searchDir)) {
            this.m_dirField.setText(searchDir);
        }
        this.m_dirField.setEditable(true);
        String recursive = Preferences.getPreference("search_window_search_recursive");
        if (StringUtil.isEmpty(recursive)) {
            recursive = "true";
        }
        this.m_recursiveCB.setSelected(Boolean.valueOf(recursive));
    }

    @Override
    protected void savePreferences() {
        super.savePreferences();
        Preferences.setPreference("search_window_dir", this.m_dirField.getText());
        Preferences.setPreference("search_window_search_recursive", Boolean.toString(this.m_recursiveCB.isSelected()));
        Preferences.save();
    }

    private void doBrowseDirectory() {
        File dir;
        OmegaTFileChooser browser = new OmegaTFileChooser();
        browser.setDialogTitle(OStrings.getString("SW_TITLE_SEARCH"));
        browser.setFileSelectionMode(1);
        String curDir = this.m_dirField.getText();
        if (!curDir.equals("") && (dir = new File(curDir)).exists() && dir.isDirectory()) {
            browser.setCurrentDirectory(dir);
        }
        browser.showOpenDialog(this);
        dir = browser.getSelectedFile();
        if (dir == null) {
            return;
        }
        String str = dir.getAbsolutePath() + File.separator;
        this.m_dirField.setText(str);
    }

    @Override
    protected DirectorySearcher buildSearcher(Searcher previous) throws IllegalArgumentException {
        File f;
        String root = this.m_dirField.getText();
        if (!root.endsWith(File.separator)) {
            root = root + File.separator;
        }
        if (!(f = new File(root)).exists() || !f.isDirectory()) {
            String error = String.format(OStrings.getString("SW_ERROR_BAD_DIR"), this.m_dirField.getText());
            throw new IllegalArgumentException(error);
        }
        if (this.m_searchField.getSelectedItem() == null || this.m_searchField.getSelectedItem().toString().length() == 0) {
            throw new IllegalArgumentException(OStrings.getString("SW_ERROR_MANDATORY_FIELD_SEARCH"));
        }
        return new DirectorySearcher(this, this.options == null ? Core.getProject().getProjectProperties() : this.options, this.m_modePanel.buildExpression(this.m_searchField.getSelectedItem().toString(), false, true), this.m_removeDupCB.isSelected(), (Integer)this.m_numberOfResults.getValue(), root, this.m_recursiveCB.isSelected());
    }

    @Override
    protected JComponent[] componentsEnabledWhenResults() {
        return new JComponent[0];
    }

    @Override
    protected JTextComponent[] textFieldsList() {
        return new JTextComponent[0];
    }

    @Override
    protected ProjectOptions getOptions() {
        return this.options == null ? Core.getProject().getProjectProperties() : this.options;
    }

    static {
        for (String mode : new String[]{"EXACT", "KEYWORD", "REGEXP"}) {
            theMap.put("SW_SEARCH_TEXT:" + mode, new TreeSet());
        }
        CoreEvents.registerProjectChangeListener(new SearchWindow.SearchesLoader<Set<String>>("DirectorySearchWindow", theMap));
    }
}

