/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.segmentation;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.ExceptionListener;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import org.omegat.core.Core;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.SRX;
import org.omegat.core.segmentation.datamodels.MappingRulesModel;
import org.omegat.core.segmentation.datamodels.SegmentationRulesModel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.OmegaTFileChooser;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class SegmentationCustomizer
extends JDialog
implements ListSelectionListener {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private SRX defaultSRX;
    private SRX userSRX;
    private SRX projectSRX;
    private SRX editableSRX;
    private boolean isProjectSpecific;
    private JButton btnImport;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JCheckBox cbCascade;
    private JCheckBox cbFhEnd;
    private JCheckBox cbFhIsolated;
    private JCheckBox cbFhStart;
    private JPanel extraOptionsPanel;
    private JTextArea hintTextArea;
    private JLabel jLabel1;
    private JButton mapDeleteButton;
    private JButton mapDownButton;
    private JLabel mapErrorsLabel;
    private JButton mapInsertButton;
    private JPanel mapPanel;
    private JScrollPane mapScrollPane;
    private JTable mapTable;
    private JButton mapUpButton;
    private JButton okButton;
    private JCheckBox optNbsp;
    private JCheckBox optUseFormatHandles;
    private JPanel pFHandles;
    private JCheckBox projectSpecificCB;
    private JButton ruleDeleteButton;
    private JButton ruleDownButton;
    private JLabel ruleErrorsLabel;
    private JButton ruleInsertButton;
    private JPanel rulePanel;
    private JScrollPane ruleScrollPane;
    private JTable ruleTable;
    private JButton ruleUpButton;
    private JPanel srxOptionsPanel;
    private JButton toDefaultsButton;
    private int returnStatus = 0;

    private void constructor(boolean projectSpecific, SRX defaultSRX, SRX userSRX, SRX projectSRX) {
        this.isProjectSpecific = projectSpecific;
        this.defaultSRX = defaultSRX;
        this.userSRX = userSRX;
        this.projectSRX = projectSRX;
        this.editableSRX = this.isProjectSpecific && projectSRX != null ? projectSRX.clone() : userSRX.clone();
        StaticUIUtils.setEscapeAction(this, (Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SegmentationCustomizer.this.cancelButtonActionPerformed(null);
            }
        });
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        this.mapTable.getSelectionModel().addListSelectionListener(this);
        this.ruleTable.getSelectionModel().addListSelectionListener(this);
        MappingRulesModel model = (MappingRulesModel)this.mapTable.getModel();
        model.addExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                SegmentationCustomizer.this.mapErrorsLabel.setText(e.getLocalizedMessage());
            }
        });
        if (this.isProjectSpecific) {
            this.setTitle(OStrings.getString("GUI_SEGMENTATION_TITLE_PROJECTSPECIFIC"));
        } else {
            this.projectSpecificCB.setVisible(false);
        }
        if (projectSpecific && projectSRX == null) {
            this.mapTable.setEnabled(false);
            this.mapTable.setFocusable(false);
            this.mapInsertButton.setEnabled(false);
            this.toDefaultsButton.setEnabled(false);
        } else {
            if (projectSpecific) {
                this.projectSpecificCB.setSelected(true);
            }
            this.mapTable.setEnabled(true);
            this.mapTable.setFocusable(true);
            this.mapInsertButton.setEnabled(true);
            this.toDefaultsButton.setEnabled(true);
        }
        this.pack();
        this.setSize(this.getWidth() * 5 / 4, this.getHeight() * 5 / 4);
        DockingUI.displayCentered(this);
        this.setOptions(this.editableSRX);
    }

    public SegmentationCustomizer(Frame parent, boolean projectSpecific, SRX defaultSRX, SRX userSRX, SRX projectSRX) {
        super(parent, true);
        this.constructor(projectSpecific, defaultSRX, userSRX, projectSRX);
    }

    public SegmentationCustomizer(Dialog parent, boolean projectSpecific, SRX defaultSRX, SRX userSRX, SRX projectSRX) {
        super(parent, true);
        this.constructor(projectSpecific, defaultSRX, userSRX, projectSRX);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public SRX getSRX() {
        return this.editableSRX;
    }

    public boolean isProjectSpecific() {
        return this.projectSpecificCB.isSelected();
    }

    protected void setEditableSRX(SRX srx) {
        this.editableSRX = srx.clone();
        MappingRulesModel model = new MappingRulesModel(this.editableSRX);
        this.mapTable.setModel(model);
        model.addExceptionListener(new ExceptionListener(){

            @Override
            public void exceptionThrown(Exception e) {
                SegmentationCustomizer.this.mapErrorsLabel.setText(e.getLocalizedMessage());
            }
        });
        this.ruleTable.setModel(new DefaultTableModel());
        this.setOptions(srx);
    }

    private void setOptions(SRX srx) {
        this.cbCascade.setSelected(srx.isCascade());
        this.cbFhStart.setSelected(srx.isIncludeStartingTags());
        this.cbFhEnd.setSelected(srx.isIncludeEndingTags());
        this.cbFhIsolated.setSelected(srx.isIncludeIsolatedTags());
        if (this.isProjectSpecific) {
            this.optUseFormatHandles.setSelected(Core.getProject().getProjectProperties().isTagsFormatHandles());
            this.optNbsp.setSelected(Core.getProject().getProjectProperties().isSegmentNbsp());
        } else {
            this.optUseFormatHandles.setSelected(Preferences.isPreferenceDefault("seg_use_tags_as_formathandles", false));
            this.optNbsp.setSelected(Preferences.isPreferenceDefault("seg_accept_nbsp", false));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        ListSelectionModel lsm = (ListSelectionModel)e.getSource();
        if (e.getSource() == this.mapTable.getSelectionModel()) {
            this.mapErrorsLabel.setText("");
            if (lsm.isSelectionEmpty()) {
                this.mapDeleteButton.setEnabled(false);
                this.mapUpButton.setEnabled(false);
                this.mapDownButton.setEnabled(false);
                this.ruleTable.setModel(new DefaultTableModel());
                this.ruleInsertButton.setEnabled(false);
            } else {
                this.mapDeleteButton.setEnabled(true);
                int selrow = this.mapTable.getSelectedRow();
                int rows = this.mapTable.getRowCount();
                if (selrow > 0) {
                    this.mapUpButton.setEnabled(true);
                } else {
                    this.mapUpButton.setEnabled(false);
                }
                if (selrow < rows - 1) {
                    this.mapDownButton.setEnabled(true);
                } else {
                    this.mapDownButton.setEnabled(false);
                }
                MapRule maprule = this.editableSRX.getMappingRules().get(selrow);
                SegmentationRulesModel model = new SegmentationRulesModel(maprule.getRules());
                this.ruleTable.setModel(model);
                model.addExceptionListener(new ExceptionListener(){

                    @Override
                    public void exceptionThrown(Exception e) {
                        SegmentationCustomizer.this.ruleErrorsLabel.setText(e.getLocalizedMessage());
                    }
                });
                this.ruleInsertButton.setEnabled(true);
            }
        } else if (e.getSource() == this.ruleTable.getSelectionModel()) {
            this.ruleErrorsLabel.setText("");
            if (lsm.isSelectionEmpty()) {
                this.ruleDeleteButton.setEnabled(false);
                this.ruleUpButton.setEnabled(false);
                this.ruleDownButton.setEnabled(false);
            } else {
                this.ruleDeleteButton.setEnabled(true);
                int rules = this.ruleTable.getRowCount();
                int rulerow = this.ruleTable.getSelectedRow();
                if (rulerow > 0) {
                    this.ruleUpButton.setEnabled(true);
                } else {
                    this.ruleUpButton.setEnabled(false);
                }
                if (rulerow < rules - 1) {
                    this.ruleDownButton.setEnabled(true);
                } else {
                    this.ruleDownButton.setEnabled(false);
                }
            }
        }
    }

    private void commitTableEdits() {
        if (this.mapTable.getCellEditor() != null) {
            this.mapTable.getCellEditor().stopCellEditing();
        }
        if (this.ruleTable.getCellEditor() != null) {
            this.ruleTable.getCellEditor().stopCellEditing();
        }
    }

    private void initComponents() {
        this.buttonPanel = new JPanel();
        this.btnImport = new JButton();
        this.toDefaultsButton = new JButton();
        this.jLabel1 = new JLabel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.extraOptionsPanel = new JPanel();
        this.optUseFormatHandles = new JCheckBox();
        this.optNbsp = new JCheckBox();
        this.srxOptionsPanel = new JPanel();
        this.cbCascade = new JCheckBox();
        this.pFHandles = new JPanel();
        this.cbFhStart = new JCheckBox();
        this.cbFhEnd = new JCheckBox();
        this.cbFhIsolated = new JCheckBox();
        this.mapPanel = new JPanel();
        this.mapScrollPane = new JScrollPane();
        this.mapTable = new JTable();
        this.mapUpButton = new JButton();
        this.mapDeleteButton = new JButton();
        this.mapInsertButton = new JButton();
        this.mapDownButton = new JButton();
        this.hintTextArea = new JTextArea();
        this.mapErrorsLabel = new JLabel();
        this.projectSpecificCB = new JCheckBox();
        this.rulePanel = new JPanel();
        this.ruleScrollPane = new JScrollPane();
        this.ruleTable = new JTable();
        this.ruleUpButton = new JButton();
        this.ruleDeleteButton = new JButton();
        this.ruleInsertButton = new JButton();
        this.ruleDownButton = new JButton();
        this.ruleErrorsLabel = new JLabel();
        this.setTitle(OStrings.getString("GUI_SEGMENTATION_TITLE"));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                SegmentationCustomizer.this.closeDialog(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.buttonPanel.setLayout(new FlowLayout(2));
        Mnemonics.setLocalizedText(this.btnImport, "Import");
        this.btnImport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.btnImportActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.btnImport);
        Mnemonics.setLocalizedText(this.toDefaultsButton, OStrings.getString("BUTTON_TO_DEFAULTS"));
        this.toDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.toDefaultsButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.toDefaultsButton);
        this.jLabel1.setPreferredSize(new Dimension(20, 0));
        this.buttonPanel.add(this.jLabel1);
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.okButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.cancelButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.buttonPanel, gridBagConstraints);
        this.extraOptionsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createTitledBorder("Non-SRX options:")));
        this.extraOptionsPanel.setLayout(new GridLayout(2, 0));
        Mnemonics.setLocalizedText(this.optUseFormatHandles, "Consider OmegaT tags as format handles");
        this.extraOptionsPanel.add(this.optUseFormatHandles);
        Mnemonics.setLocalizedText(this.optNbsp, "Consider non-break spaces as normal");
        this.optNbsp.setName("optNbsp");
        this.extraOptionsPanel.add(this.optNbsp);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.getContentPane().add((Component)this.extraOptionsPanel, gridBagConstraints);
        this.extraOptionsPanel.getAccessibleContext().setAccessibleName("Non-SRX extra options:");
        this.srxOptionsPanel.setBorder(BorderFactory.createTitledBorder("SRX options:"));
        Mnemonics.setLocalizedText(this.cbCascade, "Cascade");
        this.srxOptionsPanel.add(this.cbCascade);
        this.pFHandles.setBorder(BorderFactory.createTitledBorder("Format handles"));
        Mnemonics.setLocalizedText(this.cbFhStart, "Start");
        this.pFHandles.add(this.cbFhStart);
        Mnemonics.setLocalizedText(this.cbFhEnd, "End");
        this.pFHandles.add(this.cbFhEnd);
        Mnemonics.setLocalizedText(this.cbFhIsolated, "Isolated");
        this.pFHandles.add(this.cbFhIsolated);
        this.srxOptionsPanel.add(this.pFHandles);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.srxOptionsPanel, gridBagConstraints);
        this.srxOptionsPanel.getAccessibleContext().setAccessibleName("SRX Options");
        this.mapPanel.setBorder(BorderFactory.createTitledBorder(OStrings.getString("GUI_SEGMENTATION_RULESETS")));
        this.mapPanel.setLayout(new GridBagLayout());
        this.mapScrollPane.setPreferredSize(new Dimension(300, 100));
        this.mapTable.setModel(new MappingRulesModel(this.editableSRX));
        this.mapScrollPane.setViewportView(this.mapTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText(this.mapUpButton, OStrings.getString("GUI_SEGMENTATION_BUTTON_UP_1"));
        this.mapUpButton.setEnabled(false);
        this.mapUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.mapUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.mapDeleteButton, OStrings.getString("BUTTON_REMOVE"));
        this.mapDeleteButton.setEnabled(false);
        this.mapDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.mapDeleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapDeleteButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.mapInsertButton, OStrings.getString("BUTTON_ADD_NODOTS"));
        this.mapInsertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.mapInsertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapInsertButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.mapDownButton, OStrings.getString("GUI_SEGMENTATION_BUTTON_DOWN_1"));
        this.mapDownButton.setEnabled(false);
        this.mapDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.mapDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.mapDownButton, gridBagConstraints);
        this.hintTextArea.setEditable(false);
        this.hintTextArea.setFont(new JLabel().getFont());
        this.hintTextArea.setLineWrap(true);
        this.hintTextArea.setText(OStrings.getString("GUI_SEGMENTATION_NOTE"));
        this.hintTextArea.setWrapStyleWord(true);
        this.hintTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mapPanel.add((Component)this.hintTextArea, gridBagConstraints);
        this.mapErrorsLabel.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.mapPanel.add((Component)this.mapErrorsLabel, gridBagConstraints);
        Mnemonics.setLocalizedText(this.projectSpecificCB, OStrings.getString("PP_CHECKBOX_PROJECT_SPECIFIC_SEGMENTATION_RULES"));
        this.projectSpecificCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.projectSpecificCBActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.mapPanel.add((Component)this.projectSpecificCB, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.5;
        this.getContentPane().add((Component)this.mapPanel, gridBagConstraints);
        this.rulePanel.setBorder(BorderFactory.createTitledBorder(OStrings.getString("GUI_SEGMENTATION_RULEORDER")));
        this.rulePanel.setLayout(new GridBagLayout());
        this.ruleScrollPane.setPreferredSize(new Dimension(300, 120));
        this.ruleScrollPane.setViewportView(this.ruleTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleScrollPane, gridBagConstraints);
        Mnemonics.setLocalizedText(this.ruleUpButton, OStrings.getString("GUI_SEGMENTATION_BUTTON_UP_2"));
        this.ruleUpButton.setEnabled(false);
        this.ruleUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.ruleUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.ruleDeleteButton, OStrings.getString("BUTTON_REMOVE_2"));
        this.ruleDeleteButton.setEnabled(false);
        this.ruleDeleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.ruleDeleteButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleDeleteButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.ruleInsertButton, OStrings.getString("BUTTON_ADD_NODOTS2"));
        this.ruleInsertButton.setEnabled(false);
        this.ruleInsertButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.ruleInsertButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleInsertButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.ruleDownButton, OStrings.getString("GUI_SEGMENTATION_BUTTON_DOWN_2"));
        this.ruleDownButton.setEnabled(false);
        this.ruleDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SegmentationCustomizer.this.ruleDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.rulePanel.add((Component)this.ruleDownButton, gridBagConstraints);
        this.ruleErrorsLabel.setForeground(new Color(255, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 2, 0, 2);
        this.rulePanel.add((Component)this.ruleErrorsLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.rulePanel, gridBagConstraints);
    }

    private void projectSpecificCBActionPerformed(ActionEvent evt) {
        if (this.projectSpecificCB.isSelected()) {
            this.mapTable.setEnabled(true);
            this.mapTable.setFocusable(true);
            this.mapInsertButton.setEnabled(true);
            this.toDefaultsButton.setEnabled(true);
            this.setEditableSRX(this.editableSRX);
        } else {
            this.mapTable.setEnabled(false);
            this.mapTable.setFocusable(false);
            this.mapInsertButton.setEnabled(false);
            this.toDefaultsButton.setEnabled(false);
            this.setEditableSRX(this.userSRX);
        }
    }

    private void toDefaultsButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        this.setEditableSRX(this.defaultSRX);
    }

    private void ruleDownButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        SegmentationRulesModel model = (SegmentationRulesModel)this.ruleTable.getModel();
        int selrow = this.ruleTable.getSelectedRow();
        model.moveRowDown(selrow);
        this.ruleTable.getSelectionModel().clearSelection();
        this.ruleTable.getSelectionModel().addSelectionInterval(selrow + 1, selrow + 1);
    }

    private void ruleUpButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        SegmentationRulesModel model = (SegmentationRulesModel)this.ruleTable.getModel();
        int selrow = this.ruleTable.getSelectedRow();
        model.moveRowUp(selrow);
        this.ruleTable.getSelectionModel().clearSelection();
        this.ruleTable.getSelectionModel().addSelectionInterval(selrow - 1, selrow - 1);
    }

    private void ruleDeleteButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        SegmentationRulesModel model = (SegmentationRulesModel)this.ruleTable.getModel();
        model.removeRow(this.ruleTable.getSelectedRow());
    }

    private void mapDownButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        MappingRulesModel model = (MappingRulesModel)this.mapTable.getModel();
        int selrow = this.mapTable.getSelectedRow();
        model.moveRowDown(selrow);
        this.mapTable.getSelectionModel().clearSelection();
        this.mapTable.getSelectionModel().addSelectionInterval(selrow + 1, selrow + 1);
    }

    private void mapUpButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        MappingRulesModel model = (MappingRulesModel)this.mapTable.getModel();
        int selrow = this.mapTable.getSelectedRow();
        model.moveRowUp(selrow);
        this.mapTable.getSelectionModel().clearSelection();
        this.mapTable.getSelectionModel().addSelectionInterval(selrow - 1, selrow - 1);
    }

    private void mapDeleteButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        MappingRulesModel model = (MappingRulesModel)this.mapTable.getModel();
        String set = model.getValueAt(this.mapTable.getSelectedRow(), 0).toString();
        String title = OStrings.getString("CONFIRM_DIALOG_TITLE");
        String message = StringUtil.format(OStrings.getString("SEG_CONFIRM_REMOVE_SENTSEG_SET"), set);
        if (JOptionPane.showConfirmDialog(this, message, title, 0) == 0) {
            model.removeRow(this.mapTable.getSelectedRow());
        }
    }

    private void ruleInsertButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        SegmentationRulesModel model = (SegmentationRulesModel)this.ruleTable.getModel();
        model.addRow();
        this.ruleTable.changeSelection(this.ruleTable.getRowCount() - 1, 0, false, false);
        this.ruleTable.changeSelection(this.ruleTable.getRowCount() - 1, this.ruleTable.getColumnCount() - 1, false, true);
    }

    private void mapInsertButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        MappingRulesModel model = (MappingRulesModel)this.mapTable.getModel();
        model.addRow();
        this.mapTable.changeSelection(this.mapTable.getRowCount() - 1, 0, false, false);
        this.mapTable.changeSelection(this.mapTable.getRowCount() - 1, this.mapTable.getColumnCount() - 1, false, true);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.commitTableEdits();
        this.editableSRX.setCascade(this.cbCascade.isSelected());
        this.editableSRX.setIncludeStartingTags(this.cbFhStart.isSelected());
        this.editableSRX.setIncludeEndingTags(this.cbFhEnd.isSelected());
        this.editableSRX.setIncludeIsolatedTags(this.cbFhIsolated.isSelected());
        if (this.isProjectSpecific) {
            Core.getProject().getProjectProperties().setTagsFormatHandles(this.optUseFormatHandles.isSelected());
            Core.getProject().getProjectProperties().setSegmentNbsp(this.optNbsp.isSelected());
        } else {
            Preferences.setPreference("seg_use_tags_as_formathandles", this.optUseFormatHandles.isSelected());
            Preferences.setPreference("seg_accept_nbsp", this.optNbsp.isSelected());
        }
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    private void btnImportActionPerformed(ActionEvent evt) {
        OmegaTFileChooser chooser = new OmegaTFileChooser();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.addChoosableFileFilter(new FileNameExtensionFilter("Segmentation rules", "srx", "conf", "cscx"));
        if (chooser.showOpenDialog(this) == 0) {
            try {
                File chosen = chooser.getSelectedFile();
                String extension = chosen.getName();
                extension = extension.substring(extension.lastIndexOf(46));
                if (this.isProjectSpecific) {
                    Files.copy(chosen.toPath(), Paths.get(Core.getProject().getProjectProperties().getProjectInternal(), "segmentation" + extension), new CopyOption[0]);
                } else {
                    Files.copy(chosen.toPath(), Paths.get(StaticUtils.getConfigDir(), "segmentation" + extension), new CopyOption[0]);
                }
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(this, ex.getMessage(), "ERROR", 0);
            }
        }
        this.doClose(1);
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

