/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXDateParser;
import org.omegat.util.TagUtil;

@Deprecated
public class TMXWriter {
    public static void buildTMXFile(String filename, boolean forceValidTMX, boolean levelTwo, ProjectProperties m_config, Map<String, PrepareTMXEntry> data) throws IOException {
        String sourceLocale = m_config.getSourceLanguage().toString();
        String targetLocale = m_config.getTargetLanguage().toString();
        String segmenting = m_config.isSentenceSegmentingEnabled() ? "sentence" : "paragraph";
        FileOutputStream fos = new FileOutputStream(filename);
        OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
        PrintWriter out = new PrintWriter(osw);
        String version = OStrings.VERSION;
        if (!OStrings.UPDATE.equals("0")) {
            version = version + "_" + OStrings.UPDATE;
        }
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (levelTwo) {
            out.println("<!DOCTYPE tmx SYSTEM \"tmx14.dtd\">");
        } else {
            out.println("<!DOCTYPE tmx SYSTEM \"tmx11.dtd\">");
        }
        if (levelTwo) {
            out.println("<tmx version=\"1.4\">");
        } else {
            out.println("<tmx version=\"1.1\">");
        }
        out.println("  <header");
        out.println("    creationtool=\"OmegaT\"");
        out.println("    creationtoolversion=\"" + version + "\"");
        out.println("    segtype=\"" + segmenting + "\"");
        out.println("    o-tmf=\"OmegaT TMX\"");
        out.println("    adminlang=\"EN-US\"");
        out.println("    srclang=\"" + sourceLocale + "\"");
        out.println("    datatype=\"plaintext\"");
        out.println("  >");
        out.println("  </header>");
        out.println("  <body>");
        String langAttr = levelTwo ? "xml:lang" : "lang";
        String source = null;
        String target = null;
        String note = null;
        TMXDateParser dateParser = new TMXDateParser();
        for (Map.Entry<String, PrepareTMXEntry> en : data.entrySet()) {
            PrepareTMXEntry transEntry = en.getValue();
            source = forceValidTMX ? TagUtil.stripXmlTags(en.getKey()) : en.getKey();
            target = forceValidTMX ? TagUtil.stripXmlTags(transEntry.translation) : transEntry.translation;
            source = StringUtil.makeValidXML(source);
            target = StringUtil.makeValidXML(target);
            if (transEntry.note != null) {
                note = forceValidTMX ? TagUtil.stripXmlTags(transEntry.note) : transEntry.note;
                note = StringUtil.makeValidXML(note);
            }
            if (levelTwo) {
                source = TMXWriter.makeLevelTwo(source);
                target = TMXWriter.makeLevelTwo(target);
            }
            String changeIdPropertyString = transEntry.changer != null && !"".equals(transEntry.changer) ? " changeid=\"" + transEntry.changer + "\"" : "";
            String changeDatePropertyString = transEntry.changeDate != 0L ? " changedate=\"" + dateParser.getTMXDate(transEntry.changeDate) + "\"" : "";
            out.println("    <tu>");
            out.println("      <tuv " + langAttr + "=\"" + sourceLocale + "\">");
            out.println("        <seg>" + source + "</seg>");
            out.println("      </tuv>");
            out.println("      <tuv " + langAttr + "=\"" + targetLocale + "\"" + changeDatePropertyString + changeIdPropertyString + ">");
            out.println("        <seg>" + target + "</seg>");
            out.println("      </tuv>");
            if (note != null) {
                out.println("      <note>" + note + "</note>");
            }
            out.println("    </tu>");
        }
        out.println("  </body>");
        out.println("</tmx>");
        out.close();
    }

    private static String makeLevelTwo(String segment) {
        boolean paired;
        String tagNumber;
        String tag;
        StringBuilder result = new StringBuilder(segment.length() * 2);
        Matcher match = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)/&gt;").matcher(segment);
        int previousMatchEnd = 0;
        while (match.find()) {
            tag = match.group();
            tagNumber = match.group(1);
            result.append(segment.substring(previousMatchEnd, match.start()));
            result.append("<ph x='");
            result.append(tagNumber);
            result.append("'>");
            result.append(tag);
            result.append("</ph>");
            previousMatchEnd = match.end();
        }
        result.append(segment.substring(previousMatchEnd, segment.length()));
        segment = result.toString();
        result.setLength(0);
        match = Pattern.compile("&lt;[\\S&&[^/\\d]]+(\\d+)&gt;").matcher(segment);
        previousMatchEnd = 0;
        while (match.find()) {
            tag = match.group();
            tagNumber = match.group(1);
            String endTag = "&lt;/" + tag.substring(4);
            paired = segment.indexOf(endTag) > -1;
            result.append(segment.substring(previousMatchEnd, match.start()));
            if (paired) {
                result.append("<bpt i='");
                result.append(tagNumber);
                result.append("'");
            } else {
                result.append("<it pos='begin'");
            }
            result.append(" x='");
            result.append(tagNumber);
            result.append("'>");
            result.append(tag);
            result.append(paired ? "</bpt>" : "</it>");
            previousMatchEnd = match.end();
        }
        result.append(segment.substring(previousMatchEnd, segment.length()));
        segment = result.toString();
        result.setLength(0);
        match = Pattern.compile("&lt;/[\\S&&[^\\d]]+(\\d+)&gt;").matcher(segment);
        previousMatchEnd = 0;
        while (match.find()) {
            tag = match.group();
            tagNumber = match.group(1);
            String startTag = "&lt;" + tag.substring(5);
            paired = segment.indexOf(startTag) > -1;
            result.append(segment.substring(previousMatchEnd, match.start()));
            result.append(paired ? "<ept i='" : "<it pos='end' x='");
            result.append(tagNumber);
            result.append("'>");
            result.append(tag);
            result.append(paired ? "</ept>" : "</it>");
            previousMatchEnd = match.end();
        }
        result.append(segment.substring(previousMatchEnd, segment.length()));
        return result.toString();
    }
}

