<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xliff="urn:oasis:names:tc:xliff:document:1.2"
	exclude-result-prefixes="xliff">

	<xsl:param name="srcLang" />
	<xsl:param name="traLang" />
	
	<xsl:template match="/">
		<tmx version="1.1">
		  <header creationtool="OmegaT" o-tmf="OmegaT TMX" adminlang="EN-US" datatype="plaintext" creationtoolversion="3.1.2" segtype="sentence" srclang="en-gb"/>
		  <body>
				<xsl:apply-templates select="//xliff:trans-unit[xliff:seg-source//text()]" />
  		  </body>
		</tmx>
	</xsl:template>
	
	<xsl:template match="xliff:trans-unit">
		<xsl:for-each select="xliff:seg-source//xliff:mrk">	
			<tu>
			  <tuv lang="{$srcLang}">
				<seg><xsl:apply-templates /></seg>
			  </tuv>
			  <tuv lang="{$traLang}">
				<seg>
					<xsl:variable name="id" select="@mid" />
					<xsl:apply-templates select="ancestor::xliff:trans-unit//xliff:target//xliff:mrk[@mid = $id]/node()" />
				</seg>
			  </tuv>
			</tu>	
		</xsl:for-each>
	</xsl:template>
	
	<xsl:template match="xliff:g">
		<xsl:apply-templates />
	</xsl:template>
	
</xsl:stylesheet>