/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.patterns.Element;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;

class PatternRuleXmlCreator {
    PatternRuleXmlCreator() {
    }

    public final String toXML(PatternRule rule) {
        StringBuilder sb = new StringBuilder();
        sb.append("<rule id=\"");
        sb.append(StringTools.escapeXML(rule.getId()));
        sb.append("\" name=\"");
        sb.append(StringTools.escapeXML(rule.getDescription()));
        sb.append("\">\n");
        sb.append("<pattern mark_from=\"");
        sb.append(rule.startPositionCorrection);
        sb.append("\" mark_to=\"");
        sb.append(rule.endPositionCorrection);
        sb.append('\"');
        if (!rule.patternElements.isEmpty() && ((Element)rule.patternElements.get(0)).getCaseSensitive()) {
            sb.append(" case_sensitive=\"yes\"");
        }
        sb.append(">\n");
        for (Element element : rule.patternElements) {
            sb.append("<token");
            if (element.getNegation()) {
                sb.append(" negate=\"yes\"");
            }
            if (element.isRegularExpression()) {
                sb.append(" regexp=\"yes\"");
            }
            if (element.getPOStag() != null) {
                sb.append(" postag=\"");
                sb.append(element.getPOStag());
                sb.append('\"');
            }
            if (element.getPOSNegation()) {
                sb.append(" negate_pos=\"yes\"");
            }
            if (element.isInflected()) {
                sb.append(" inflected=\"yes\"");
            }
            sb.append('>');
            if (element.getString() != null) {
                sb.append(StringTools.escapeXML(element.getString()));
            }
            sb.append("</token>\n");
        }
        sb.append("</pattern>\n");
        sb.append("<message>");
        sb.append(StringTools.escapeXML(rule.getMessage()));
        sb.append("</message>\n");
        if (rule.getIncorrectExamples() != null) {
            for (IncorrectExample incorrectExample : rule.getIncorrectExamples()) {
                sb.append("<example type=\"incorrect\">");
                sb.append(StringTools.escapeXML(incorrectExample.getExample()));
                sb.append("</example>\n");
            }
        }
        if (rule.getCorrectExamples() != null) {
            for (String string : rule.getCorrectExamples()) {
                sb.append("<example type=\"correct\">");
                sb.append(StringTools.escapeXML(string));
                sb.append("</example>\n");
            }
        }
        sb.append("</rule>");
        return sb.toString();
    }
}

