/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.ca;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.languagetool.Language;
import org.languagetool.rules.spelling.morfologik.MorfologikSpellerRule;

public final class MorfologikCatalanSpellerRule
extends MorfologikSpellerRule {
    private static final String RESOURCE_FILENAME = "/ca/catalan.dict";
    private static final Pattern CHAR_PAIRS = Pattern.compile("ou|uo|bv|vb", 66);

    public MorfologikCatalanSpellerRule(ResourceBundle messages, Language language) throws IOException {
        super(messages, language);
        this.setIgnoreTaggedWords();
    }

    public String getFileName() {
        return RESOURCE_FILENAME;
    }

    public String getId() {
        return "MORFOLOGIK_RULE_CA_ES";
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        String wordWithoutDiacritics = MorfologikCatalanSpellerRule.removeAccents((String)word).toLowerCase(this.conversionLocale);
        List<String> moreSuggestions = new ArrayList();
        if (suggestions.size() < 5 && !word.equals(wordWithoutDiacritics)) {
            moreSuggestions = this.speller.getSuggestions(wordWithoutDiacritics);
            if (!this.speller.isMisspelled(wordWithoutDiacritics)) {
                moreSuggestions.add(wordWithoutDiacritics);
            }
        }
        for (String moreSuggestion : moreSuggestions) {
            if (suggestions.contains(moreSuggestion)) continue;
            suggestions.add(moreSuggestion);
        }
        return suggestions;
    }

    protected List<String> orderSuggestions(List<String> suggestions, String word) {
        ArrayList<String> orderedSuggestions1 = new ArrayList<String>();
        ArrayList<String> orderedSuggestions2 = new ArrayList<String>();
        String myWord = MorfologikCatalanSpellerRule.removeAccents((String)word);
        for (String suggestion : suggestions) {
            int diffIdx = StringUtils.indexOfDifference((String)suggestion, (String)myWord);
            String dif = "";
            if (diffIdx < 0) {
                orderedSuggestions1.add(suggestion);
                continue;
            }
            if (diffIdx < myWord.length() && diffIdx < suggestion.length() && myWord.substring(diffIdx + 1, myWord.length()).equals(suggestion.substring(diffIdx + 1, suggestion.length()))) {
                dif = myWord.substring(diffIdx, diffIdx + 1);
                Matcher mCharPairs = CHAR_PAIRS.matcher(dif = dif + suggestion.substring(diffIdx, diffIdx + 1));
                if (mCharPairs.matches()) {
                    orderedSuggestions1.add(suggestion);
                    continue;
                }
                orderedSuggestions2.add(suggestion);
                continue;
            }
            orderedSuggestions2.add(suggestion);
        }
        ArrayList<String> orderedSuggestions = new ArrayList<String>();
        orderedSuggestions.addAll(orderedSuggestions1);
        orderedSuggestions.addAll(orderedSuggestions2);
        return orderedSuggestions;
    }
}

