/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.tagging.ca;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import morfologik.stemming.Dictionary;
import morfologik.stemming.DictionaryLookup;
import org.languagetool.AnalyzedToken;
import org.languagetool.JLanguageTool;
import org.languagetool.tagging.BaseTagger;

public class CatalanTagger
extends BaseTagger {
    private static final String DICT_FILENAME = "/ca/catalan.dict";
    private static final Pattern ADJ_PART_FS = Pattern.compile("VMP00SF.|A[QO]0[FC][SN].");
    private static final Pattern VERB = Pattern.compile("V.+");

    public final String getFileName() {
        return DICT_FILENAME;
    }

    public CatalanTagger() {
        this.setLocale(new Locale("ca"));
        this.dontTagLowercaseWithUppercase();
    }

    public boolean existsWord(String word) throws IOException {
        String lowerWord;
        List posTagsFromDict;
        if (this.dictLookup == null) {
            URL url = JLanguageTool.getDataBroker().getFromResourceDirAsUrl(DICT_FILENAME);
            this.dictLookup = new DictionaryLookup(Dictionary.read((URL)url));
        }
        return !(posTagsFromDict = this.dictLookup.lookup((CharSequence)(lowerWord = word.toLowerCase(this.conversionLocale)))).isEmpty() || !(posTagsFromDict = this.dictLookup.lookup((CharSequence)word)).isEmpty();
    }

    public List<AnalyzedToken> additionalTags(String word) {
        Matcher m;
        String posTag;
        List taggerTokens;
        String lowerWord;
        ArrayList<AnalyzedToken> additionalTaggedTokens = new ArrayList<AnalyzedToken>();
        if (word.endsWith("ment")) {
            lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleAdj = lowerWord.replaceAll("^(.+)ment$", "$1");
            taggerTokens = this.asAnalyzedTokenList(possibleAdj, this.dictLookup.lookup((CharSequence)possibleAdj));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = ADJ_PART_FS.matcher(posTag)).matches()) continue;
                additionalTaggedTokens.add(new AnalyzedToken(word, "RG", lowerWord));
                return additionalTaggedTokens;
            }
        }
        if (word.startsWith("auto")) {
            lowerWord = word.toLowerCase(this.conversionLocale);
            String possibleVerb = lowerWord.replaceAll("^auto(.+)$", "$1");
            taggerTokens = this.asAnalyzedTokenList(possibleVerb, this.dictLookup.lookup((CharSequence)possibleVerb));
            for (AnalyzedToken taggerToken : taggerTokens) {
                posTag = taggerToken.getPOSTag();
                if (posTag == null || !(m = VERB.matcher(posTag)).matches()) continue;
                String lemma = "auto".concat(taggerToken.getLemma());
                additionalTaggedTokens.add(new AnalyzedToken(word, posTag, lemma));
            }
            return additionalTaggedTokens;
        }
        return null;
    }
}

