/*
 * Decompiled with CFR 0.152.
 */
package org.madlonkay.supertmxmerge;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JOptionPane;
import org.madlonkay.supertmxmerge.DiffController;
import org.madlonkay.supertmxmerge.data.ITmx;
import org.madlonkay.supertmxmerge.data.ITuv;
import org.madlonkay.supertmxmerge.data.Key;
import org.madlonkay.supertmxmerge.data.MergeAnalysis;
import org.madlonkay.supertmxmerge.data.ResolutionSet;
import org.madlonkay.supertmxmerge.data.ResolutionStrategy;
import org.madlonkay.supertmxmerge.gui.MergeWindow;
import org.madlonkay.supertmxmerge.util.DiffUtil;
import org.madlonkay.supertmxmerge.util.GuiUtil;
import org.madlonkay.supertmxmerge.util.LocString;

public class MergeController
implements Serializable,
ActionListener {
    public static final Logger LOGGER = Logger.getLogger(MergeController.class.getName());
    public static final String PROP_BASETMX = "baseTmx";
    public static final String PROP_LEFTTMX = "leftTmx";
    public static final String PROP_RIGHTTMX = "rightTmx";
    public static final String PROP_CONFLICTCOUNT = "conflictCount";
    public static final String PROP_CONFLICTSARERESOLVED = "conflictsAreResolved";
    private final PropertyChangeSupport propertySupport;
    private ITmx baseTmx;
    private ITmx leftTmx;
    private ITmx rightTmx;
    private final Map<Key, AbstractButton[]> selections = new HashMap<Key, AbstractButton[]>();
    private MergeAnalysis<Key, ITuv> analysis;
    private ResolutionSet resolution;
    private ITmx result;
    private boolean canCancel = true;
    private boolean quiet = false;
    private boolean isTwoWayMerge = false;
    private boolean isModal = false;
    private int listViewThreshold = 5;
    private Window parentWindow = null;
    private final ResolutionStrategy guiResolutionStrategy = new ResolutionStrategy(){

        @Override
        public ResolutionSet resolve(MergeAnalysis<Key, ITuv> analysis, ITmx baseTmx, ITmx leftTmx, ITmx rightTmx) {
            if (analysis.hasConflicts()) {
                Window window = MergeController.this.isModal ? MergeWindow.newAsDialog(MergeController.this, MergeController.this.isTwoWayMerge, MergeController.this.parentWindow) : MergeWindow.newAsFrame(MergeController.this, MergeController.this.isTwoWayMerge);
                GuiUtil.displayWindow(window);
                GuiUtil.blockOnWindow(window);
            }
            if (MergeController.this.isConflictsAreResolved()) {
                return super.resolve(analysis, baseTmx, leftTmx, rightTmx);
            }
            return null;
        }

        @Override
        public ITuv resolveConflict(Key key, ITuv baseTuv, ITuv leftTuv, ITuv rightTuv) {
            AbstractButton[] buttons = (AbstractButton[])MergeController.this.selections.get(key);
            assert (buttons != null);
            switch (this.getSelectionIndex(buttons)) {
                case 0: {
                    return leftTuv;
                }
                case 1: {
                    return baseTuv;
                }
                case 2: {
                    return rightTuv;
                }
            }
            throw new RuntimeException();
        }

        private int getSelectionIndex(AbstractButton[] buttons) {
            int n = 0;
            for (AbstractButton b : buttons) {
                if (b.isSelected()) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    };

    public MergeController() {
        this.propertySupport = new PropertyChangeSupport(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ITmx merge(ITmx baseTmx, ITmx leftTmx, ITmx rightTmx) {
        return this.merge(baseTmx, leftTmx, rightTmx, this.guiResolutionStrategy);
    }

    public ITmx merge(ITmx baseTmx, ITmx leftTmx, ITmx rightTmx, ResolutionStrategy strategy) {
        this.analysis = null;
        this.resolution = null;
        this.result = null;
        this.analyze(baseTmx, leftTmx, rightTmx);
        boolean showDiff = false;
        if (!(this.analysis.hasConflicts() || this.quiet || this.isTwoWayMerge)) {
            showDiff = 0 == JOptionPane.showConfirmDialog(null, LocString.get("STM_NO_CONFLICTS_MESSAGE"), LocString.get("STM_MERGE_WINDOW_TITLE"), 0, 1);
        }
        this.resolve(strategy);
        if (this.resolution == null) {
            return null;
        }
        this.apply(this.resolution);
        if (showDiff) {
            DiffController differ = new DiffController();
            differ.diff(baseTmx, this.result);
        }
        return this.result;
    }

    public MergeAnalysis analyze(ITmx baseTmx, ITmx leftTmx, ITmx rightTmx) {
        this.resolution = null;
        this.result = null;
        this.setBaseTmx(baseTmx);
        this.setLeftTmx(leftTmx);
        this.setRightTmx(rightTmx);
        assert ((this.isTwoWayMerge || baseTmx != null) && leftTmx != null && rightTmx != null);
        MergeAnalysis<Key, ITuv> initialAnalysis = DiffUtil.mapMerge(baseTmx, leftTmx, rightTmx);
        ArrayList<Key> preResolved = new ArrayList<Key>();
        for (Key key : initialAnalysis.conflicts) {
            ITuv selected;
            ITuv baseTuv = (ITuv)baseTmx.get(key);
            ITuv leftTuv = (ITuv)leftTmx.get(key);
            ITuv rightTuv = (ITuv)rightTmx.get(key);
            assert (leftTuv != null || rightTuv != null);
            if (leftTuv == null || rightTuv == null) continue;
            if (leftTuv.equivalentTo(baseTuv)) {
                selected = rightTuv;
            } else if (rightTuv.equivalentTo(baseTuv)) {
                selected = leftTuv;
            } else {
                if (!leftTuv.equivalentTo(rightTuv)) continue;
                selected = rightTuv;
            }
            initialAnalysis.modified.put(key, selected);
            preResolved.add(key);
        }
        initialAnalysis.conflicts.removeAll(preResolved);
        this.analysis = MergeAnalysis.unmodifiableAnalysis(initialAnalysis);
        this.propertySupport.firePropertyChange(PROP_CONFLICTCOUNT, null, null);
        return this.analysis;
    }

    public ResolutionSet resolve(ResolutionStrategy strategy) {
        assert (this.analysis != null);
        this.result = null;
        if (strategy == null) {
            strategy = this.guiResolutionStrategy;
        }
        ResolutionSet initialResolution = strategy.resolve(this.analysis, this.baseTmx, this.leftTmx, this.rightTmx);
        this.resolution = ResolutionSet.unmodifiableSet(initialResolution);
        return initialResolution;
    }

    public ITmx apply(ResolutionSet resolution) {
        if (resolution == null) {
            resolution = this.resolution;
        }
        assert (resolution != null);
        this.result = this.baseTmx.applyChanges(resolution);
        return this.result;
    }

    public boolean isConflictsAreResolved() {
        if (this.analysis != null && this.analysis.conflicts.isEmpty()) {
            return true;
        }
        if (this.selections.isEmpty()) {
            return false;
        }
        for (Map.Entry<Key, AbstractButton[]> e : this.selections.entrySet()) {
            if (this.selectionMade(e.getValue())) continue;
            return false;
        }
        return true;
    }

    private boolean selectionMade(AbstractButton[] buttons) {
        for (AbstractButton b : buttons) {
            if (!b.isSelected()) continue;
            return true;
        }
        return false;
    }

    public void addSelection(Key key, AbstractButton[] buttons) {
        this.selections.put(key, buttons);
    }

    public void clearSelections() {
        this.selections.clear();
        this.actionPerformed(null);
    }

    public Map<Key, AbstractButton[]> getSelections() {
        return Collections.unmodifiableMap(new HashMap<Key, AbstractButton[]>(this.selections));
    }

    public List<ConflictInfo> getConflicts() {
        ArrayList<ConflictInfo> conflicts = new ArrayList<ConflictInfo>();
        for (Key key : this.analysis.conflicts) {
            conflicts.add(new ConflictInfo(key, this.baseTmx.getSourceLanguage(), (ITuv)this.baseTmx.get(key), (ITuv)this.leftTmx.get(key), (ITuv)this.rightTmx.get(key)));
        }
        return conflicts;
    }

    public ITmx getBaseTmx() {
        return this.baseTmx;
    }

    public void setBaseTmx(ITmx baseTmx) {
        ITmx oldBaseTmx = this.baseTmx;
        this.baseTmx = baseTmx;
        this.propertySupport.firePropertyChange(PROP_BASETMX, oldBaseTmx, baseTmx);
    }

    public ITmx getLeftTmx() {
        return this.leftTmx;
    }

    public void setLeftTmx(ITmx leftTmx) {
        ITmx oldLeftTmx = this.leftTmx;
        this.leftTmx = leftTmx;
        this.propertySupport.firePropertyChange(PROP_LEFTTMX, oldLeftTmx, leftTmx);
    }

    public ITmx getRightTmx() {
        return this.rightTmx;
    }

    public void setRightTmx(ITmx rightTmx) {
        ITmx oldRightTmx = this.rightTmx;
        this.rightTmx = rightTmx;
        this.propertySupport.firePropertyChange(PROP_RIGHTTMX, oldRightTmx, rightTmx);
    }

    public int getConflictCount() {
        return this.analysis.conflicts.size();
    }

    public void setCanCancel(boolean canCancel) {
        this.canCancel = canCancel;
    }

    public boolean isCanCancel() {
        return this.canCancel;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setIsTwoWayMerge(boolean isTwoWayMerge) {
        this.isTwoWayMerge = isTwoWayMerge;
    }

    public boolean isTwoWayMerge() {
        return this.isTwoWayMerge;
    }

    public void setIsModal(boolean isModal) {
        this.isModal = isModal;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void setListViewThreshold(int conflicts) {
        if (conflicts < 0) {
            throw new IllegalArgumentException("The list view threshold must be at least 0.");
        }
        this.listViewThreshold = conflicts;
    }

    public int getListViewThreshold() {
        return this.listViewThreshold;
    }

    public void setParentWindow(Window window) {
        this.parentWindow = window;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.propertySupport.firePropertyChange(PROP_CONFLICTSARERESOLVED, null, null);
    }

    public static class ConflictInfo {
        public final Key key;
        public final String sourceLanguage;
        public final String targetLanguage;
        public final String baseTuvText;
        public final String leftTuvText;
        public final String rightTuvText;
        public final Map<String, String> baseTuvProps;
        public final Map<String, String> leftTuvProps;
        public final Map<String, String> rightTuvProps;

        public ConflictInfo(Key key, String sourceLanguage, ITuv baseTuv, ITuv leftTuv, ITuv rightTuv) {
            this.key = key;
            this.sourceLanguage = sourceLanguage;
            this.targetLanguage = baseTuv != null ? baseTuv.getLanguage() : (leftTuv != null ? leftTuv.getLanguage() : (rightTuv != null ? rightTuv.getLanguage() : null));
            this.baseTuvText = baseTuv == null ? null : baseTuv.getContent();
            this.leftTuvText = leftTuv == null ? null : leftTuv.getContent();
            this.rightTuvText = rightTuv == null ? null : rightTuv.getContent();
            this.baseTuvProps = baseTuv == null ? null : baseTuv.getMetadata();
            this.leftTuvProps = leftTuv == null ? null : leftTuv.getMetadata();
            this.rightTuvProps = rightTuv == null ? null : rightTuv.getMetadata();
        }
    }
}

