/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.languagetool.JLanguageTool;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.language.Demo;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.MultiKeyProperties;
import org.languagetool.tools.StringTools;

public abstract class Language {
    public static final Language DEMO = new Demo();
    private static final String PROPERTIES_PATH = "META-INF/org/languagetool/language-module.properties";
    private static final String PROPERTIES_KEY = "languageClasses";
    private static List<Language> externalLanguages = new ArrayList<Language>();
    public static Language[] LANGUAGES = Language.getLanguages();
    public static final Language[] REAL_LANGUAGES = new Language[LANGUAGES.length - 1];
    private static final Language[] BUILTIN_LANGUAGES;
    private static final Disambiguator DEMO_DISAMBIGUATOR;
    private static final Tagger DEMO_TAGGER;
    private static final SentenceTokenizer SENTENCE_TOKENIZER;
    private static final WordTokenizer WORD_TOKENIZER;
    private static final Unifier MATCH_UNIFIER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Language[] getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        HashSet<String> languageClassNames = new HashSet<String>();
        try {
            Enumeration<URL> propertyFiles = Language.class.getClassLoader().getResources(PROPERTIES_PATH);
            while (propertyFiles.hasMoreElements()) {
                URL url = propertyFiles.nextElement();
                InputStream inputStream = url.openStream();
                try {
                    MultiKeyProperties props = new MultiKeyProperties(inputStream);
                    List<String> classNamesStr = props.getProperty(PROPERTIES_KEY);
                    if (classNamesStr == null) {
                        throw new RuntimeException("Key 'languageClasses' not found in " + url);
                    }
                    for (String classNames : classNamesStr) {
                        String[] classNamesSplit;
                        for (String className : classNamesSplit = classNames.split("\\s*,\\s*")) {
                            if (languageClassNames.contains(className)) continue;
                            languages.add(Language.createLanguageObjects(url, className));
                            languageClassNames.add(className);
                        }
                    }
                }
                finally {
                    inputStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        languages.add(DEMO);
        return languages.toArray(new Language[languages.size()]);
    }

    private static Language createLanguageObjects(URL url, String className) {
        try {
            Class<?> aClass = Class.forName(className);
            Constructor<?> constructor = aClass.getConstructor(new Class[0]);
            return (Language)constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class '" + className + "' specified in " + url + " could not be found in classpath", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Object for class '" + className + "' specified in " + url + " could not created", e);
        }
    }

    public abstract String getShortName();

    public abstract String getName();

    public abstract String[] getCountryVariants();

    public abstract Contributor[] getMaintainers();

    public abstract List<Class<? extends Rule>> getRelevantRules();

    public Locale getLocale() {
        return new Locale(this.getShortName());
    }

    public Locale getLocaleWithCountry() {
        if (this.getCountryVariants().length > 0) {
            return new Locale(this.getShortName(), this.getCountryVariants()[0]);
        }
        return this.getLocale();
    }

    public List<String> getRuleFileName() {
        String fileName;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        ruleFiles.add(dataBroker.getRulesDir() + "/" + this.getShortName() + "/" + "grammar.xml");
        if (this.getShortNameWithVariant().length() > 2 && dataBroker.ruleFileExists(fileName = this.getShortName() + "/" + this.getShortNameWithVariant() + "/" + "grammar.xml")) {
            ruleFiles.add(dataBroker.getRulesDir() + "/" + fileName);
        }
        return ruleFiles;
    }

    public Language getDefaultVariant() {
        return null;
    }

    public Disambiguator getDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    public Tagger getTagger() {
        return DEMO_TAGGER;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    public Tokenizer getWordTokenizer() {
        return WORD_TOKENIZER;
    }

    public Synthesizer getSynthesizer() {
        return null;
    }

    public Unifier getUnifier() {
        return MATCH_UNIFIER;
    }

    public Unifier getDisambiguationUnifier() {
        return MATCH_UNIFIER;
    }

    public final String getTranslatedName(ResourceBundle messages) {
        try {
            return messages.getString(this.getShortNameWithVariant());
        }
        catch (MissingResourceException e) {
            try {
                return messages.getString(this.getShortName());
            }
            catch (MissingResourceException e1) {
                return this.getName();
            }
        }
    }

    public final String getShortNameWithVariant() {
        String name = this.getShortName();
        if (this.getCountryVariants().length == 1 && !name.contains("-x-")) {
            name = name + "-" + this.getCountryVariants()[0];
        }
        return name;
    }

    public String[] getUnpairedRuleStartSymbols() {
        return new String[]{"[", "(", "{", "\"", "'"};
    }

    public String[] getUnpairedRuleEndSymbols() {
        return new String[]{"]", ")", "}", "\"", "'"};
    }

    public static void reInit(List<Language> languages) {
        LANGUAGES = new Language[BUILTIN_LANGUAGES.length + languages.size()];
        int i = BUILTIN_LANGUAGES.length;
        System.arraycopy(BUILTIN_LANGUAGES, 0, LANGUAGES, 0, BUILTIN_LANGUAGES.length);
        for (Language lang : languages) {
            Language.LANGUAGES[i++] = lang;
        }
        externalLanguages = languages;
    }

    public static List<Language> getExternalLanguages() {
        return externalLanguages;
    }

    public static List<Language> getAllLanguages() {
        ArrayList<Language> langList = new ArrayList<Language>();
        Collections.addAll(langList, LANGUAGES);
        langList.addAll(externalLanguages);
        return langList;
    }

    public static Language getLanguageForName(String languageName) {
        for (Language element : LANGUAGES) {
            if (!languageName.equals(element.getName())) continue;
            return element;
        }
        return null;
    }

    public static Language getLanguageForShortName(String langCode) {
        Language language = Language.getLanguageForShortNameOrNull(langCode);
        if (language == null) {
            throw new IllegalArgumentException("'" + langCode + "' is not a language code known to LanguageTool. Supported languages: " + Arrays.toString(REAL_LANGUAGES));
        }
        return language;
    }

    public static boolean isLanguageSupported(String langCode) {
        return Language.getLanguageForShortNameOrNull(langCode) != null;
    }

    private static Language getLanguageForShortNameOrNull(String langCode) {
        StringTools.assureSet(langCode, "langCode");
        Language result = null;
        if (langCode.contains("-x-")) {
            for (Language element : LANGUAGES) {
                if (!element.getShortName().equals(langCode)) continue;
                return element;
            }
        } else if (langCode.contains("-")) {
            String[] parts = langCode.split("-");
            if (parts.length != 2) {
                throw new IllegalArgumentException("'" + langCode + "' isn't a valid language code");
            }
            for (Language element : LANGUAGES) {
                if (!parts[0].equals(element.getShortName()) || element.getCountryVariants().length != 1 || !parts[1].equals(element.getCountryVariants()[0])) continue;
                result = element;
                break;
            }
        } else {
            for (Language element : LANGUAGES) {
                if (!langCode.equals(element.getShortName())) continue;
                result = element;
                break;
            }
        }
        return result;
    }

    public static Language getLanguageForLocale(Locale locale) {
        Language language = Language.getLanguageForLanguageNameAndCountry(locale);
        if (language != null) {
            return language;
        }
        Language firstFallbackLanguage = Language.getLanguageForLanguageNameOnly(locale);
        if (firstFallbackLanguage != null) {
            return firstFallbackLanguage;
        }
        for (Language aLanguage : REAL_LANGUAGES) {
            if (!aLanguage.getShortNameWithVariant().equals("en-US")) continue;
            return aLanguage;
        }
        throw new RuntimeException("No appropriate language found, not even en-US. Supported languages: " + Arrays.toString(REAL_LANGUAGES));
    }

    private static Language getLanguageForLanguageNameAndCountry(Locale locale) {
        for (Language language : REAL_LANGUAGES) {
            List<String> countryVariants;
            if (!language.getShortName().equals(locale.getLanguage()) || !(countryVariants = Arrays.asList(language.getCountryVariants())).contains(locale.getCountry())) continue;
            return language;
        }
        return null;
    }

    private static Language getLanguageForLanguageNameOnly(Locale locale) {
        for (Language language : REAL_LANGUAGES) {
            Language defaultVariant;
            if (!language.getShortName().equals(locale.getLanguage()) || !language.hasVariant() || (defaultVariant = language.getDefaultVariant()) == null) continue;
            return defaultVariant;
        }
        for (Language language : REAL_LANGUAGES) {
            if (!language.getShortName().equals(locale.getLanguage()) || language.hasVariant()) continue;
            return language;
        }
        return null;
    }

    public final String toString() {
        return this.getName();
    }

    public static String getAllMaintainers(ResourceBundle messages) {
        StringBuilder maintainersInfo = new StringBuilder();
        ArrayList<String> toSort = new ArrayList<String>();
        for (Language lang : REAL_LANGUAGES) {
            if (lang.isVariant() || lang.getMaintainers() == null) continue;
            ArrayList<String> names = new ArrayList<String>();
            for (Contributor contributor : lang.getMaintainers()) {
                names.add(contributor.getName());
            }
            toSort.add(messages.getString(lang.getShortName()) + ": " + Language.listToStringWithLineBreaks(names));
        }
        Collections.sort(toSort);
        for (String lElem : toSort) {
            maintainersInfo.append(lElem);
            maintainersInfo.append('\n');
        }
        return maintainersInfo.toString();
    }

    public final boolean isVariant() {
        for (Language language : LANGUAGES) {
            boolean skip = language.getShortNameWithVariant().equals(this.getShortNameWithVariant());
            if (skip || !language.getClass().isAssignableFrom(this.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariant() {
        for (Language language : LANGUAGES) {
            boolean skip = language.getShortNameWithVariant().equals(this.getShortNameWithVariant());
            if (skip || !this.getClass().isAssignableFrom(language.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean equalsConsiderVariantsIfSpecified(Language otherLanguage) {
        if (this.getShortName().equals(otherLanguage.getShortName())) {
            boolean thisHasVariant = this.hasCountryVariant();
            boolean otherHasVariant = otherLanguage.hasCountryVariant();
            if (thisHasVariant && otherHasVariant) {
                return this.getShortNameWithVariant().equals(otherLanguage.getShortNameWithVariant());
            }
            return true;
        }
        return false;
    }

    private boolean hasCountryVariant() {
        return this.getCountryVariants().length == 1 && (this.getCountryVariants().length != 1 || !this.getCountryVariants()[0].equals("ANY"));
    }

    private static String listToStringWithLineBreaks(Collection<String> l) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        Iterator<String> iter = l.iterator();
        while (iter.hasNext()) {
            String str = iter.next();
            sb.append(str);
            if (iter.hasNext()) {
                if (i > 0 && i % 3 == 0) {
                    sb.append(",\n    ");
                } else {
                    sb.append(", ");
                }
            }
            ++i;
        }
        return sb.toString();
    }

    static {
        int i = 0;
        for (Language lang : LANGUAGES) {
            if (lang.getShortName().equals("xx")) continue;
            Language.REAL_LANGUAGES[i] = lang;
            ++i;
        }
        BUILTIN_LANGUAGES = LANGUAGES;
        DEMO_DISAMBIGUATOR = new DemoDisambiguator();
        DEMO_TAGGER = new DemoTagger();
        SENTENCE_TOKENIZER = new SentenceTokenizer();
        WORD_TOKENIZER = new WordTokenizer();
        MATCH_UNIFIER = new Unifier();
    }
}

