/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.rules.Category;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class LongSentenceRule
extends Rule {
    private static final int MAX_WORDS = 40;

    public LongSentenceRule(ResourceBundle messages) {
        super(messages);
        super.setCategory(new Category(messages.getString("category_misc")));
        this.setDefaultOff();
    }

    @Override
    public String getDescription() {
        return "Readability: sentence over 40 words";
    }

    @Override
    public String getId() {
        return "TOO_LONG_SENTENCE";
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence text) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = text.getTokensWithoutWhitespace();
        String msg = "Sentence is over 40 words long, consider revising.";
        int numWords = 0;
        int pos = 0;
        if (tokens.length < 41) {
            return this.toRuleMatchArray(ruleMatches);
        }
        for (AnalyzedTokenReadings aToken : tokens) {
            String token = aToken.getToken();
            pos += token.length();
            if (token.matches("[!-~]") || aToken.isSentStart()) continue;
            ++numWords;
        }
        if (numWords > 40) {
            RuleMatch ruleMatch = new RuleMatch(this, 0, pos, "Sentence is over 40 words long, consider revising.");
            ruleMatches.add(ruleMatch);
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public void reset() {
    }
}

