/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.glossaries;

import java.io.File;
import java.util.List;

import org.omegat.util.Language;

/**
 * General class for all file-based glossaries
 * 
 * @author Thomas Cordonnier
 */
public class FileGlossary implements IGlossary {
    private File origin;
    protected List<GlossaryEntryStore> entries; 
    
    /** Get the name used by scripts in location where you have not lot of space **/
    public String getShortName() { return origin.getName(); }
    /** Get the name used by scripts in location where you have lot of space **/
    public String getLongName() { return origin.getPath(); }
    
    /** Indicates that this glossary is taken from a file **/
    public String getEngineName() { return "local file";  }

    /** Only for subclasses **/
    protected FileGlossary(File origin) { this.origin = origin; }
    
    /** Only for subclasses **/
    protected FileGlossary(File origin, List<GlossaryEntryStore> entries) { this.origin = origin; this.entries = entries; }

    /** Only for subclasses **/
    protected File getOriginFile() { return origin; }
    
    /** True if almost one entry have been read. **/
    public boolean hasContents() { return (entries != null) && (entries.size() > 0); }

    /** False, do not exclude this glossary from internal searches. **/
    public boolean isExternal() { return false; }

    /** {@inheritDoc}   Returns all entries, leaving to find thread the role to filter **/
    public List<GlossaryEntryStore> search(Language sLang, Language tLang, String srcText) { return entries; }
}
