/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2015-2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 **************************************************************************/

package org.omegat.core.machinetranslators.dummy;

import org.omegat.gui.editor.EditorUtils;

import org.omegat.gui.exttrans.IMachineTranslation;
import org.omegat.util.Language;

import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Token;
import org.omegat.core.search.PreTranslateSearchResultEntry;
import org.omegat.core.search.SearchMatch;
import org.omegat.core.Core;

import java.util.ArrayList;

/**
 * Translates anything as identical to source. To be used for pseudo-translation
 * 
 * @author Thomas Cordonnier
 */
public class SourceTranslate implements IMachineTranslation {

	private boolean withGlos = false, withGlosOnly = false;

	public SourceTranslate() {}
	
	public SourceTranslate(boolean withGlos, boolean withGlosOnly) { this.withGlos = withGlos; this.withGlosOnly = withGlosOnly; }
	
    public String getName() {
        return "Source" + (withGlos ? " with glossaries" : "");
    }

    public String getTranslation(Language sLang, Language tLang, String text) {
        if (! withGlos) return text;
        String res = EditorUtils.replaceGlossaryEntries(text);
		if (withGlosOnly) if (res.equals(text)) return null;
		return res;
    }

	public void rebuildEntryHighlights (PreTranslateSearchResultEntry entry, String translation, String m_prefix) {
		try {
			ITokenizer tokenizer = Core.getProject().getSourceTokenizer();
			Token[] srcTokens = tokenizer.tokenizeWords(entry.getSrcText(), ITokenizer.StemmingMode.NONE);
			Token[] traTokens = tokenizer.tokenizeWords(translation, ITokenizer.StemmingMode.NONE);
			int i = 0, j = 0; ArrayList<SearchMatch> srcMatches = new ArrayList<SearchMatch>(), traMatches = new ArrayList<SearchMatch>();
			while ((i < srcTokens.length) && (j < traTokens.length)) 
				if (srcTokens[i].equals (traTokens[j])) { i++; j++; }
				else if ((i < srcTokens.length - 1) && srcTokens[i + 1].equals (traTokens[j])) {
					srcMatches.add (new SearchMatch(srcTokens[i].getOffset(), srcTokens[i].getLength() + srcTokens[i].getOffset()));
					i++; // but do not increment j
				}
				else if ((j < traTokens.length - 1) && traTokens[j + 1].equals (srcTokens[i])) {
					traMatches.add (new SearchMatch(traTokens[j].getOffset() + m_prefix.length(), traTokens[j].getLength() + traTokens[j].getOffset()  + m_prefix.length()));
					j++; // but do not increment i
				}
				else {
					srcMatches.add (new SearchMatch(srcTokens[i].getOffset(), srcTokens[i].getLength() + srcTokens[i].getOffset()));
					traMatches.add (new SearchMatch(traTokens[j].getOffset() + m_prefix.length(), traTokens[j].getLength() + traTokens[j].getOffset()  + m_prefix.length()));
					i++; j++;							
				}
			entry.setAllHighlights (srcMatches, traMatches); 
		} catch (Exception eSrc) {
			eSrc.printStackTrace();
		}		
	}
}
