/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2008 Alex Buloichik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching;

import org.omegat.util.Token;

/**
 * Interface for similarity calculator. It require to implement more than one
 * token comparison algorithm.
 * 
 * @author Alex Buloichik
 */
public interface ISimilarityCalculator {
    /**
     * Compute similarity.
     * 
     * @param source
     *            source segment
     * @param target
     *            target segment
     * @return similarity
     */
    int compute(Token[] source, Token[] target);
    
    /**
     * Calculate similarity for tokens arrays(percent).
     * 
     * @param str
     *            original string tokens
     * @param cand
     *            candidate string tokens
     * @return similarity in percents
     */
    default int calcSimilarity(final Token[] str, final Token cand[]) {
        if (str.length == 0 && cand.length == 0) return 0; // empty token lists - can't calculate similarity
        int ld = compute(str, cand);
        int similarity = (100 * (Math.max(str.length, cand.length) - ld)) / Math.max(str.length, cand.length);
        return similarity;
    }    
}
