/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2014 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external.rmi;

import org.omegat.core.data.*;

import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.IEntryCursor;

import java.util.List;
import java.rmi.*;

/**
 * A client for RMI server <br/>
 * Usage: create project_save.properties
 **/
public class Client implements ProjectMemory.IExternalProjectMemory  {

    private IDistantExternalMemory remote;
    private long timeStampDiff;

    public Client (java.util.Properties propList) throws Exception {
        String url = propList.getProperty("url");
        remote = (IDistantExternalMemory) Naming.lookup(url);
        timeStampDiff = remote.timeStamp() - System.currentTimeMillis();
    }

    /** Asks the server for changes **/
    public IEntryCursor findChanges (long timeStamp) throws RemoteException {
        return new IEntryCursor() {
            String id = remote.findChanges (timeStamp + timeStampDiff);
            
	    public boolean next() throws RemoteException { 
	        if (id == null) return false; if (id.length() == 0) return false;
	        return remote.next(id);
	    }
	    
	    public String getEntrySource() throws RemoteException { 
	        return remote.getEntrySource(id);
	    }
	    
	    public String getEntryTranslation() throws RemoteException { 
	        return remote.getEntryTranslation(id);
	    }
	    
	    public String getEntryAuthor() throws RemoteException { 
	        return remote.getEntryAuthor(id);
	    }
	    
	    public String getEntryLastModifier() throws RemoteException { 
	        return remote.getEntryLastModifier(id);
	    }
	    
	    public long getEntryCreationDate() throws RemoteException { 
	        return remote.getEntryCreationDate(id);
	    }
	    
	    public long getEntryLastModificationDate() throws RemoteException { 
	        return remote.getEntryLastModificationDate(id);
	    }
	    
	    public String getEntryNote() throws RemoteException { 
	        return remote.getEntryNote(id);
	    }
	    
	    public boolean nextProperty() throws RemoteException { 
	        return false; // not used, we return entry key directly
	    }
	    
	    public String getCurrentPropertyName() throws RemoteException { 
	        return ""; // not used, we return entry key directly
	    }
	    
	    public String getCurrentPropertyValue() throws RemoteException { 
	        return ""; // not used, we return entry key directly
	    }
	    
	    public EntryKey buildEntryKey() throws RemoteException {
	        String[] info = remote.getEntryKey(id);
	        if (info == null) return null;
	        return new EntryKey(info[0],info[1],info[2],info[3],info[4],info[5]);
	    }
	}; 
    }

    /** Asks the server to register this new translation */
    public void registerTranslation(SourceTextEntry ste, TMXEntry te, boolean isDefault) throws RemoteException {
        if (isDefault)
           if (te == null) remote.registerDefaultTranslation(ste.getSrcText(), null);
           else remote.registerDefaultTranslation(te.source, te.translation);
        else {
           EntryKey key = ste.getKey();
           if (te == null) remote.registerAltTranslation(ste.getSrcText(), null, key.file, key.id, key.path, key.prev, key.next);
           else remote.registerAltTranslation(te.source, te.translation, key.file, key.id, key.path, key.prev, key.next);
        }
    }
}