/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Aaron Madlon-Kay, Alex Buloichik
               2014-2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.glossary;

import java.util.*;

import org.omegat.core.glossaries.GlossaryEntryStore;

/**
 * Result of a merge of several entries <i>made by OmegaT</i> (i.e. not by glossary itself)
 * 
 * @author Keith Godfrey
 * @author Aaron Madlon-Kay
 * @author Alex Buloichik
 * @author Thomas Cordonnier
 */
public class MergedGlossaryEntries extends GlossaryEntryView {
    public MergedGlossaryEntries(String src, Collection<GlossaryEntryStore> entries) {
        super(src); this.entries = entries;
    }
	
	public Collection<GlossaryEntryStore> getMergedEntries() {
		return entries;
	}
	
    public Collection<String> getLocTerms(boolean unique) {
		Collection<String> res = new ArrayList<>(unique ? entries.size() / 3 : entries.size());
		for (GlossaryEntryStore ge: entries)
			if (! res.contains(ge.getLocText())) // cannot use TreeSet because it would break order defined elsewhere
				res.add (ge.getLocText());
		return res;
	}
    
    public Iterable<GlossaryEntryStore> getEntriesFor(String tra) {
        return () -> java.util.stream.StreamSupport.stream(entries.spliterator(), false).filter(entry -> entry.getLocText().equals(tra)).iterator();
    }
	
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
		try {
			GlossaryEntryStore otherStore = (GlossaryEntryStore) o;
			return this.entries.size() == 1 && this.entries.iterator().next().equals(otherStore);
		} catch (ClassCastException cce1) {
			try {
				MergedGlossaryEntries otherView = (MergedGlossaryEntries) o;
				return this.entries.equals(otherView.entries);
			} catch (ClassCastException cce2) {
				return false;
			}
		}
    }
	
    @Override
    public int hashCode() {
        int hash = 0;
        for (GlossaryEntryStore store: entries) hash += store.hashCode();
        return hash;
    }	

    public boolean hasPriorities() {
        for (GlossaryEntryStore ge: entries) if (ge.getPriority()) return true;
		return false;
    }

    public boolean hasPriorities(String tra) {
        for (GlossaryEntryStore ge: entries) if (ge.getPriority() && ge.getLocText().equals(tra)) return true;
		return false;
    }
    
	private Collection<GlossaryEntryStore> entries;
}
