/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2008 Alex Buloichik
               2011 Didier Briel
               2016 Aaron Madlon-Kay
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.main;

import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JCheckBoxMenuItem;

/**
 * Main menu interface.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Didier Briel
 * @author Aaron Madlon-Kay
 */
public interface IMainMenu {
    JMenu getMachineTranslationMenu();
    
    JMenu getTranslationMemoriesMenu();

    JMenu getOptionsMenu();

    JMenu getToolsMenu();

    JMenu getGlossaryMenu();

    JMenu getProjectMenu();
    
    JMenuItem getProjectRecentMenuItem();

    JMenu getAutoCompletionMenu();
	
	JCheckBoxMenuItem getRevisionMenuItem();
	
	void updateHistoryMenus(boolean hasPrev, boolean hasNext);
	
	void updateEditMultipleMenus(boolean active);
}
