/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Contributor(s):
 *   Aaron Madlon-Kay
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

package org.mozilla.universalchardet;

import static org.junit.Assert.*;

import java.io.IOException;
import java.io.InputStream;

import org.junit.Test;

public class UniversalDetectorTest {

    @Test
    public void test() throws IOException {
        assertEquals("UTF-8", detectEncoding("utf8.txt"));
        assertEquals("UTF-8", detectEncoding("utf8n.txt"));
        assertEquals("UTF-16LE", detectEncoding("utf16le.txt"));
        assertEquals("SHIFT_JIS", detectEncoding("shiftjis.txt"));
        assertEquals("ISO-2022-JP", detectEncoding("iso2022jp.txt"));
        assertEquals("EUC-JP", detectEncoding("euc.txt"));
        
        assertEquals("BIG5", detectEncoding("big5.txt"));
        assertEquals("EUC-TW", detectEncoding("euctw.txt"));
        assertEquals("EUC-KR", detectEncoding("euckr.txt"));
        assertEquals("GB18030", detectEncoding("gb18030.txt"));
        assertEquals("WINDOWS-1255", detectEncoding("windows1255.txt"));
        
        assertEquals("UTF-8", detectEncoding("utf8n-emoji.txt"));
    }

    private static String detectEncoding(String file) throws IOException {
        UniversalDetector detector = new UniversalDetector(null);
        
        byte[] buf = new byte[4096];
        InputStream is = UniversalDetectorTest.class.getResourceAsStream("/resources/" + file);
        
        int nread;
        while ((nread = is.read(buf)) > 0 && !detector.isDone()) {
            detector.handleData(buf, 0, nread);
        }
        detector.dataEnd();
        is.close();
        
        return detector.getDetectedCharset();
    }
}
