result.appendSource(entry.srcText).append(": ");

def translations  = entry.getLocTerms(true)
def count = translations.size() - 1

translations.each { tra ->
	result.appendTarget(tra, entry.hasPriorities(tra));

	def commentsList = entry.getEntriesFor(tra).collect { it.commentText }.findAll { (it != null) && (it.length() > 0) }.unique()
	if (commentsList.size() > 0) {
        result.append(" ");
		StringBuffer tip = new StringBuffer();
	    for (com in commentsList) {
		    tip.append(com).append ("; "); 
	    }
        result.startHiddenPart("[ ", " ]");
		result.appendComment(tip.toString());
		result.endHiddenPart();
    }
	
	if (count-- > 0) result.append(",");
}

result.append("\n\n");