/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2011 Pavel Kats
               2019 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.glossaries;

import org.omegat.util.Language;

/**
 * Interface for glossary access.
 * 
 * @author Pavel Kats <pavel@glossum.com>
 * @author Thomas Cordonnier
 */
public interface IGlossary {
    // --------------- Meta-data to be given to scripts -------------

    /** 
	 * Returns a string which identifies engine (how data are retrieved) <br/>
     * Should be identical for each instances of the same class
	 **/
    String getEngineName();
	
    /** 
	 * Returns a string which identifies what kind of data the glossary can contain <br/>
	 * For files, it can contain the info about format version or dialect <br/>
	 * For servers, indicates which file type contains same kind of info as in this server <br/>
	 * Default value "3-col" tells us that the glossary contains 3 columns "source, target, comment".
	 **/
    default String getFormat() { return "3-col"; }
	
    /** Get the name used by scripts in location where you have not lot of space **/
    String getShortName();
    /** Get the name used by scripts in location where you have lot of space **/
    String getLongName();

    /** Tests whenever the glossary is external, in which case it may be excluded from some searches. **/
    boolean isExternal();

    // --------------- Search methods -------------

    /** Tests whenever the glossary can return anything. Do not throw exception, return false instead. **/
    boolean hasContents();

    /** Send search to the glossary and retreives results **/
    Iterable<GlossaryEntryStore> search(Language sLang, Language tLang, String srcText) throws Exception;
}
