/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2016 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.machinetranslators;

import java.util.Collections;
import java.util.WeakHashMap;
import java.util.Map;

import org.omegat.util.Language;

/**
 * Base class for machine translation.
 * 
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Didier Briel
 */
public abstract class CachedTranslate extends BaseTranslate {

    /**
     * Machine translation implementation can use this cache for skip requests twice. Cache will not be
     * cleared during OmegaT work, but it's okay - nobody will work weeks without exit.
     */
    private final Map<String, String> cache = Collections.synchronizedMap(new WeakHashMap<String, String>());

    public CachedTranslate() { super(); }

    public String getTranslation(Language sLang, Language tLang, String text) throws Exception {
        String fromCache = getCachedTranslation(sLang, tLang, text);
        if (fromCache != null) return fromCache;
        String result = super.getTranslation(sLang, tLang, text);
        if (result != null) cache.put(sLang + "/" + tLang + "/" + text, result);
        return result;
    }
    
    public String getCachedTranslation(Language sLang, Language tLang, String text) {
        return cache.get(sLang + "/" + tLang + "/" + text);
    }

}
