/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2013 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.matching.external;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.Collections;
import java.util.List;

import javax.swing.JCheckBoxMenuItem;

import org.omegat.core.Core;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.util.Language;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.openide.awt.Mnemonics;

/**
 * Base class for memory which will appear in the options/translation memory menu
 * 
 * @author Thomas Cordonnier
 */
public abstract class MenuMemory implements IExternalMemory, ActionListener {
    protected final JCheckBoxMenuItem menuItem;

    protected boolean enabled;

    public MenuMemory() {
        menuItem = new JCheckBoxMenuItem();
        Mnemonics.setLocalizedText(menuItem, getMemoryName());
        menuItem.addActionListener(this);
        enabled = Preferences.isPreference(getPreferenceName());
        menuItem.setState(enabled);
        javax.swing.JMenu tmMenu = Core.getMainWindow().getMainMenu().getTranslationMemoriesMenu();
        tmMenu.add(menuItem); tmMenu.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        enabled = menuItem.isSelected();
        Preferences.setPreference(getPreferenceName(), enabled);
    }
    
    abstract protected String getPreferenceName();
    
    abstract protected List<PrepareTMXEntry> retreiveMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception;
    
    public List<PrepareTMXEntry> findMatchingTranslations (Language sLang, Language tLang, String text, int minScore, int maxCount) throws Exception {
        if (enabled) 
            return retreiveMatchingTranslations (sLang, tLang, text, minScore, maxCount);
        else
            return (List<PrepareTMXEntry>) Collections.EMPTY_LIST;
    }

}
