/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2018 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.search;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.Date;

import org.omegat.util.TMXProp;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;

/**
 * Entry for cross-source search: contains links between entries
 *
 * @author Thomas Cordonnier
 */
public class CrossSourceSearchResultEntry extends SearchResultEntry {

    private Set<Integer> entries = new TreeSet<>();

    public CrossSourceSearchResultEntry(SourceTextEntry sourceEntry, TMXEntry traEntry, List<SearchMatch> srcMatch) {
        m_srcMatch = srcMatch;
        m_tmxEntry = traEntry;
        m_sourceEntry = sourceEntry;
        entries.add (sourceEntry.entryNum());
    }
	
    public void add (SourceTextEntry entry) { entries.add(entry.entryNum()); }
    
    public Set<Integer> entries() { return entries; }
	
	// -------------------- ongoing entry -----------------------
	
    /**
     * Returns the number of the corresponding entry within a project. The
     * returned value is > 0, as the entry belongs to one of the source files of
     * the project; 
     */
    public int getEntryNum() {
        return m_sourceEntry.entryNum();
    }

    /** Returns information about where this entry comes from. */
    public String getPreamble() {
        return "" + getEntryNum() + getMoreString();
    }
    
    /** Returns the source text of the corresponding entry within a project. */
    public String getSrcText() {
        return  m_sourceEntry.getSrcText();
    }

    /** Returns the target text of the corresponding entry within a project. */
    public String getTranslation() {
        return m_tmxEntry.translation == null ?  "" : m_tmxEntry.translation;
    }

    /** Returns the note text of the corresponding entry within a project. */
    public String getNote() {
        return m_tmxEntry.note == null ?  "" : m_tmxEntry.note;
    }

    public String getFileName() {
        return m_sourceEntry.getKey().file;
    }
    
    public String getAuthor() {
        return m_tmxEntry.creator == null ?  "" : m_tmxEntry.creator;
    }

    public Date getDate() {
        return new Date (m_tmxEntry.creationDate);
    }

    public List<TMXProp> getProperties() {
        return java.util.Collections.emptyList();
    }
    
    public String getRevisor() {
        return m_tmxEntry.revisor;
    }	
	
    public List<SearchMatch> getSrcMatch() {
        return m_srcMatch;
    }

    public List<SearchMatch> getTargetMatch() {
        return null;
    }

    public List<SearchMatch> getNoteMatch() {
        return null;
    }
		
	private List<SearchMatch> m_highlights;	
	private String m_result; 
    private List<SearchMatch> m_srcMatch;		
    private SourceTextEntry m_sourceEntry;
    private TMXEntry m_tmxEntry;
	
}
