/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2021 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.core.statistics;

/**
 * An object which receives statistics from thread <br/>
 * Should be an UI panel, except when run in a script or command line.
 * 
 * @author Thomas Cordonnier
 */
public interface IStatisticsPanel {
    public void showProgress(int percent);
    public void finishData();    
    public void setTextData(String data);    
    public void setDataFile(String path);
    
    /** Interface for standard statistics **/
    public interface Standard extends IStatisticsPanel {
        public void setProjectTableData(final String[] headers, final String[][] projectData);
        public void setFilesTableData(final String[] headers, final String[][] filesData);
    }
    
    /** Interface for matches statistics **/
    public interface Matches extends IStatisticsPanel {
        public void appendTextData(final String result);
        public void setTable(String[] headers, String[][] data);
        public void appendTable(String title, String[] headers, String[][] data);
    }
}
