/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2017 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.editor.mark;

import java.util.List;

import javax.swing.event.DocumentEvent;

import org.omegat.gui.editor.MarkerController;
import org.omegat.core.data.SourceTextEntry;

/**
 * A marker which avoids to recalculate everything on each document event.
 * 
 * @author Thomas Cordonnier
 */
public interface IFastMarker extends IMarker {
    /** 
     * Indicates which marks should be removed for given event 
     * Note: do not reply null, please reply Collection.EMPTY_LIST instead
     **/
    public List<MarkerController.MarkInfo> toRemove (DocumentEvent ev, List<MarkerController.MarkInfo> ori) throws Exception;
    
    /** 
     * Indicates which marks should be add for given event 
     * Note: do not reply null, please reply Collection.EMPTY_LIST instead
     **/
    public List<Mark> toAdd (DocumentEvent ev) throws Exception;

    /** 
     * Indicates which marks should be removed when translation was replaced by the new one
     * Note: do not reply null, please reply Collection.EMPTY_LIST instead
     **/
    public List<MarkerController.MarkInfo> toRemove (String newTranslation, List<MarkerController.MarkInfo> ori) throws Exception;
    
    /** 
     * Indicates which marks should be added  when translation was replaced by the new one 
     * Note: do not reply null, please reply Collection.EMPTY_LIST instead
     **/
    public List<Mark> toAdd (String newTranslation) throws Exception;
    
}
