/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool
          with fuzzy matching, translation memory, keyword search,
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Wildrich Fourie, Alex Buloichik
               2011 Didier Briel
               2012 Thomas Cordonnier
               2013 Aaron Madlon-Kay
               2015 Thomas Cordonnier
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.gui.glossary;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.text.JTextComponent;

import org.omegat.core.Core;
import org.omegat.gui.editor.PopupMenuDisplayer;
import org.omegat.gui.editor.SegmentBuilder;
import org.omegat.gui.glossary.GlossaryEntryView;
import org.omegat.util.Preferences;
import org.omegat.core.search.TextExpression;
import org.omegat.core.search.SearchMatch;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.gui.search.SearchModeBox;

/**
 * Popup for TransTips processing.
 * 
 * @author W. Fourie
 * @author Alex Buloichik (alex73mail@gmail.com)
 * @author Didier Briel
 * @author Aaron Madlon-Kay
 * @author Thomas Cordonnier
 */
public class TransTipsPopup implements PopupMenuDisplayer.IPopupMenuConstructor {
    public void addItems(final JPopupMenu menu, JTextComponent comp, final int mousepos,
            boolean isInActiveEntry, boolean isInActiveTranslation, SegmentBuilder sb) {
        if (!Preferences.isPreference(Preferences.TRANSTIPS_SUGGEST)) return;
        if (!isInActiveEntry || isInActiveTranslation) return;

        // is mouse in active entry's source ?
        final int startSource = sb.getStartSourcePosition();
        int len = sb.getSourceText().length();
        if (mousepos < startSource || mousepos > startSource + len) {
            return;
        }

        // Test if clicked on a highlighted word
        SearchModeBox dummyBox = new SearchModeBox (0, ITokenizer.StemmingMode.GLOSSARY, null);
        dummyBox.loadPreferences (Preferences.TRANSTIPS + "_");
        
        for (GlossaryEntryView ge : GlossaryTextArea.nowEntries) {
            String phrase = ge.getSrcText();
            if (phrase == null || phrase.equals("")) continue;
                
            TextExpression expr = dummyBox.buildExpression(phrase, false, true);
            java.util.List<SearchMatch> matches = expr.searchString (sb.getSourceText());
            if (matches == null) continue;
            for (SearchMatch found: matches)
                if (startSource + found.getStart() <= mousepos && mousepos <= startSource + found.getEnd()) {
                    // Create the MenuItems
                    for (String s : ge.getLocTerms(true)) {
                        final String txt = s;
                        JMenuItem it = menu.add(txt);
                        it.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {
                                Core.getEditor().insertText(txt);
                            }
                        });
                    }
                }
        }
        menu.addSeparator();
    }
}
