/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2010 Alex Buloichik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/
package org.omegat.gui.glossary;

import org.omegat.core.glossaries.IGlossary;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.omegat.core.TestCore;
import org.omegat.core.glossaries.GlossaryEntryStore;

/**
 * @author Martin Fleurke
 */
public class GlossaryEntryTest extends TestCore {
    public void testRead() throws Exception {
        GlossaryEntryStore a = new GlossaryEntryStore("", "", "", null);
        GlossaryEntryStore b = new GlossaryEntryStore("", "", "", null);
        assertEquals(a, b);

        GlossaryEntryStore c = new GlossaryEntryStore("src", "", "", null);
        GlossaryEntryStore d = new GlossaryEntryStore("src", "", "", null);
        assertEquals(c, d);

        List<GlossaryEntryStore> list = new ArrayList<GlossaryEntryStore>();
        list.add(a);
        assertEquals(1, list.size());
        list.remove(c);
        assertEquals(1, list.size());
        list.remove(b);
        assertEquals(0, list.size());
        list.add(c);
        assertEquals(1, list.size());
        list.remove(d);
        assertEquals(0, list.size());

        list.add(a);
        list.add(b);
        list.add(c);
        list.add(d);
        list.remove(a);
        assertEquals(3, list.size());
        list.remove(a);
        assertEquals(2, list.size());
    }

    public void testToStyledString() {
        GlossaryEntryStore ge = new GlossaryEntryStore("source1", "translation1", "", null);
        assertEquals("source1 = translation1", ge.toStyledString(false).text.toString());
    }

    public void testToStyledStringMultipleTranslations() {
        GlossaryEntryStore gs1 = new GlossaryEntryStore("source1", "translation1", "", null);
        GlossaryEntryStore gs2 = new GlossaryEntryStore("source1", "translation2", "", null);
        MergedGlossaryEntries gv = new MergedGlossaryEntries("source1", Arrays.asList(gs1,gs2));
        assertEquals("source1 = translation1, translation2", gv.toStyledString(false).text.toString());
    }

    public void testToStyledStringWithComment() {
        GlossaryEntryStore ge = new GlossaryEntryStore("source1", "translation1", "comment1", null);
        assertEquals("source1 = translation1\n1. comment1", ge.toStyledString(false).text.toString());
    }

    public void testToStyledStringMultipleComments() {
        GlossaryEntryStore gs1 = new GlossaryEntryStore("source1", "translation1", "comment1", null);
        GlossaryEntryStore gs2 = new GlossaryEntryStore("source1", "translation2", "comment2", null);
        MergedGlossaryEntries gv = new MergedGlossaryEntries("source1", Arrays.asList(gs1,gs2));
        assertEquals("source1 = translation1, translation2\n1. comment1\n2. comment2",
                     gv.toStyledString(false).text.toString());
    }
}
