/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.matching.external.IBrowsableMemory;
import org.omegat.core.matching.external.IEntryCursor;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TMXProp;

public class ImportFromAutoTMX {
    final RealProject project;
    Map<String, List<SourceTextEntry>> existEntries = new HashMap<String, List<SourceTextEntry>>();
    boolean didAnyChange = false;

    public ImportFromAutoTMX(RealProject project, List<SourceTextEntry> allProjectEntries) {
        this.project = project;
        for (SourceTextEntry ste : allProjectEntries) {
            List<SourceTextEntry> list = this.existEntries.get(ste.getSrcText());
            if (list == null) {
                list = new ArrayList<SourceTextEntry>();
                this.existEntries.put(ste.getSrcText(), list);
            }
            list.add(ste);
        }
    }

    protected void findNonUniqueSegments() {
        for (List<SourceTextEntry> L : this.existEntries.values()) {
            if (L.size() < 1) continue;
            L.get((int)0).duplicates = L.subList(1, L.size());
            for (int i = 1; i < L.size(); ++i) {
                L.get((int)i).firstInstance = L.get(0);
            }
        }
    }

    void process(IBrowsableMemory mem, boolean isEnforcedTMX) throws Exception {
        IEntryCursor cursor = mem.browseAllEntries();
        block0: while (cursor.next()) {
            List<SourceTextEntry> list = this.existEntries.get(cursor.getEntrySource());
            if (list == null) continue;
            for (SourceTextEntry ste : list) {
                boolean has100PC;
                TMXEntry existTranslation = this.project.getTranslationInfo(ste.getKey());
                PrepareTMXEntry e = cursor.toPrepareTMXEntry();
                String id = ste.getKey().id;
                boolean hasICE = id != null && e.hasPropValue("x-ice", id);
                boolean bl = has100PC = id != null && e.hasPropValue("x-100pc", id);
                if (e.getPropValue("x-target-lang") != null) {
                    String traLang1 = e.getPropValue("x-target-lang");
                    Matcher matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang1);
                    if (!matcher.find()) continue;
                    traLang1 = matcher.group(1);
                    if (!traLang1.equalsIgnoreCase(this.project.getProjectProperties().getTargetLanguage().getLanguageCode())) {
                        String prefForeign = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");
                        if (!prefForeign.contains(";")) continue;
                        String[] prefForeigns = prefForeign.split(";");
                        for (int i = 0; i < prefForeigns.length - 1; ++i) {
                            String traLang2 = prefForeigns[i].substring(0, prefForeigns[i].indexOf(32));
                            if (traLang1.equalsIgnoreCase(traLang2) && prefForeigns[i].contains("with-insert")) continue block0;
                            matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang2);
                            if (matcher.find()) {
                                traLang2 = matcher.group(1);
                            }
                            if (traLang1.equalsIgnoreCase(traLang2) && prefForeigns[i].contains("with-insert")) continue block0;
                        }
                    }
                }
                if (!hasICE && !has100PC) {
                    boolean isDefaultTranslation;
                    boolean bl2 = isDefaultTranslation = !this.isAltTranslation(e);
                    if (!existTranslation.defaultTranslation && isDefaultTranslation || !isDefaultTranslation && !this.altTranslationMatches(e, ste.getKey())) continue;
                    if (existTranslation.isTranslated()) {
                        if ((existTranslation.linked != TMXEntry.ExternalLinked.xAUTO || StringUtil.equalsWithNulls(existTranslation.translation, e.translation)) && !isEnforcedTMX) continue;
                        this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
                        continue;
                    }
                    this.setTranslation(ste, e, isDefaultTranslation, TMXEntry.ExternalLinked.xAUTO);
                    continue;
                }
                if (!existTranslation.isTranslated() || existTranslation.defaultTranslation) {
                    if (hasICE) {
                        this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                        continue;
                    }
                    if (!has100PC) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
                    continue;
                }
                if (existTranslation.linked == TMXEntry.ExternalLinked.xICE || existTranslation.linked == TMXEntry.ExternalLinked.x100PC) {
                    if (!hasICE || StringUtil.equalsWithNulls(existTranslation.translation, e.translation)) continue;
                    this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.xICE);
                    continue;
                }
                if (existTranslation.linked != TMXEntry.ExternalLinked.x100PC || !has100PC || StringUtil.equalsWithNulls(existTranslation.translation, e.translation)) continue;
                this.setTranslation(ste, e, false, TMXEntry.ExternalLinked.x100PC);
            }
        }
    }

    private boolean isAltTranslation(PrepareTMXEntry entry) {
        if (entry.otherProperties == null) {
            return false;
        }
        boolean hasFileProp = false;
        boolean hasOtherProp = false;
        for (TMXProp p : entry.otherProperties) {
            if (p.getType().equals("file")) {
                hasFileProp = true;
                continue;
            }
            if (!p.getType().equals("id") && !p.getType().equals("next") && !p.getType().equals("path") && !p.getType().equals("prev")) continue;
            hasOtherProp = true;
        }
        return EntryKey.IGNORE_FILE_CONTEXT ? hasFileProp && hasOtherProp : hasFileProp;
    }

    private boolean altTranslationMatches(PrepareTMXEntry entry, EntryKey key) {
        try {
            for (TMXProp p : entry.otherProperties) {
                if (p.getType().equals("file") && EntryKey.IGNORE_FILE_CONTEXT) continue;
                try {
                    Field f = EntryKey.class.getField(p.getType());
                    Object value = f.get(key);
                    if (value.equals(p.getValue())) continue;
                    return false;
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void importTranslationsFromSources(boolean supportDefault) {
        for (Map.Entry<String, List<SourceTextEntry>> me : this.existEntries.entrySet()) {
            if (this.project.projectTMX.getDefaultTranslation(me.getKey()) != null) continue;
            if (supportDefault) {
                if (me.getValue().size() == 1) {
                    SourceTextEntry ste = me.getValue().get(0);
                    if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy()) continue;
                    this.setTranslation(ste, ste.getSourceTranslationInfo().asPrepareEntry(me.getKey()), true, TMXEntry.ExternalLinked.xSRC);
                    continue;
                }
                HashMap<String, Integer> traSet = new HashMap<String, Integer>();
                int max = 0;
                String freq = null;
                for (SourceTextEntry ste : me.getValue()) {
                    if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy()) continue;
                    if (traSet.get(ste.getSourceTranslation()) == null) {
                        traSet.put(ste.getSourceTranslation(), 1);
                        continue;
                    }
                    int count = (Integer)traSet.get(ste.getSourceTranslation()) + 1;
                    traSet.put(ste.getSourceTranslation(), count);
                    if (count <= max) continue;
                    max = count;
                    freq = ste.getSourceTranslation();
                }
                for (SourceTextEntry ste : me.getValue()) {
                    if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy() || this.project.projectTMX.getMultipleTranslation(ste.getKey()) != null) continue;
                    if (max <= 1) {
                        this.setTranslation(ste, ste.getSourceTranslationInfo().asPrepareEntry(me.getKey()), false, TMXEntry.ExternalLinked.xSRC);
                        continue;
                    }
                    if (ste.getSourceTranslation().equals(freq)) {
                        this.setTranslation(ste, ste.getSourceTranslationInfo().asPrepareEntry(me.getKey()), true, TMXEntry.ExternalLinked.xSRC);
                        continue;
                    }
                    this.setTranslation(ste, ste.getSourceTranslationInfo().asPrepareEntry(me.getKey()), false, TMXEntry.ExternalLinked.xSRC);
                }
                continue;
            }
            for (SourceTextEntry ste : me.getValue()) {
                if (ste.getSourceTranslation() == null || ste.isSourceTranslationFuzzy() || this.project.projectTMX.getMultipleTranslation(ste.getKey()) != null) continue;
                this.setTranslation(ste, ste.getSourceTranslationInfo().asPrepareEntry(me.getKey()), false, TMXEntry.ExternalLinked.xSRC);
            }
        }
    }

    private void setTranslation(SourceTextEntry entry, PrepareTMXEntry trans, boolean defaultTranslation, TMXEntry.ExternalLinked externalLinked) {
        if (StringUtil.isEmpty(trans.note)) {
            trans.note = null;
        }
        trans.source = entry.getSrcText();
        if (!this.didAnyChange) {
            TMXEntry oldEntry;
            TMXEntry tMXEntry = oldEntry = defaultTranslation ? this.project.projectTMX.defaults.get(entry.getSrcText()) : this.project.projectTMX.alternatives.get(entry.getKey());
            if (oldEntry == null) {
                if (trans.isTranslated()) {
                    this.didAnyChange = true;
                }
            } else if (oldEntry.isTranslated()) {
                if (!oldEntry.getTranslationText().equals(trans.getTranslationText())) {
                    this.didAnyChange = true;
                }
            } else if (trans.isTranslated()) {
                this.didAnyChange = true;
            }
        }
        TMXEntry newTrEntry = trans.translation == null && trans.note == null ? null : new TMXEntry(trans, defaultTranslation, externalLinked);
        this.project.projectTMX.setTranslation(entry, newTrEntry, defaultTranslation);
    }
}

