/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.segmentation.Rule;
import org.omegat.util.Language;

public class SourceTextEntry {
    private static final ProtectedPart[] EMPTY_PROTECTED_PARTS = new ProtectedPart[0];
    private final EntryKey key;
    private SourceTranslationInfo sourceTranslation;
    List<SourceTextEntry> duplicates;
    SourceTextEntry firstInstance;
    private final int m_entryNum;
    private final ProtectedPart[] protectedParts;
    private boolean isParagraphStart = true;

    public SourceTextEntry(EntryKey key, int entryNum, SourceTranslationInfo traInfo, List<ProtectedPart> protectedParts, boolean isParagraphStart) {
        this.key = key;
        this.m_entryNum = entryNum;
        this.sourceTranslation = traInfo;
        this.isParagraphStart = isParagraphStart;
        if (protectedParts.isEmpty()) {
            this.protectedParts = EMPTY_PROTECTED_PARTS;
        } else {
            for (int i = 0; i < protectedParts.size(); ++i) {
                if (!protectedParts.get(i).getTextInSourceSegment().isEmpty()) continue;
                protectedParts.remove(i);
                --i;
            }
            this.protectedParts = protectedParts.toArray(new ProtectedPart[protectedParts.size()]);
        }
        this.duplicates = null;
        this.firstInstance = null;
    }

    public EntryKey getKey() {
        return this.key;
    }

    public String getSrcText() {
        return this.key.sourceText;
    }

    public String getComment() {
        return this.sourceTranslation == null ? null : this.sourceTranslation.comment;
    }

    public int entryNum() {
        return this.m_entryNum;
    }

    public DUPLICATE getDuplicate() {
        if (this.firstInstance != null) {
            return DUPLICATE.NEXT;
        }
        return this.duplicates == null ? DUPLICATE.NONE : DUPLICATE.FIRST;
    }

    public int getNumberOfDuplicates() {
        if (this.firstInstance != null) {
            return this.firstInstance.getNumberOfDuplicates();
        }
        return this.duplicates == null ? 0 : this.duplicates.size();
    }

    public List<SourceTextEntry> getDuplicates() {
        if (this.firstInstance != null) {
            ArrayList<SourceTextEntry> result = new ArrayList<SourceTextEntry>(this.firstInstance.getDuplicates());
            result.remove(this);
            result.add(0, this.firstInstance);
            return Collections.unmodifiableList(result);
        }
        if (this.duplicates == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.duplicates);
    }

    public String getSourceTranslation() {
        return this.sourceTranslation == null ? null : this.sourceTranslation.sourceTranslation;
    }

    public SourceTranslationInfo getSourceTranslationInfo() {
        return this.sourceTranslation;
    }

    public boolean isSourceTranslationFuzzy() {
        return this.sourceTranslation == null ? false : this.sourceTranslation.sourceTranslationFuzzy;
    }

    public ProtectedPart[] getProtectedParts() {
        return this.protectedParts;
    }

    public boolean isParagraphStart() {
        return this.isParagraphStart;
    }

    public static class SourceTranslationInfo {
        public final String comment;
        private String sourceTranslation;
        public final boolean sourceTranslationFuzzy;

        public SourceTranslationInfo(String tra, String comment, boolean fuzzy) {
            this.sourceTranslation = tra;
            this.comment = comment;
            this.sourceTranslationFuzzy = fuzzy;
        }

        public boolean isTranslated() {
            return this.sourceTranslation != null && this.sourceTranslation.length() > 0;
        }

        void setUntranslated() {
            this.sourceTranslation = null;
        }

        public String getTranslation() {
            return this.sourceTranslation;
        }

        void applyToTranslation(Function<String, String> fun) {
            this.sourceTranslation = fun.apply(this.sourceTranslation);
        }

        public PrepareTMXEntry asPrepareEntry(String source) {
            PrepareTMXEntry entry = new PrepareTMXEntry();
            entry.source = source;
            entry.translation = this.sourceTranslation;
            entry.note = this.comment;
            return entry;
        }

        public List<SourceTranslationInfo> cut(Language traLang) {
            List<String> traCut = Core.getSegmenter().segment(traLang, this.sourceTranslation, new ArrayList<StringBuilder>(), new ArrayList<Rule>());
            if (traCut == null || traCut.size() == 1) {
                return Collections.singletonList(this);
            }
            ArrayList<SourceTranslationInfo> res = new ArrayList<SourceTranslationInfo>(traCut.size());
            for (int i = 0; i < res.size(); ++i) {
                res.add(new SourceTranslationInfo(traCut.get(i), this.comment, this.sourceTranslationFuzzy));
            }
            return res;
        }
    }

    public static enum DUPLICATE {
        NONE,
        FIRST,
        NEXT;

    }

    public static class SourceTranslationEntry
    extends SourceTranslationInfo {
        public final String creator;
        public final long creationDate;
        public final String changer;
        public final long changeDate;

        public SourceTranslationEntry(String tra, String comment, boolean fuzzy, String creator, long creationDate) {
            super(tra, comment, fuzzy);
            this.creator = creator;
            this.creationDate = creationDate;
            this.changer = null;
            this.changeDate = 0L;
        }

        public SourceTranslationEntry(String tra, String comment, boolean fuzzy, String creator, long creationDate, String changer, long changeDate) {
            super(tra, comment, fuzzy);
            this.creator = creator;
            this.creationDate = creationDate;
            this.changer = changer;
            this.changeDate = changeDate;
        }

        @Override
        public PrepareTMXEntry asPrepareEntry(String source) {
            PrepareTMXEntry entry = super.asPrepareEntry(source);
            entry.changer = this.changer;
            entry.changeDate = this.changeDate;
            entry.creator = this.creator;
            entry.creationDate = this.creationDate;
            return entry;
        }

        @Override
        public List<SourceTranslationInfo> cut(Language traLang) {
            List<String> traCut = Core.getSegmenter().segment(traLang, this.getTranslation(), new ArrayList<StringBuilder>(), new ArrayList<Rule>());
            if (traCut == null || traCut.size() == 1) {
                return Collections.singletonList(this);
            }
            ArrayList<SourceTranslationInfo> res = new ArrayList<SourceTranslationInfo>(traCut.size());
            for (int i = 0; i < res.size(); ++i) {
                res.add(new SourceTranslationEntry(traCut.get(i), this.comment, this.sourceTranslationFuzzy, this.creator, this.creationDate, this.changer, this.changeDate));
            }
            return res;
        }
    }
}

