/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.dictionaries;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.dict.zip.DictZipHeader;
import org.dict.zip.DictZipInputStream;
import org.dict.zip.RandomAccessInputStream;
import org.omegat.core.dictionaries.DictionaryEntry;
import org.omegat.core.dictionaries.IDictionary;
import org.omegat.core.dictionaries.IDictionaryFactory;
import org.omegat.util.Log;

public class StarDict
implements IDictionaryFactory {
    protected static final int BUFFER_SIZE = 65536;

    @Override
    public boolean isSupportedFile(File file) {
        return file.getPath().endsWith(".ifo");
    }

    @Override
    public IDictionary loadDict(File file) throws Exception {
        return new StarDictDict(file);
    }

    static class StarDictDict
    implements IDictionary {
        private int idxoffsetbits = 32;
        private DictZipHeader fHeader;
        private DictType dictType;
        private String dictName;
        private String dataFile;
        protected final Map<String, Object> data;

        public StarDictDict(File ifoFile) throws Exception {
            String bitsString;
            Map<String, String> header = this.readIFO(ifoFile);
            String version = header.get("version");
            if (!"2.4.2".equals(version) && !"3.0.0".equals(version)) {
                throw new Exception("Invalid version of dictionary: " + version);
            }
            String sametypesequence = header.get("sametypesequence");
            if (!("g".equals(sametypesequence) || "m".equals(sametypesequence) || "x".equals(sametypesequence) || "h".equals(sametypesequence))) {
                throw new Exception("Invalid type of dictionary: " + sametypesequence);
            }
            if ("3.0.0".equals(version) && (bitsString = header.get("idxoffsetbits")) != null) {
                this.idxoffsetbits = Integer.parseInt(bitsString);
            }
            if (this.idxoffsetbits != 32) {
                throw new Exception("StarDict dictionaries with idxoffsetbits=64 are not supported.");
            }
            String f = ifoFile.getPath();
            if (f.endsWith(".ifo")) {
                f = f.substring(0, f.length() - ".ifo".length());
            }
            this.dictName = f;
            String dzFile = f + ".dict.dz";
            if (new File(dzFile).isFile()) {
                this.dictType = DictType.DICTZIP;
                this.dataFile = dzFile;
            } else {
                String dictFile = f + ".dict";
                if (!new File(dictFile).isFile()) {
                    throw new FileNotFoundException("No .dict.dz or .dict files were found for " + this.dictName);
                }
                this.dictType = DictType.DICTFILE;
                this.dataFile = dictFile;
            }
            this.data = this.readHeader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, Object> readHeader() throws IOException {
            HashMap<String, Object> hashMap;
            byte[] idxBytes;
            File file = new File(this.dictName + ".idx");
            if (file.exists()) {
                idxBytes = this.readIDX(file);
            } else {
                file = new File(this.dictName + ".idx.gz");
                if (file.exists()) {
                    idxBytes = this.readIDXGZ(file);
                } else {
                    throw new FileNotFoundException("No .idx file could be found");
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            ByteArrayInputStream bais = null;
            DataInputStream idx = null;
            ByteArrayOutputStream mem = null;
            try {
                int b;
                bais = new ByteArrayInputStream(idxBytes);
                idx = new DataInputStream(bais);
                mem = new ByteArrayOutputStream();
                while ((b = idx.read()) != -1) {
                    if (b == 0) {
                        String key = new String(mem.toByteArray(), 0, mem.size(), "UTF-8");
                        mem.reset();
                        int bodyOffset = idx.readInt();
                        int bodyLength = idx.readInt();
                        this.addIndex(key, bodyOffset, bodyLength, result);
                        continue;
                    }
                    mem.write(b);
                }
                mem.close();
                idx.close();
                bais.close();
                hashMap = result;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(mem);
                IOUtils.closeQuietly(idx);
                IOUtils.closeQuietly((InputStream)bais);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)mem);
            IOUtils.closeQuietly((InputStream)idx);
            IOUtils.closeQuietly((InputStream)bais);
            return hashMap;
        }

        private void addIndex(String key, int start, int len, Map<String, Object> result) {
            Entry[] data = result.get(key);
            if (data == null) {
                Entry d = new Entry(start, len);
                data = d;
            } else if (data instanceof Entry[]) {
                Entry[] dobj = data;
                Entry[] d = new Entry[dobj.length + 1];
                System.arraycopy(dobj, 0, d, 0, dobj.length);
                d[d.length - 1] = new Entry(start, len);
                data = d;
            } else {
                Entry[] d = new Entry[]{(Entry)data, new Entry(start, len)};
                data = d;
            }
            result.put(key, data);
        }

        @Override
        public List<DictionaryEntry> readArticles(String word) {
            Object dictData = this.data.get(word);
            if (dictData == null) {
                return Collections.emptyList();
            }
            ArrayList<DictionaryEntry> result = new ArrayList<DictionaryEntry>();
            if (dictData instanceof Entry) {
                result.add(new DictionaryEntry(word, ((Entry)dictData).getArticle()));
            } else if (dictData instanceof Entry[]) {
                for (Entry entry : (Entry[])dictData) {
                    result.add(new DictionaryEntry(word, entry.getArticle()));
                }
            }
            return result;
        }

        private synchronized String readArticle(int start, int len) {
            switch (this.dictType) {
                case DICTFILE: {
                    return this.readDictArticleText(start, len);
                }
                case DICTZIP: {
                    return this.readDictZipArticleText(start, len);
                }
            }
            throw new RuntimeException("Unknown StarDict dictionary type: " + this.dictType);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readDictArticleText(int start, int len) {
            String result = null;
            FileInputStream in = null;
            try {
                in = new FileInputStream(this.dataFile);
                byte[] data = new byte[len];
                in.skip(start);
                in.read(data);
                result = new String(data, "UTF-8");
                in.close();
            }
            catch (IOException e) {
                try {
                    System.err.println(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            IOUtils.closeQuietly((InputStream)in);
            return result;
        }

        private DictZipHeader getDZHeader(DictZipInputStream din) throws IOException {
            if (this.fHeader == null) {
                this.fHeader = din.readHeader();
            }
            return this.fHeader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String readDictZipArticleText(int start, int len) {
            RandomAccessInputStream in = null;
            DictZipInputStream din = null;
            String result = null;
            try {
                in = new RandomAccessInputStream(this.dataFile, "r");
                din = new DictZipInputStream((InputStream)in);
                DictZipHeader h = this.getDZHeader(din);
                int off = h.getOffset(start);
                int pos = h.getPosition(start);
                in.seek((long)pos);
                byte[] b = new byte[off + len];
                din.readFully(b);
                byte[] data = new byte[len];
                System.arraycopy(b, off, data, 0, len);
                result = new String(data, "UTF-8");
                din.close();
                in.close();
            }
            catch (IOException e) {
                try {
                    Log.log(e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(din);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(din);
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((InputStream)din);
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readIDX(File file) throws IOException {
            byte[] byArray;
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis, 65536);
                byte[] result = IOUtils.toByteArray((InputStream)bis);
                bis.close();
                fis.close();
                byArray = result;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((InputStream)bis);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] readIDXGZ(File file) throws IOException {
            byte[] byArray;
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            GZIPInputStream is = null;
            try {
                fis = new FileInputStream(file);
                bis = new BufferedInputStream(fis, 65536);
                is = new GZIPInputStream(bis);
                byte[] result = IOUtils.toByteArray((InputStream)is);
                ((InputStream)is).close();
                bis.close();
                fis.close();
                byArray = result;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly(bis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)is);
            IOUtils.closeQuietly((InputStream)fis);
            IOUtils.closeQuietly((InputStream)bis);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> readIFO(File ifoFile) throws Exception {
            TreeMap<String, String> treeMap;
            FileInputStream fis = null;
            InputStreamReader isr = null;
            BufferedReader rd = null;
            try {
                fis = new FileInputStream(ifoFile);
                isr = new InputStreamReader((InputStream)fis, "UTF-8");
                rd = new BufferedReader(isr);
                String line = null;
                String first = rd.readLine();
                if (!"StarDict's dict ifo file".equals(first)) {
                    throw new Exception("Invalid header of .ifo file: " + first);
                }
                TreeMap<String, String> result = new TreeMap<String, String>();
                while ((line = rd.readLine()) != null) {
                    if (line.trim().isEmpty()) continue;
                    int pos = line.indexOf(61);
                    if (pos < 0) {
                        throw new Exception("Invalid format of .ifo file: " + line);
                    }
                    result.put(line.substring(0, pos), line.substring(pos + 1));
                }
                rd.close();
                isr.close();
                fis.close();
                treeMap = result;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(rd);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)rd);
            IOUtils.closeQuietly((Reader)isr);
            IOUtils.closeQuietly((InputStream)fis);
            return treeMap;
        }

        private class Entry {
            private volatile String cache;
            private final int start;
            private final int len;

            public Entry(int start, int len) {
                this.start = start;
                this.len = len;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String getArticle() {
                String article = this.cache;
                if (article == null) {
                    Entry entry = this;
                    synchronized (entry) {
                        article = this.cache;
                        if (article == null) {
                            article = this.cache = this.loadArticle();
                        }
                    }
                }
                return article;
            }

            private String loadArticle() {
                return StarDictDict.this.readArticle(this.start, this.len).replace("\n", "<br>");
            }
        }
    }

    public static enum DictType {
        DICTZIP,
        DICTFILE;

    }
}

