/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ITMXEntry;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.events.IStopped;
import org.omegat.core.matching.FindMatchesSingleton;
import org.omegat.core.matching.ISimilarityCalculator;
import org.omegat.core.matching.ImprovedLevenshteinDistance;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.core.matching.NearString;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.segmentation.Rule;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.PatternConsts;
import org.omegat.util.Preferences;
import org.omegat.util.TMXProp;
import org.omegat.util.Token;

public abstract class FindMatches {
    protected NearString.SORT_KEY sortKey = Preferences.getPreferenceEnumDefault("ext_tmx_sort_key", NearString.SORT_KEY.SCORE_STEM);
    private static final int PENALTY_FOR_FUZZY = 20;
    private static final int PENALTY_FOR_REMOVED = 5;
    private static final int SUBSEGMENT_MATCH_THRESHOLD = 85;
    private static final boolean ALLOW_PARTIALY_MATCH = true;
    private final ISimilarityCalculator distance = new LevenshteinDistance();
    private ImprovedLevenshteinDistance iDistance;
    private final Pattern removePattern = PatternConsts.getRemovePattern();
    private static final ITokenizer ALT_TOKENIZER = new DefaultTokenizer();
    private ITokenizer tok;
    private final Locale srcLocale;
    private final boolean searchExactlyTheSame;
    private String originalText;
    private String srcText;
    private String removedText;
    private Token[] strTokensStem;
    private Token[] strTokensNoStem;
    private Token[] strTokensAll;
    private String[] strStringsNoSpaces;
    FindMatchesSingleton separateSegmentMatcher;
    private final IExternalMemory[] externalMemories;
    private String memoryPath = null;
    protected int FUZZY_MATCH_THRESHOLD = Preferences.getPreferenceDefault("ext_tmx_match_threshold", 30);
    Map<String, Token[]> tokenizeStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeNoStemCache = new HashMap<String, Token[]>();
    Map<String, Token[]> tokenizeAllCache = new HashMap<String, Token[]>();

    public FindMatches(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, String memoryPath, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this(sourceTokenizer, externalMemories, allowSeparateSegmentMatch, searchExactlyTheSame);
        this.memoryPath = memoryPath;
    }

    public FindMatches(ITokenizer sourceTokenizer, IExternalMemory[] externalMemories, boolean allowSeparateSegmentMatch, boolean searchExactlyTheSame) {
        this.tok = sourceTokenizer;
        this.iDistance = new ImprovedLevenshteinDistance(this.tok);
        this.srcLocale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        this.searchExactlyTheSame = searchExactlyTheSame;
        this.externalMemories = externalMemories;
        if (allowSeparateSegmentMatch) {
            this.separateSegmentMatcher = new FindMatchesSingleton(sourceTokenizer, externalMemories, false, true);
        }
    }

    protected void buildSimilarityData(NearString near) {
        Token[] matchTokens = this.tokenizeAll(near.source);
        int len = matchTokens.length;
        byte[] result = new byte[len];
        boolean leftfound = true;
        for (int i = 0; i < len; ++i) {
            result[i] = 0;
            Token righttoken = null;
            if (i + 1 < len) {
                righttoken = matchTokens[i + 1];
            }
            boolean rightfound = i + 1 == len || DefaultTokenizer.isContains(this.strTokensAll, righttoken);
            Token token = matchTokens[i];
            boolean found = DefaultTokenizer.isContains(this.strTokensAll, token);
            if (!(!found || leftfound && rightfound)) {
                result[i] = 2;
            } else if (!found) {
                result[i] = 1;
            }
            leftfound = found;
        }
        near.attr = result;
    }

    protected void doSearch(IProject project, String searchText, boolean requiresTranslation, boolean fillSimilarityData, IStopped stop) throws StoppedException {
        this.originalText = searchText;
        this.srcText = searchText;
        this.removedText = "";
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(this.srcText);
            while (removeMatcher.find()) {
                this.removedText = this.removedText + this.srcText.substring(removeMatcher.start(), removeMatcher.end());
            }
            this.srcText = removeMatcher.replaceAll("");
        }
        this.strTokensStem = this.tokenizeStem(this.srcText);
        this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
        this.strTokensAll = this.tokenizeAll(this.srcText);
        this.strStringsNoSpaces = this.iDistance.noSpace(Token.getTextsFromString(this.strTokensAll, this.srcText));
        ITokenizer tempTokenizer = this.tok;
        if (this.strTokensStem.length == 0 || this.strTokensNoStem.length == 0) {
            this.tok = ALT_TOKENIZER;
            this.tokenizeStemCache.clear();
            this.tokenizeNoStemCache.clear();
            this.tokenizeAllCache.clear();
            this.strTokensStem = this.tokenizeStem(this.srcText);
            this.strTokensNoStem = this.tokenizeNoStem(this.srcText);
            this.strTokensAll = this.tokenizeAll(this.srcText);
        }
        if (this.memoryPath == null) {
            this.searchInProject(project, this.srcText, requiresTranslation, stop);
        }
        Language sourceLang = project.getProjectProperties().getSourceLanguage();
        Language targetLang = project.getProjectProperties().getTargetLanguage();
        String prefForeign = Preferences.getPreferenceDefault("keep_foreign_matches", "30 false");
        Pattern SEARCH_FOR_PENALTY = Pattern.compile("penalty-(\\d+)");
        for (Map.Entry<String, IExternalMemory> en : project.getTransMemories().entrySet()) {
            if (this.memoryPath != null && !en.getKey().contains(this.memoryPath)) continue;
            int penalty = 0;
            Matcher matcher = SEARCH_FOR_PENALTY.matcher(en.getKey());
            if (matcher.find()) {
                penalty = Integer.parseInt(matcher.group(1));
            }
            try {
                for (ITMXEntry iTMXEntry : en.getValue().findMatchingTranslations(sourceLang, targetLang, this.originalText, this.FUZZY_MATCH_THRESHOLD, this.maxCount())) {
                    this.checkStopped(stop);
                    if (iTMXEntry.getSourceText() == null || requiresTranslation && iTMXEntry.getTranslationText() == null) continue;
                    int penalty1 = 0;
                    try {
                        penalty1 = Integer.parseInt(iTMXEntry.getPropValue("omegat.penalty"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    int penalty2 = 0;
                    String traLang2 = iTMXEntry.getPropValue("x-target-lang");
                    if (traLang2 != null) {
                        matcher = PatternConsts.LANG_AND_COUNTRY.matcher(traLang2);
                        if (matcher.find()) {
                            traLang2 = matcher.group(1);
                        }
                        if (!traLang2.equalsIgnoreCase(targetLang.getLanguageCode())) {
                            if (prefForeign.endsWith("false")) continue;
                            if (prefForeign.contains(";")) {
                                String[] prefs = prefForeign.split(";");
                                for (int i = 0; i < prefs.length - 1; ++i) {
                                    String[] parts = prefs[i].split(" ");
                                    matcher = PatternConsts.LANG_AND_COUNTRY.matcher(parts[0]);
                                    if (matcher.find()) {
                                        parts[0] = matcher.group(1);
                                    }
                                    if (!parts[0].equalsIgnoreCase(traLang2)) continue;
                                    try {
                                        penalty2 = Integer.parseInt(parts[1]);
                                        break;
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (penalty2 == 0) {
                                try {
                                    String pref = prefForeign;
                                    if (pref.contains(";")) {
                                        pref = pref.substring(pref.lastIndexOf(59) + 1);
                                    }
                                    penalty2 = Integer.parseInt(pref.substring(0, pref.indexOf(32)));
                                }
                                catch (Exception pref) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    this.processEntry(null, searchText, iTMXEntry.getSourceText(), iTMXEntry.getTranslationText(), NearString.MATCH_SOURCE.TM, false, penalty + penalty1 + penalty2, en.getValue().getMemoryName(), iTMXEntry.getCreator(), iTMXEntry.getCreationDate(), iTMXEntry.getChanger(), iTMXEntry.getChangeDate(), iTMXEntry.getPropValue("revisor"), iTMXEntry.getNote(), iTMXEntry.getProperties());
                }
            }
            catch (StoppedException stopex) {
                throw stopex;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        for (IExternalMemory provider : this.externalMemories) {
            try {
                if (this.memoryPath != null && !provider.getMemoryName().contains(this.memoryPath)) continue;
                for (ITMXEntry iTMXEntry : provider.findMatchingTranslations(sourceLang, targetLang, this.originalText, 30, this.maxCount())) {
                    this.checkStopped(stop);
                    this.processEntry(null, searchText, iTMXEntry.getSourceText(), iTMXEntry.getTranslationText(), NearString.MATCH_SOURCE.TM, false, 0, provider.getMemoryName(), iTMXEntry.getCreator(), iTMXEntry.getCreationDate(), iTMXEntry.getChanger(), iTMXEntry.getChangeDate(), iTMXEntry.getPropValue("revisor"), iTMXEntry.getNote(), iTMXEntry.getProperties());
                }
            }
            catch (StoppedException stopex) {
                throw stopex;
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        for (SourceTextEntry ste : project.getAllEntries()) {
            this.checkStopped(stop);
            if (this.memoryPath != null && ste.getKey() != null && ste.getKey().file != null && ste.getKey().file.contains(this.memoryPath) || ste.getSourceTranslation() == null) continue;
            this.processEntry(ste.getKey(), this.srcText, ste.getSrcText(), ste.getSourceTranslation(), NearString.MATCH_SOURCE.MEMORY, ste.isSourceTranslationFuzzy(), 0, ste.getKey().file, "", 0L, "", 0L, "", ste.getComment(), null);
        }
        if (this.separateSegmentMatcher != null && this.memoryPath == null && !project.getProjectProperties().isSentenceSegmentingEnabled()) {
            ArrayList<StringBuilder> spaces = new ArrayList<StringBuilder>();
            ArrayList<Rule> brules = new ArrayList<Rule>();
            List<String> segments = Core.getSegmenter().segment(sourceLang, this.srcText, spaces, brules);
            if (segments.size() > 1) {
                int n;
                ArrayList<String> fsrc = new ArrayList<String>(segments.size());
                ArrayList<String> ftrans = new ArrayList<String>(segments.size());
                boolean bl = false;
                for (int i = 0; i < segments.size(); i = (int)((short)(i + 1))) {
                    String onesrc = segments.get(i);
                    NearString segmentMatch = this.separateSegmentMatcher.search(project, onesrc, requiresTranslation, false, stop);
                    if (segmentMatch != null && segmentMatch.scoreStem >= 85) {
                        Matcher matcher;
                        fsrc.add(segmentMatch.source);
                        ftrans.add(segmentMatch.translation);
                        if (segmentMatch.fuzzyMark && n < 20) {
                            n = 20;
                        }
                        if (!(matcher = SEARCH_FOR_PENALTY.matcher(segmentMatch.proj)).find()) continue;
                        try {
                            int penalty = Integer.parseInt(matcher.group(1));
                            if (penalty <= n) continue;
                            n = penalty;
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    fsrc.add("");
                    ftrans.add("");
                }
                String foundSrc = Core.getSegmenter().glue(sourceLang, sourceLang, fsrc, spaces, brules);
                String foundTrans = Core.getSegmenter().glue(sourceLang, targetLang, ftrans, spaces, brules);
                this.processEntry(null, this.srcText, foundSrc, foundTrans, NearString.MATCH_SOURCE.TM, false, n, "Sub-segment match", "", 0L, "", 0L, "", "", null);
            }
        }
        this.tok = tempTokenizer;
    }

    private void searchInProject(IProject project, String searchText, boolean requiresTranslation, IStopped stop) {
        String localOrphans = OStrings.getString("CT_ORPHAN_STRINGS");
        String distantOrphans = OStrings.getString("CT_DISTANT_ORPHAN_STRINGS");
        if (project.getProjectProperties().isSupportDefaultTranslations()) {
            project.iterateByDefaultTranslations((source, trans) -> {
                this.checkStopped(stop);
                if (!this.searchExactlyTheSame && source.equals(this.originalText)) {
                    return;
                }
                if (requiresTranslation && trans.translation == null) {
                    return;
                }
                String fileName = !project.isLocallyTranslated(source) ? distantOrphans : (project.isOrphaned(source) ? localOrphans : null);
                this.processEntry(null, searchText, source, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, trans.revisor, trans.note, null);
            });
        }
        project.iterateByMultipleTranslations((source, trans) -> {
            this.checkStopped(stop);
            if (!this.searchExactlyTheSame && source.sourceText.equals(this.originalText)) {
                return;
            }
            if (requiresTranslation && trans.translation == null) {
                return;
            }
            String fileName = !project.isLocallyTranslated(source) ? distantOrphans : (project.isOrphaned(source) ? localOrphans : null);
            this.processEntry(source, searchText, source.sourceText, trans.translation, NearString.MATCH_SOURCE.MEMORY, false, 0, fileName, trans.creator, trans.creationDate, trans.changer, trans.changeDate, trans.revisor, trans.note, null);
        });
    }

    protected void processEntry(EntryKey key, String searchText, String source, String translation, NearString.MATCH_SOURCE comesFrom, boolean fuzzy, int penalty, String tmxName, String creator, long creationDate, String changer, long changedDate, String revisor, String note, List<TMXProp> props) {
        String realSource = source;
        Object entryRemovedText = "";
        int totalPenalty = penalty;
        if (fuzzy) {
            totalPenalty += 20;
        }
        if (this.removePattern != null) {
            Matcher removeMatcher = this.removePattern.matcher(realSource);
            while (removeMatcher.find()) {
                entryRemovedText = (String)entryRemovedText + source.substring(removeMatcher.start(), removeMatcher.end());
            }
            realSource = removeMatcher.replaceAll("");
            if (!((String)entryRemovedText).equals(this.removedText)) {
                totalPenalty += 5;
            }
        }
        this.evalEntry(key, source, translation, realSource, totalPenalty, fuzzy, comesFrom, tmxName, creator, creationDate, changer, changedDate, revisor, note, props);
    }

    protected abstract void evalEntry(EntryKey var1, String var2, String var3, String var4, int var5, boolean var6, NearString.MATCH_SOURCE var7, String var8, String var9, long var10, String var12, long var13, String var15, String var16, List<TMXProp> var17);

    public abstract int maxCount();

    protected final int calcSimilarityStem(String realSource) {
        return this.distance.calcSimilarity(this.strTokensStem, this.tokenizeStem(realSource));
    }

    protected final int calcSimilarityNoStem(String realSource) {
        return this.distance.calcSimilarity(this.strTokensNoStem, this.tokenizeNoStem(realSource));
    }

    protected final int calcSimilarityAdjusted(String realSource) {
        return this.distance.calcSimilarity(this.strTokensAll, this.tokenizeAll(realSource));
    }

    protected final int calcSimilarityImproved(String realSource) {
        return this.iDistance.score(this.strStringsNoSpaces, this.iDistance.noSpace(Token.getTextsFromString(this.tokenizeAll(realSource), realSource)));
    }

    public Token[] tokenizeStem(String str) {
        Token[] result = this.tokenizeStemCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.MATCHING);
            this.tokenizeStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeNoStem(String str) {
        Token[] result = this.tokenizeNoStemCache.get(str = str.toLowerCase(this.srcLocale));
        if (result == null) {
            result = this.tok.tokenizeWords(str, ITokenizer.StemmingMode.NONE);
            this.tokenizeNoStemCache.put(str, result);
        }
        return result;
    }

    public Token[] tokenizeAll(String str) {
        Token[] result = this.tokenizeAllCache.get(str);
        if (result == null) {
            result = this.tok.tokenizeVerbatim(str);
            this.tokenizeAllCache.put(str, result);
        }
        return result;
    }

    protected void checkStopped(IStopped stop) throws StoppedException {
        if (stop.isStopped()) {
            throw new StoppedException();
        }
    }

    public static class StoppedException
    extends RuntimeException {
    }
}

