/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching;

import java.util.Arrays;
import org.omegat.core.matching.LevenshteinDistance;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.LuceneFrenchTokenizer;
import org.omegat.util.Token;

public class ImprovedLevenshteinDistance {
    private static final int MAX_N = 327;
    private short[] d = new short[328];
    private short[] p = new short[328];
    private ITokenizer tokenizer;

    private static short minimum(int a, int b, int c) {
        return (short)Math.min(a, Math.min(b, c));
    }

    public ImprovedLevenshteinDistance(ITokenizer tool) {
        this.tokenizer = tool;
    }

    public short distance(String left, String right) {
        String[] tright;
        String[] tleft = this.tokenizer.tokenizeVerbatimToStrings(left);
        if (tleft.length > (tright = this.tokenizer.tokenizeVerbatimToStrings(right)).length) {
            String[] swap = tright;
            tright = tleft;
            tleft = swap;
        }
        int start = 0;
        while (tleft[start].equals(tright[start])) {
            if (start + 1 >= tleft.length) {
                return (short)(100 * Math.max(327, tright.length - tleft.length - start));
            }
            if (start + 1 >= tright.length) {
                return (short)(100 * Math.max(327, tleft.length - tright.length - start));
            }
            ++start;
        }
        return this.distance(tleft, tright, start);
    }

    public short score(String left, String right) {
        String[] tleft = this.noSpace(this.tokenizer.tokenizeVerbatimToStrings(left));
        String[] tright = this.noSpace(this.tokenizer.tokenizeVerbatimToStrings(right));
        return this.score(tleft, tright);
    }

    public short score(String[] tleft, String[] tright) {
        if (tleft.length > tright.length) {
            String[] swap = tright;
            tright = tleft;
            tleft = swap;
        }
        int start = 0;
        while (tleft[start].equals(tright[start])) {
            if (start + 1 >= tleft.length) {
                return (short)(100.0 - Math.floor(100.0 * (double)(tright.length - tleft.length) / (double)tright.length));
            }
            if (start + 1 >= tright.length) {
                return (short)(100.0 - Math.floor(100.0 * (double)(tleft.length - tright.length) / (double)tleft.length));
            }
            ++start;
        }
        return (short)(100.0 - Math.ceil(1.0 * (double)this.distance(tleft, tright, start) / (double)Math.max(tleft.length, tright.length)));
    }

    public String[] noSpace(String[] tab) {
        return (String[])Arrays.stream(tab).filter(item -> !item.trim().isEmpty()).toArray(String[]::new);
    }

    private short distance(String[] tleft, String[] tright, int start) {
        int i;
        if (tleft.length == 0) {
            return (short)(tright.length * 100);
        }
        if (tright.length == 0) {
            return (short)(tleft.length * 100);
        }
        int n = tleft.length - start;
        int m = tright.length - start;
        if (n > 327) {
            n = 327;
        }
        if (m > 327) {
            m = 327;
        }
        String t_j = null;
        for (i = 0; i <= n; i = (int)((short)(i + 1))) {
            this.p[i] = (short)(i * 100);
        }
        ImprovedLevenshteinDistance wordDistance = new ImprovedLevenshteinDistance(this.tokenizer);
        for (int j = 1; j <= m; j = (int)((short)(j + 1))) {
            t_j = tright[start + j - 1];
            this.d[0] = (short)(j * 100);
            for (i = 1; i <= n; i = (int)((short)(i + 1))) {
                this.d[i] = ImprovedLevenshteinDistance.minimum(this.d[i - 1] + 100, this.p[i] + 100, this.p[i - 1] + wordDistance.wordCost(tleft[start + i - 1], t_j, n));
            }
            short[] swap = this.p;
            this.p = this.d;
            this.d = swap;
        }
        return this.p[n];
    }

    private short wordCost(String word1, String word2, int tokensCount) {
        Token[] tok2;
        Token[] tok1;
        if (tokensCount > 40) {
            if (word1.equals(word2)) {
                return 0;
            }
            return 100;
        }
        if (word1.length() > word2.length()) {
            String tmp = word1;
            word1 = word2;
            word2 = tmp;
        }
        int i1 = 0;
        int i2 = 0;
        int idx = 0;
        boolean hasDiff = false;
        boolean hasCase = false;
        boolean hasAmp = false;
        while (i1 < word1.length()) {
            char c1 = word1.charAt(i1);
            if (c1 == '&') {
                ++i1;
                hasAmp = true;
                continue;
            }
            char c2 = word2.charAt(i2);
            if (c2 == '&') {
                hasAmp = true;
                if (++i2 < word2.length()) break;
                hasDiff = true;
                break;
            }
            if (c1 == c2) {
                if (++i1 != ++i2) continue;
                idx = i1;
                continue;
            }
            if (Character.toUpperCase(c1) == Character.toUpperCase(c2)) {
                ++i1;
                ++i2;
                hasCase = true;
                continue;
            }
            hasDiff = true;
            break;
        }
        if (!hasDiff) {
            if (hasCase) {
                return 10;
            }
            if (hasAmp) {
                return 20;
            }
            return 0;
        }
        if (tokensCount > 10) {
            return 100;
        }
        double cost = 30.0 * (double)this.wordDistance(word1, word2, idx) / (double)Math.max(word1.length(), word2.length());
        if (cost < 10.0 && (tok1 = this.tokenizer.tokenizeWords(word1, ITokenizer.StemmingMode.GLOSSARY)).length == (tok2 = this.tokenizer.tokenizeWords(word2, ITokenizer.StemmingMode.GLOSSARY)).length) {
            boolean found = false;
            for (int i = 0; i < tok1.length; ++i) {
                if (tok1[i].equals(tok2[i])) continue;
                found = true;
                break;
            }
            if (!found) {
                return 40;
            }
        }
        return (short)Math.floor(cost + 70.0);
    }

    private short wordDistance(String tleft, String tright, int start) {
        int i;
        if (tleft.length() == 0) {
            return (short)tright.length();
        }
        if (tright.length() == 0) {
            return (short)tleft.length();
        }
        int n = tleft.length() - start;
        int m = tright.length() - start;
        if (n > 100) {
            n = 100;
        }
        if (m > 100) {
            m = 100;
        }
        char t_j = ' ';
        for (i = 0; i <= n; i = (int)((short)(i + 1))) {
            this.p[i] = i;
        }
        for (int j = 1; j <= m; j = (int)((short)(j + 1))) {
            t_j = tright.charAt(start + j - 1);
            this.d[0] = j;
            for (i = 1; i <= n; i = (int)((short)(i + 1))) {
                this.d[i] = ImprovedLevenshteinDistance.minimum(this.d[i - 1] + 1, this.p[i] + 1, this.p[i - 1] + (tleft.charAt(start + i - 1) == t_j ? (short)0 : 1));
            }
            short[] swap = this.p;
            this.p = this.d;
            this.d = swap;
        }
        return this.p[n];
    }

    public static void main(String[] args) {
        String left = args[0];
        String right = args[1];
        LuceneFrenchTokenizer tok = new LuceneFrenchTokenizer();
        ImprovedLevenshteinDistance testSelf = new ImprovedLevenshteinDistance(tok);
        long now = System.currentTimeMillis();
        System.err.println("Left tokens: " + String.join((CharSequence)",", tok.tokenizeVerbatimToStrings(left)));
        System.err.println("Right tokens: " + String.join((CharSequence)",", tok.tokenizeVerbatimToStrings(right)));
        LevenshteinDistance testOther = new LevenshteinDistance();
        Token[] tokLeft = tok.tokenizeVerbatim(left);
        Token[] tokRight = tok.tokenizeVerbatim(right);
        now = System.currentTimeMillis();
        System.err.println("Adjusted distance = " + testOther.compute(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        now = System.currentTimeMillis();
        System.err.println("Adjusted score = " + testOther.calcSimilarity(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        tokLeft = tok.tokenizeWords(left, ITokenizer.StemmingMode.MATCHING);
        tokRight = tok.tokenizeWords(right, ITokenizer.StemmingMode.MATCHING);
        now = System.currentTimeMillis();
        System.err.println("Stemmed distance = " + testOther.compute(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        now = System.currentTimeMillis();
        System.err.println("Stemmed score = " + testOther.calcSimilarity(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        tokLeft = tok.tokenizeWords(left, ITokenizer.StemmingMode.NONE);
        tokRight = tok.tokenizeWords(right, ITokenizer.StemmingMode.NONE);
        now = System.currentTimeMillis();
        System.err.println("Unstemmed distance = " + testOther.compute(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        now = System.currentTimeMillis();
        System.err.println("Unstemmed score = " + testOther.calcSimilarity(tokLeft, tokRight));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        System.err.println(" *** ");
        now = System.currentTimeMillis();
        System.err.println("Improved distance = " + testSelf.distance(left, right));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        now = System.currentTimeMillis();
        System.err.println("Improved score = " + testSelf.score(left, right));
        System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        if (tokLeft.length == 1 && tokRight.length == 1) {
            now = System.currentTimeMillis();
            System.err.println("wordDistance = " + testSelf.wordDistance(left, right, 0));
            System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
            now = System.currentTimeMillis();
            System.err.println("wordCost = " + testSelf.wordCost(left, right, 0));
            System.err.println("Took " + (System.currentTimeMillis() - now) + " ms");
        }
    }
}

