/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.matching.external.rmi;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.IProject;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.core.matching.external.ProjectMemory;
import org.omegat.core.matching.external.rmi.IDistantExternalMemory;
import org.omegat.util.Log;

public class ProjectServer
extends UnicastRemoteObject
implements IDistantExternalMemory,
IProjectEventListener {
    public static ProjectServer INSTANCE = null;
    protected Deque<SourceTextEntry> changesByDate = new ConcurrentLinkedDeque<SourceTextEntry>();
    private Map<String, Iterator<SourceTextEntry>> openedCursors = new HashMap<String, Iterator<SourceTextEntry>>();
    private Map<String, SourceTextEntry> openedEntries = new HashMap<String, SourceTextEntry>();
    protected ProjectMemory.ExtendedCheckOrphanedCallback entries;

    protected ProjectServer() throws RemoteException {
        CoreEvents.registerProjectChangeListener(this);
        INSTANCE = this;
    }

    public static ProjectServer open(String portStr, String object) throws Exception {
        int port = 1099;
        if (portStr != null) {
            port = Integer.parseInt(portStr);
        }
        LocateRegistry.createRegistry(port);
        System.err.println("Listening server " + port);
        if (!((String)object).startsWith("//") && port != 1099) {
            object = "//localhost:" + port + "/" + (String)object;
        }
        ProjectServer res = new ProjectServer();
        Naming.bind((String)object, res);
        System.err.println("Listening server object " + (String)object);
        return res;
    }

    @Override
    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CLOSE: 
            case CREATE: {
                this.changesByDate.clear();
                break;
            }
            case LOAD: {
                this.changesByDate.clear();
                TreeMap<Long, SourceTextEntry> usedEntries = new TreeMap<Long, SourceTextEntry>();
                IProject proj = Core.getProject();
                for (SourceTextEntry sourceTextEntry : proj.getAllEntries()) {
                    TMXEntry te = proj.getTranslationInfo(sourceTextEntry.getKey());
                    if (!te.isTranslated()) continue;
                    long time = Math.max(te.creationDate, te.changeDate);
                    while (usedEntries.containsKey(time)) {
                        ++time;
                    }
                    usedEntries.put(time, sourceTextEntry);
                }
                for (Map.Entry entry : usedEntries.entrySet()) {
                    this.changesByDate.addLast((SourceTextEntry)entry.getValue());
                }
                break;
            }
        }
    }

    @Override
    public String findChanges(long timeStamp) {
        IProject proj = Core.getProject();
        if (!(proj instanceof RealProject)) {
            return null;
        }
        Iterator<SourceTextEntry> iter = this.changesByDate.descendingIterator();
        this.openedCursors.put(iter.toString() + "#" + timeStamp, iter);
        return iter.toString() + "#" + timeStamp;
    }

    @Override
    public boolean next(String id) throws RemoteException {
        Iterator<SourceTextEntry> iter = this.openedCursors.get(id);
        if (iter == null) {
            throw new RemoteException("Cursor " + id + " does not exist");
        }
        if (iter.hasNext()) {
            try {
                SourceTextEntry next = iter.next();
                TMXEntry te = Core.getProject().getTranslationInfo(next.getKey());
                long timeStamp = Long.parseLong(id.substring(id.lastIndexOf(35) + 1));
                if (te.changeDate > timeStamp || te.creationDate > timeStamp) {
                    this.openedEntries.put(id, iter.next());
                    return true;
                }
            }
            catch (Exception e) {
                Log.log(e);
            }
        }
        this.openedEntries.remove(id);
        this.openedCursors.remove(id);
        return false;
    }

    @Override
    public String getEntrySource(String id) {
        return this.openedEntries.get(id).getSrcText();
    }

    @Override
    public String getEntryTranslation(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return null;
        }
        return te.translation;
    }

    @Override
    public String getEntryAuthor(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return null;
        }
        return te.creator;
    }

    @Override
    public String getEntryLastModifier(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return null;
        }
        return te.changer;
    }

    @Override
    public long getEntryCreationDate(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return 0L;
        }
        return te.creationDate;
    }

    @Override
    public long getEntryLastModificationDate(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return 0L;
        }
        return te.changeDate;
    }

    @Override
    public String getEntryNote(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return null;
        }
        return te.note;
    }

    @Override
    public String[] getEntryKey(String id) {
        TMXEntry te = Core.getProject().getTranslationInfo(this.openedEntries.get(id).getKey());
        if (te == null) {
            return null;
        }
        if (te.defaultTranslation) {
            return null;
        }
        EntryKey key = this.openedEntries.get(id).getKey();
        return new String[]{key.file, key.sourceText, key.id, key.prev, key.next, key.path};
    }

    @Override
    public void registerDefaultTranslation(String src, String tra) {
        SourceTextEntry ste;
        if (this.entries == null) {
            this.entries = new ProjectMemory.ExtendedCheckOrphanedCallback(Core.getProject().getAllEntries());
        }
        if ((ste = this.entries.existSource.get(src)) == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, true, null);
        this.setSourceEntryModified(ste);
    }

    @Override
    public void registerAltTranslation(String src, String tra, String file, String id, String path, String prev, String next) {
        SourceTextEntry ste;
        if (this.entries == null) {
            this.entries = new ProjectMemory.ExtendedCheckOrphanedCallback(Core.getProject().getAllEntries());
        }
        if ((ste = this.entries.existKeys.get(new EntryKey(file, src, id, prev, next, path))) == null) {
            return;
        }
        PrepareTMXEntry pe = new PrepareTMXEntry();
        pe.source = src;
        pe.translation = tra;
        Core.getProject().setTranslation(ste, pe, false, null);
        this.setSourceEntryModified(ste);
    }

    public void setSourceEntryModified(SourceTextEntry ste) {
        this.changesByDate.remove(ste);
        this.changesByDate.addLast(ste);
    }

    @Override
    public long timeStamp() {
        return System.currentTimeMillis();
    }
}

