/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.omegat.core.segmentation.ISegmentationData;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.StaticUtils;

public class CSC
implements ISegmentationData {
    public static final String CSC_URI = "http://culter.silvestris-lab.org/compatible";
    private static final XMLInputFactory staxInputFactory = XMLInputFactory.newInstance();
    public static final Pattern PATTERN_CSC_VARIABLE = Pattern.compile("%[\\{\\<](\\w+)[\\>\\}]");
    private HashMap<String, List<ApplyRuleTemplate>> namedLists = new HashMap();
    private boolean cascade = true;
    private List<MapRule> mappingRules = new ArrayList<MapRule>();
    private HashMap<String, Rule> templatesMap = new HashMap();
    private boolean includeStartingTags = false;
    private boolean includeEndingTags = true;
    private boolean includeIsolatedTags = false;
    private static final XMLOutputFactory staxOutputFactory = XMLOutputFactory.newInstance();

    public CSC() {
    }

    public CSC(SRX ori) {
        this.cascade = ori.isCascade();
        this.mappingRules = ori.getMappingRules();
        for (MapRule mr : this.mappingRules) {
            if (this.namedLists.get(mr.getLanguageCode()) != null) continue;
            ArrayList<ApplyRuleTemplate> newList = new ArrayList<ApplyRuleTemplate>(mr.getRules().size());
            this.namedLists.put(mr.getLanguageCode(), newList);
            for (Rule rule0 : mr.getRules()) {
                newList.add(new ApplyRuleTemplate(rule0));
            }
        }
    }

    protected static CSC loadCscxFile(URL rulesUrl) throws Exception {
        CSC data = new CSC();
        CSC base = null;
        try (InputStream io = rulesUrl.openStream();){
            XMLStreamReader reader = staxInputFactory.createXMLStreamReader(io);
            while (reader.hasNext()) {
                int next = reader.next();
                if (next == 1) {
                    block9 : switch (reader.getName().getLocalPart()) {
                        case "seg-rules": {
                            String extendsAttr = reader.getAttributeValue(null, "extends");
                            if (extendsAttr == null) break;
                            if (extendsAttr.toUpperCase().equals("#DEFAULT-CONFIG")) {
                                base = new CSC(ISegmentationData.getDefault());
                            } else if (extendsAttr.toUpperCase().equals("#GLOBAL-CONFIG")) {
                                ISegmentationData baseData = ISegmentationData.loadFromDir(new File(StaticUtils.getConfigDir()), true);
                                if (baseData instanceof SRX) {
                                    base = new CSC((SRX)baseData);
                                }
                                if (baseData instanceof CSC) {
                                    base = (CSC)baseData;
                                }
                            } else {
                                URL baseUrl = new URL(rulesUrl, extendsAttr);
                                if (extendsAttr.toLowerCase().endsWith(".srx")) {
                                    base = new CSC(SRX.loadSrxFile(baseUrl));
                                }
                                if (extendsAttr.toLowerCase().endsWith(".cscx")) {
                                    base = CSC.loadCscxFile(baseUrl);
                                }
                            }
                            data.templatesMap = (HashMap)base.templatesMap.clone();
                            data.namedLists = (HashMap)base.namedLists.clone();
                            break;
                        }
                        case "rules-mapping": {
                            data.readRulesMapping(reader, base);
                            break;
                        }
                        case "rule-templates": {
                            data.readRuleTemplates(reader);
                            break;
                        }
                        case "languagerules": {
                            data.readLanguageRules(reader, rulesUrl);
                            break;
                        }
                        case "formathandle": {
                            switch (reader.getAttributeValue(null, "type")) {
                                case "start": {
                                    data.includeStartingTags = "yes".equals(reader.getAttributeValue(null, "include"));
                                    break block9;
                                }
                                case "end": {
                                    data.includeEndingTags = "yes".equals(reader.getAttributeValue(null, "include"));
                                    break block9;
                                }
                                case "isolated": {
                                    data.includeIsolatedTags = "yes".equals(reader.getAttributeValue(null, "include"));
                                }
                            }
                        }
                    }
                }
                if (next != 2 || !reader.getName().getLocalPart().equals("seg-rules") || base == null || data.mappingRules.size() != 0) continue;
                data.mappingRules.addAll(base.mappingRules);
            }
            reader.close();
        }
        return data;
    }

    private void readRulesMapping(XMLStreamReader reader, CSC base) throws Exception {
        this.setCascade(!"false".equals(reader.getAttributeValue(null, "cascade")));
        String extensionMode = reader.getAttributeValue(null, "extension-mode");
        if ("after".equals(extensionMode)) {
            this.mappingRules.addAll(base.mappingRules);
        }
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().equals("rules-mapping")) {
                return;
            }
            if (next != 1 || !reader.getName().getLocalPart().equals("languagemap")) continue;
            try {
                this.mappingRules.add(new MapRule(reader.getAttributeValue(null, "languagerulename"), reader.getAttributeValue(null, "languagepattern"), null));
            }
            catch (Exception e) {
                Log.log("Warning: wrong map rule in CSC file: " + reader.getName());
            }
        }
        if ("before".equals(extensionMode)) {
            this.mappingRules.addAll(base.mappingRules);
        }
    }

    private void readRuleTemplates(XMLStreamReader reader) throws Exception {
        Rule currentRule = null;
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().equals("rule-templates")) {
                return;
            }
            if (next != 1) continue;
            try {
                if (reader.getName().getLocalPart().equals("rule-template")) {
                    currentRule = new Rule();
                    this.templatesMap.put(reader.getAttributeValue(null, "name"), currentRule);
                }
                if (reader.getName().getLocalPart().equals("rule")) {
                    currentRule.setBreakRule("yes".equals(reader.getAttributeValue(null, "break")));
                    this.readRule(reader, currentRule);
                }
                if (reader.getName().getLocalPart().equals("break-rule")) {
                    currentRule.setBreakRule(true);
                    this.readRule(reader, currentRule);
                }
                if (!reader.getName().getLocalPart().equals("exception-rule")) continue;
                currentRule.setBreakRule(false);
                this.readRule(reader, currentRule);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException npe) {
                Log.log("Error [CSC]: something wrong (probably missing attribute) with rule template : " + reader.getName());
            }
        }
    }

    private void readRule(XMLStreamReader reader, Rule currentRule) throws Exception {
        StringBuffer text = new StringBuffer();
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().endsWith("rule")) {
                return;
            }
            if (next == 1 && reader.getName().getLocalPart().equals("beforebreak")) {
                text.setLength(0);
            }
            if (next == 1 && reader.getName().getLocalPart().equals("afterbreak")) {
                text.setLength(0);
            }
            if (next == 4) {
                text.append(reader.getText());
            }
            if (next == 2 && reader.getName().getLocalPart().equals("beforebreak")) {
                currentRule.setBeforebreak(PATTERN_CSC_VARIABLE.matcher(text.toString()).replaceAll("%<$1>"));
                text.setLength(0);
            }
            if (next != 2 || !reader.getName().getLocalPart().equals("afterbreak")) continue;
            currentRule.setAfterbreak(PATTERN_CSC_VARIABLE.matcher(text.toString()).replaceAll("%<$1>"));
            text.setLength(0);
        }
    }

    private void readLanguageRules(XMLStreamReader reader, URL dataURL) throws Exception {
        ArrayList<ApplyRuleTemplate> currentList = null;
        String extensionMode = reader.getAttributeValue(null, "extension-mode");
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().endsWith("languagerules")) {
                return;
            }
            if (next != 1 || !reader.getName().getLocalPart().equals("languagerule")) continue;
            currentList = new ArrayList<ApplyRuleTemplate>();
            if (extensionMode == null || extensionMode.equals("overwrite")) {
                this.namedLists.put(reader.getAttributeValue(null, "languagerulename"), currentList);
            } else if (extensionMode.equals("before")) {
                this.namedLists.get(reader.getAttributeValue(null, "languagerulename")).addAll(0, currentList);
            } else if (extensionMode.equals("after")) {
                this.namedLists.get(reader.getAttributeValue(null, "languagerulename")).addAll(currentList);
            }
            this.readSingleLanguageRule(reader, currentList, dataURL);
        }
    }

    private void readSingleLanguageRule(XMLStreamReader reader, List<ApplyRuleTemplate> currentList, URL dataURL) throws Exception {
        Rule currentRule = null;
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().endsWith("languagerule")) {
                return;
            }
            if (next == 1 && reader.getName().getLocalPart().equals("rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule("yes".equals(reader.getAttributeValue(null, "break")));
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (next == 1 && reader.getName().getLocalPart().equals("break-rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule(true);
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (next == 1 && reader.getName().getLocalPart().equals("exception-rule")) {
                currentRule = new Rule();
                currentRule.setBreakRule(false);
                this.readRule(reader, currentRule);
                currentList.add(new ApplyRuleTemplate(currentRule));
            }
            if (next != 1 || !reader.getName().getLocalPart().equals("apply-rule-template")) continue;
            currentRule = this.templatesMap.get(reader.getAttributeValue(null, "name"));
            ApplyRuleTemplate withParams = new ApplyRuleTemplate(currentRule, new HashMap<String, List<String>>(), new ArrayList<String>());
            withParams.name = reader.getAttributeValue(null, "name");
            this.readParameters(reader, withParams.params, withParams.paramOrder, dataURL);
            currentList.add(withParams);
        }
    }

    private void readParameters(XMLStreamReader reader, HashMap<String, List<String>> params, List<String> order, URL dataURL) throws Exception {
        String curName = null;
        ArrayList<String> curList = null;
        StringBuffer buf = new StringBuffer();
        while (reader.hasNext()) {
            int next = reader.next();
            if (next == 2 && reader.getName().getLocalPart().endsWith("apply-rule-template")) {
                return;
            }
            if (next == 1 && reader.getName().getLocalPart().equals("param")) {
                curName = reader.getAttributeValue(null, "name");
                order.add(curName);
                if (reader.getAttributeValue(null, "val") != null) {
                    params.put(curName, Collections.singletonList(reader.getAttributeValue(null, "val")));
                } else {
                    curList = new ArrayList<String>();
                    params.put(curName, curList);
                }
            }
            if (next == 1 && reader.getName().getLocalPart().equals("item")) {
                buf.setLength(0);
            }
            if (next == 4) {
                buf.append(reader.getText());
            }
            if (next == 2 && reader.getName().getLocalPart().endsWith("item")) {
                curList.add(buf.toString());
            }
            if (next != 1 || !reader.getName().getLocalPart().equals("item-list-file")) continue;
            InputStream is = new URL(dataURL, reader.getAttributeValue(null, "name")).openStream();
            try {
                String encoding = "UTF-8";
                String attr = reader.getAttributeValue(null, "format");
                if (attr != null) {
                    encoding = attr;
                    encoding = encoding.substring(encoding.indexOf(58) + 1);
                }
                Pattern remove = null;
                attr = reader.getAttributeValue(null, "remove");
                if (attr != null) {
                    remove = Pattern.compile(attr);
                }
                Pattern comments = null;
                attr = reader.getAttributeValue(null, "comments");
                if (attr != null) {
                    comments = Pattern.compile(attr);
                }
                try (BufferedReader fileReader = new BufferedReader(new InputStreamReader(is, encoding));){
                    String line = "";
                    while ((line = fileReader.readLine()) != null) {
                        if (comments != null && comments.matcher(line).matches()) continue;
                        line = remove.matcher(line).replaceAll("");
                        curList.add(line);
                    }
                }
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    @Override
    public List<Rule> lookupRulesForLanguage(Language srclang) {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        for (int i = 0; i < this.mappingRules.size(); ++i) {
            MapRule maprule = this.mappingRules.get(i);
            if (!maprule.getCompiledPattern().matcher(srclang.getLanguageCode()).matches()) continue;
            for (ApplyRuleTemplate tpl : this.namedLists.get(maprule.getLanguageCode())) {
                if (tpl.params == null) {
                    rules.add(tpl.rule);
                    continue;
                }
                String before = tpl.rule.getBeforebreak();
                String after = tpl.rule.getAfterbreak();
                for (String paramName : tpl.paramOrder) {
                    before = before.replace("%<" + paramName + ">", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)tpl.params.get(paramName)));
                    after = after.replace("%<" + paramName + ">", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)tpl.params.get(paramName)));
                }
                rules.add(new Rule(tpl.rule.isBreakRule(), before, after));
            }
            if (!this.cascade) break;
        }
        return rules;
    }

    @Override
    public SRX toSRX() {
        SRX res = new SRX();
        res.setCascade(this.cascade);
        ArrayList<MapRule> newRules = new ArrayList<MapRule>(this.mappingRules.size());
        for (MapRule mapRule0 : this.mappingRules) {
            ArrayList<Rule> srxRules = new ArrayList<Rule>();
            for (ApplyRuleTemplate tpl : this.namedLists.get(mapRule0.getLanguageCode())) {
                if (tpl.params == null) {
                    srxRules.add(tpl.rule);
                    continue;
                }
                CSC.toSrxRules(tpl.rule.getBeforebreak(), tpl.rule.getAfterbreak(), tpl, 0, srxRules);
            }
            newRules.add(new MapRule(mapRule0.getLanguageCode(), mapRule0.getPattern(), srxRules));
        }
        res.setMappingRules(newRules);
        return res;
    }

    private static void toSrxRules(String before, String after, ApplyRuleTemplate tpl, int paramId, List<Rule> srxRules) {
        if (paramId >= tpl.paramOrder.size()) {
            srxRules.add(new Rule(tpl.rule.isBreakRule(), before, after));
        } else {
            String paramName = tpl.paramOrder.get(paramId);
            for (String paramVal : tpl.params.get(paramName)) {
                CSC.toSrxRules(before.replace("%<" + paramName + ">", paramVal), after.replace("%<" + paramName + ">", paramVal), tpl, paramId + 1, srxRules);
            }
        }
    }

    @Override
    public boolean isCascade() {
        return this.cascade;
    }

    public void setCascade(boolean cascade) {
        this.cascade = cascade;
    }

    @Override
    public boolean isIncludeStartingTags() {
        return this.includeStartingTags;
    }

    public void setIncludeStartingTags(boolean includeStartingTags) {
        this.includeStartingTags = includeStartingTags;
    }

    @Override
    public boolean isIncludeEndingTags() {
        return this.includeEndingTags;
    }

    public void setIncludeEndingTags(boolean includeEndingTags) {
        this.includeEndingTags = includeEndingTags;
    }

    @Override
    public boolean isIncludeIsolatedTags() {
        return this.includeIsolatedTags;
    }

    public void setIncludeIsolatedTags(boolean includeIsolatedTags) {
        this.includeIsolatedTags = includeIsolatedTags;
    }

    public HashMap<String, Rule> getTemplates() {
        return this.templatesMap;
    }

    @Override
    public List<MapRule> getMappingRules() {
        return this.mappingRules;
    }

    @Override
    public void insertMapRule(int pos, MapRule mr) {
        this.mappingRules.add(pos, mr);
        this.namedLists.put(mr.getLanguageCode(), new ArrayList());
    }

    @Override
    public void insertRule(int pos, MapRule mr, Rule r) {
        mr.getRules().add(pos, r);
        this.namedLists.get(mr.getLanguageCode()).add(new ApplyRuleTemplate(r, null, null));
    }

    public void addTemplateApply(MapRule mr, String templateName, String templateVar) {
        List<ApplyRuleTemplate> tl = this.namedLists.get(mr.getLanguageCode());
        for (ApplyRuleTemplate art : tl) {
            if (!art.name.equals(templateName)) continue;
            List<String> values = art.params.values().iterator().next();
            try {
                values.add(templateVar);
            }
            catch (Exception e) {
                String key = art.params.keySet().iterator().next();
                values = new ArrayList<String>((Collection)art.params.get(key));
                art.params.put(key, values);
                values.add(templateVar);
            }
        }
        HashMap<String, List<String>> params = new HashMap<String, List<String>>();
        ArrayList<String> paramOrder = new ArrayList<String>(1);
        Matcher matcher = PATTERN_CSC_VARIABLE.matcher(this.templatesMap.get(templateName).getBeforebreak());
        while (matcher.find()) {
            paramOrder.add(matcher.group(1));
            params.put(matcher.group(1), new ArrayList());
        }
        matcher = PATTERN_CSC_VARIABLE.matcher(this.templatesMap.get(templateName).getAfterbreak());
        while (matcher.find()) {
            paramOrder.add(matcher.group(1));
            params.put(matcher.group(1), new ArrayList());
        }
        ((List)params.values().iterator().next()).add(templateVar);
        ApplyRuleTemplate art = new ApplyRuleTemplate(this.templatesMap.get(templateName), params, paramOrder);
        art.name = templateName;
        tl.add(art);
    }

    public static void saveTo(CSC csc, File outFile) throws IOException {
        try (OutputStreamWriter fos = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");){
            XMLStreamWriter writer = staxOutputFactory.createXMLStreamWriter(fos);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeStartElement("seg-rules");
            writer.writeDefaultNamespace(CSC_URI);
            writer.writeCharacters("\n    ");
            writer.writeStartElement("rules-mapping");
            writer.writeAttribute("cascade", Boolean.toString(csc.cascade));
            for (MapRule mapRule : csc.mappingRules) {
                writer.writeCharacters("\n        ");
                writer.writeEmptyElement("languagemap");
                writer.writeAttribute("languagerulename", mapRule.getLanguageCode());
                writer.writeAttribute("languagepattern", mapRule.getPattern());
            }
            writer.writeCharacters("\n    ");
            writer.writeEndElement();
            writer.writeCharacters("\n    ");
            writer.writeStartElement("rule-templates");
            for (Map.Entry entry : csc.templatesMap.entrySet()) {
                writer.writeCharacters("\n        ");
                writer.writeStartElement("rule-template");
                writer.writeAttribute("name", (String)entry.getKey());
                writer.writeCharacters("\n            ");
                writer.writeStartElement("rewrite");
                writer.writeCharacters("\n                ");
                writer.writeStartElement("rule");
                writer.writeAttribute("break", ((Rule)entry.getValue()).isBreakRule() ? "yes" : "no");
                writer.writeCharacters("\n                    ");
                writer.writeStartElement("beforebreak");
                writer.writeCharacters(((Rule)entry.getValue()).getBeforebreak().replaceAll("<", "{").replaceAll(">", "}"));
                writer.writeEndElement();
                writer.writeCharacters("\n                    ");
                writer.writeStartElement("afterbreak");
                writer.writeCharacters(((Rule)entry.getValue()).getAfterbreak().replaceAll("<", "{").replaceAll(">", "}"));
                writer.writeEndElement();
                writer.writeCharacters("\n                ");
                writer.writeEndElement();
                writer.writeCharacters("\n            ");
                writer.writeEndElement();
                writer.writeCharacters("\n        ");
                writer.writeEndElement();
            }
            writer.writeCharacters("\n    ");
            writer.writeEndElement();
            writer.writeCharacters("\n    ");
            writer.writeStartElement("languagerules");
            for (Map.Entry entry : csc.namedLists.entrySet()) {
                writer.writeCharacters("\n        ");
                writer.writeStartElement("languagerule");
                writer.writeAttribute("languagerulename", entry.getKey().toString());
                for (ApplyRuleTemplate tpl : (List)entry.getValue()) {
                    if (tpl.params == null) {
                        writer.writeCharacters("\n            ");
                        writer.writeStartElement("rule");
                        writer.writeAttribute("break", tpl.rule.isBreakRule() ? "yes" : "no");
                        writer.writeCharacters("\n                ");
                        writer.writeStartElement("beforebreak");
                        writer.writeCharacters(tpl.rule.getBeforebreak());
                        writer.writeEndElement();
                        writer.writeCharacters("\n                ");
                        writer.writeStartElement("afterbreak");
                        writer.writeCharacters(tpl.rule.getAfterbreak());
                        writer.writeEndElement();
                        writer.writeCharacters("\n            ");
                        writer.writeEndElement();
                        continue;
                    }
                    writer.writeCharacters("\n            ");
                    writer.writeStartElement("apply-rule-template");
                    writer.writeAttribute("name", tpl.name);
                    for (String param : tpl.paramOrder) {
                        writer.writeCharacters("\n                ");
                        writer.writeStartElement("param");
                        writer.writeAttribute("name", param);
                        if (tpl.params.get(param).size() < 2) {
                            writer.writeAttribute("mode", "value");
                            writer.writeAttribute("value", tpl.params.get(param).size() == 0 ? "" : tpl.params.get(param).get(0));
                        } else {
                            writer.writeAttribute("mode", "loop");
                            for (String val : tpl.params.get(param)) {
                                writer.writeCharacters("\n                    ");
                                writer.writeStartElement("item");
                                writer.writeCharacters(val);
                                writer.writeEndElement();
                            }
                        }
                        writer.writeCharacters("\n                ");
                        writer.writeEndElement();
                    }
                    writer.writeCharacters("\n            ");
                    writer.writeEndElement();
                }
                writer.writeCharacters("\n        ");
                writer.writeEndElement();
            }
            writer.writeCharacters("\n    ");
            writer.writeEndElement();
            writer.writeCharacters("\n");
            writer.writeEndElement();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static class ApplyRuleTemplate {
        Rule rule;
        HashMap<String, List<String>> params;
        List<String> paramOrder;
        String name;

        ApplyRuleTemplate(Rule rule) {
            this.rule = rule;
            this.params = null;
            this.paramOrder = null;
        }

        ApplyRuleTemplate(Rule rule, HashMap<String, List<String>> params, List<String> order) {
            this.rule = rule;
            this.params = params;
            this.paramOrder = order;
        }
    }
}

