/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.segmentation;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.omegat.core.segmentation.CSC;
import org.omegat.core.segmentation.MapRule;
import org.omegat.core.segmentation.Rule;
import org.omegat.core.segmentation.SRX;
import org.omegat.util.Language;
import org.omegat.util.Log;

public interface ISegmentationData {
    public static final String CONF_SENTSEG = "segmentation.conf";
    public static final String SRX_SENTSEG = "segmentation.srx";
    public static final String CSCX_SENTSEG = "segmentation.cscx";

    public List<Rule> lookupRulesForLanguage(Language var1);

    public SRX toSRX();

    public static ISegmentationData loadFromDir(File configDir, boolean fallbackDefault) {
        SRX res4;
        File inFile = new File(configDir, CSCX_SENTSEG.replace(".", "-2conf."));
        if (inFile.exists()) {
            try {
                CSC res2 = CSC.loadCscxFile(inFile.toURL());
                try {
                    SRX.saveToConf(res2.toSRX(), new File(configDir, CONF_SENTSEG));
                    inFile.delete();
                }
                catch (Exception i1) {
                    Log.log(i1);
                }
                return res2;
            }
            catch (Exception o1) {
                Log.log(o1);
            }
        }
        if ((inFile = new File(configDir, CSCX_SENTSEG.replace(".", "-2srx."))).exists()) {
            try {
                CSC res3 = CSC.loadCscxFile(inFile.toURL());
                try {
                    SRX.saveToSrx(res3.toSRX(), new File(configDir, SRX_SENTSEG));
                    inFile.delete();
                }
                catch (Exception i1) {
                    Log.log(i1);
                }
                return res3;
            }
            catch (Exception o2) {
                Log.log(o2);
            }
        }
        if ((inFile = new File(configDir, CSCX_SENTSEG)).exists()) {
            try {
                return CSC.loadCscxFile(inFile.toURL());
            }
            catch (Exception o2) {
                Log.log(o2);
            }
        }
        if ((inFile = new File(configDir, SRX_SENTSEG.replace(".", "-2conf."))).exists()) {
            try {
                res4 = SRX.loadSrxFile(inFile.toURL());
                try {
                    SRX.saveToConf(res4, new File(configDir, CONF_SENTSEG));
                    inFile.delete();
                }
                catch (Exception i1) {
                    Log.log(i1);
                }
                return res4;
            }
            catch (Exception res4) {
                // empty catch block
            }
        }
        if ((inFile = new File(configDir, CONF_SENTSEG.replace(".", "-2srx."))).exists()) {
            res4 = SRX.loadConfFile(inFile);
            try {
                inFile.delete();
                SRX.saveToSrx(res4, new File(configDir, SRX_SENTSEG));
            }
            catch (Exception i2) {
                Log.log(i2);
            }
            return res4;
        }
        inFile = new File(configDir, CONF_SENTSEG);
        if (inFile.exists()) {
            return SRX.loadConfFile(inFile);
        }
        inFile = new File(configDir, SRX_SENTSEG);
        if (inFile.exists()) {
            try {
                return SRX.loadSrxFile(inFile.toURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return fallbackDefault ? ISegmentationData.getDefault() : null;
    }

    public static void saveTo(ISegmentationData data, File outDir) throws IOException {
        if (data == null) {
            SRX.saveTo(null, outDir);
        }
        if (data instanceof SRX) {
            SRX.saveTo((SRX)data, outDir);
        }
        if (data instanceof CSC) {
            CSC.saveTo((CSC)data, new File(outDir, CSCX_SENTSEG));
        }
    }

    public static boolean projectConfigFileExists(String configDir) {
        File configFile = new File(configDir + CONF_SENTSEG);
        return configFile.exists();
    }

    public static SRX getDefault() {
        SRX srx = SRX.loadSrxFile(SRX.class.getResource("defaultRules.srx"));
        return srx;
    }

    public boolean isCascade();

    public boolean isIncludeStartingTags();

    public boolean isIncludeEndingTags();

    public boolean isIncludeIsolatedTags();

    public List<MapRule> getMappingRules();

    public void insertMapRule(int var1, MapRule var2);

    public void insertRule(int var1, MapRule var2, Rule var3);
}

