/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.spellchecker;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.omegat.core.spellchecker.Hunspell;
import org.omegat.core.spellchecker.ISpellCheckerProvider;
import org.omegat.util.Log;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class SpellCheckerHunspell
implements ISpellCheckerProvider {
    private static final Logger LOGGER = Logger.getLogger(SpellCheckerHunspell.class.getName());
    private Hunspell hunspell;
    private Pointer pHunspell;
    private String encoding;
    private boolean addNotSupportedLogged = false;
    private boolean addToHunspell = true;

    public SpellCheckerHunspell(String language, String dictionaryName, String affixName) throws Exception {
        if (this.hunspell == null) {
            String baseHunspellLib = SpellCheckerHunspell.getBaseHunspellLibraryName();
            if (baseHunspellLib == null) {
                throw new ExceptionInInitializerError("System not recognized: os.name=" + System.getProperty("os.name") + " os.arch=" + System.getProperty("os.arch"));
            }
            String libraryPath = Platform.isWebStart() ? Native.getWebStartLibraryPath((String)baseHunspellLib) + File.separator + SpellCheckerHunspell.mapLibraryName(baseHunspellLib) : StaticUtils.installDir() + File.separator + "native" + File.separator + SpellCheckerHunspell.mapLibraryName(baseHunspellLib);
            this.hunspell = (Hunspell)Native.loadLibrary((String)libraryPath, Hunspell.class);
            Log.log("Hunspell loaded successfully from " + libraryPath);
        }
        this.pHunspell = this.hunspell.Hunspell_create(affixName, dictionaryName);
        this.encoding = this.hunspell.Hunspell_get_dic_encoding(this.pHunspell);
        LOGGER.finer("Initialize SpellChecker by Hunspell for language '" + language + "' dictionary " + dictionaryName);
    }

    @Override
    public void destroy() {
        this.hunspell.Hunspell_destroy(this.pHunspell);
        this.pHunspell = null;
    }

    @Override
    public boolean isCorrect(String word) {
        boolean isCorrect = false;
        try {
            if (0 != this.hunspell.Hunspell_spell(this.pHunspell, SpellCheckerHunspell.prepareString(word, this.encoding))) {
                isCorrect = true;
            }
        }
        catch (UnsupportedEncodingException ex) {
            Log.log("Unsupported encoding " + this.encoding);
        }
        return isCorrect;
    }

    @Override
    public List<String> suggest(String word) {
        PointerByReference strings = new PointerByReference();
        int total = 0;
        try {
            total = this.hunspell.Hunspell_suggest(this.pHunspell, strings, SpellCheckerHunspell.prepareString(word, this.encoding));
        }
        catch (UnsupportedEncodingException ex) {
            Log.log("Unsupported encoding " + this.encoding);
        }
        Pointer[] pointerArray = null;
        Pointer pointer = strings.getValue();
        if (pointer != null) {
            try {
                pointerArray = pointer.getPointerArray(0L, total);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
        ArrayList<String> aList = new ArrayList<String>();
        if (pointerArray != null) {
            Charset charset = Charset.forName(this.encoding);
            CharsetDecoder decoder = charset.newDecoder();
            for (int i = 0; i < total; ++i) {
                try {
                    byte current;
                    byte[] buffer = new byte[100];
                    for (int bufferCursor = 0; bufferCursor < 100 && (current = pointerArray[i].getByte((long)bufferCursor)) != 0; ++bufferCursor) {
                        buffer[bufferCursor] = current;
                    }
                    CharBuffer cbuf = decoder.decode(ByteBuffer.wrap(buffer));
                    aList.add(cbuf.toString().trim());
                    continue;
                }
                catch (CharacterCodingException ex) {
                    Log.log("Unsupported encoding " + this.encoding);
                }
            }
        }
        return aList;
    }

    @Override
    public void learnWord(String word) {
        try {
            this.addWord(this.pHunspell, SpellCheckerHunspell.prepareString(word, this.encoding));
        }
        catch (UnsupportedEncodingException ex) {
            Log.log("Unsupported encoding " + this.encoding);
        }
    }

    private void addWord(Pointer pHunspell, byte[] word) {
        if (!this.addToHunspell) {
            return;
        }
        try {
            this.hunspell.Hunspell_add(pHunspell, word);
            Log.log("Hunspell_add OK");
        }
        catch (Error err1) {
            if (!this.addNotSupportedLogged) {
                Log.log("Hunspell_add not supported");
                this.addNotSupportedLogged = true;
            }
            try {
                this.hunspell.Hunspell_put_word(pHunspell, word);
                Log.log("Hunspell_put_word OK");
            }
            catch (Error err2) {
                Log.log("Hunspell_put_word not supported");
                this.addToHunspell = false;
            }
        }
    }

    protected static byte[] prepareString(String word, String encoding) throws UnsupportedEncodingException {
        return (word + "\u0000").getBytes(encoding);
    }

    protected static String getBaseHunspellLibraryName() {
        switch (Platform.getOsType()) {
            case LINUX64: {
                return "hunspell-linux64";
            }
            case MAC64: {
                return "hunspell-macos64";
            }
            case WIN64: {
                return "hunspell-win64";
            }
            case LINUX32: {
                return "hunspell-linux32";
            }
            case MAC32: {
                return "hunspell-macos32";
            }
            case WIN32: {
                return "hunspell-win32";
            }
        }
        return null;
    }

    protected static String mapLibraryName(String libName) {
        Object result = System.mapLibraryName(libName);
        if (Platform.isMacOSX() && ((String)result).endsWith(".jnilib")) {
            result = ((String)result).substring(0, ((String)result).lastIndexOf(".jnilib")) + ".dylib";
        }
        return result;
    }
}

