/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.matching.FindMatches;
import org.omegat.core.matching.external.IExternalMemory;
import org.omegat.core.statistics.FindMatchesStatistics;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.MatchStatCounts;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.StringUtil;
import org.omegat.util.gui.TextUtil;

public class CalcMatchStatistics
extends LongProcessThread {
    private final String[] header = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters")};
    private final String[] rowsTotal = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitions"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch"), OStrings.getString("CT_STATSMATCH_Total")};
    private final String[] rowsPerFile = new String[]{OStrings.getString("CT_STATSMATCH_RowRepetitionsWithinThisFile"), OStrings.getString("CT_STATSMATCH_RowRepetitionsFromOtherFiles"), OStrings.getString("CT_STATSMATCH_RowExactMatch"), OStrings.getString("CT_STATSMATCH_RowMatch95"), OStrings.getString("CT_STATSMATCH_RowMatch85"), OStrings.getString("CT_STATSMATCH_RowMatch75"), OStrings.getString("CT_STATSMATCH_RowMatch50"), OStrings.getString("CT_STATSMATCH_RowNoMatch"), OStrings.getString("CT_STATSMATCH_Total")};
    private final boolean[] align = new boolean[]{false, true, true, true, true};
    private final IStatisticsPanel.Matches callback;
    private final boolean perFile;
    private int entriesToProcess;
    private final Set<String> alreadyProcessedInFile = new HashSet<String>();
    private final Set<String> alreadyProcessedInProject = new HashSet<String>();
    private FindMatchesStatistics finder;
    private final StringBuilder textForLog = new StringBuilder();
    int treated;
    int percent;

    public CalcMatchStatistics(IStatisticsPanel.Matches callback, boolean perFile) {
        this.callback = callback;
        this.perFile = perFile;
    }

    @Override
    public void run() {
        this.finder = new FindMatchesStatistics(Core.getProject().getSourceTokenizer(), new IExternalMemory[0], true, false);
        if (this.perFile) {
            this.entriesToProcess = Core.getProject().getAllEntries().size() * 2;
            this.calcPerFile();
        } else {
            this.entriesToProcess = Core.getProject().getAllEntries().size();
            this.calcTotal(true);
        }
        this.callback.finishData();
    }

    void appendText(String text) {
        this.textForLog.append(text);
        this.callback.appendTextData(text);
    }

    void showText(String text) {
        this.textForLog.setLength(0);
        this.textForLog.append(text);
        this.callback.setTextData(text);
    }

    void appendTable(String title, String[][] table) {
        this.callback.appendTable(title, this.header, table);
    }

    void showTable(String[][] table) {
        this.callback.setTable(this.header, table);
    }

    void calcPerFile() {
        int fileNumber = 0;
        for (IProject.FileInfo fi : Core.getProject().getProjectFiles()) {
            MatchStatCounts perFile = this.forFile(fi);
            this.checkInterrupted();
            String[][] table = perFile.calcTable(this.rowsPerFile);
            String outText = TextUtil.showTextTable(this.header, table, this.align);
            String title = StringUtil.format(OStrings.getString("CT_STATSMATCH_File"), ++fileNumber, fi.filePath);
            this.appendText(title + "\n");
            this.appendText(outText + "\n");
            this.appendTable(title, table);
        }
        MatchStatCounts total = this.calcTotal(false);
        String title = OStrings.getString("CT_STATSMATCH_FileTotal");
        this.appendText(title + "\n");
        String[][] table = total.calcTable(this.rowsTotal);
        String outText = TextUtil.showTextTable(this.header, table, this.align);
        this.appendText(outText + "\n");
        this.appendTable(title, table);
        String fn = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match_per_file.txt";
        Statistics.writeStat(fn, this.textForLog.toString());
        this.callback.setDataFile(fn);
    }

    MatchStatCounts calcTotal(boolean outData) {
        String outText;
        String[][] table;
        MatchStatCounts result = new MatchStatCounts(true);
        this.alreadyProcessedInProject.clear();
        ArrayList<SourceTextEntry> untranslatedEntries = new ArrayList<SourceTextEntry>();
        for (SourceTextEntry ste : Core.getProject().getAllEntries()) {
            this.checkInterrupted();
            StatCount count = new StatCount(ste);
            boolean isFirst = this.alreadyProcessedInProject.add(ste.getSrcText());
            if (Core.getProject().getTranslationInfo(ste.getKey()).isTranslated()) {
                result.addExact(count);
                this.entryProcessed();
                continue;
            }
            if (!isFirst) {
                result.addRepetition(count);
                this.entryProcessed();
                continue;
            }
            untranslatedEntries.add(ste);
        }
        if (outData) {
            table = result.calcTableWithoutPercentage(this.rowsTotal);
            outText = TextUtil.showTextTable(this.header, table, this.align);
            this.showText(outText);
            this.showTable(table);
        }
        this.calcSimilarity(untranslatedEntries, result);
        if (outData) {
            table = result.calcTable(this.rowsTotal);
            outText = TextUtil.showTextTable(this.header, table, this.align);
            this.showText(outText);
            this.showTable(table);
            String fn = Core.getProject().getProjectProperties().getProjectInternal() + "project_stats_match.txt";
            Statistics.writeStat(fn, outText);
            this.callback.setDataFile(fn);
        }
        return result;
    }

    MatchStatCounts forFile(IProject.FileInfo fi) {
        MatchStatCounts result = new MatchStatCounts(false);
        this.alreadyProcessedInFile.clear();
        ArrayList<SourceTextEntry> untranslatedEntries = new ArrayList<SourceTextEntry>();
        for (SourceTextEntry ste : fi.entries) {
            this.checkInterrupted();
            StatCount count = new StatCount(ste);
            boolean existInFile = this.alreadyProcessedInFile.contains(ste.getSrcText());
            boolean existInPreviousFiles = this.alreadyProcessedInProject.contains(ste.getSrcText());
            if (Core.getProject().getTranslationInfo(ste.getKey()).isTranslated()) {
                result.addExact(count);
                ++this.treated;
                continue;
            }
            if (existInPreviousFiles) {
                result.addRepetitionFromOtherFiles(count);
                this.entryProcessed();
                continue;
            }
            if (existInFile) {
                result.addRepetitionWithinThisFile(count);
                this.entryProcessed();
                continue;
            }
            untranslatedEntries.add(ste);
            this.alreadyProcessedInFile.add(ste.getSrcText());
        }
        this.alreadyProcessedInProject.addAll(this.alreadyProcessedInFile);
        this.calcSimilarity(untranslatedEntries, result);
        return result;
    }

    void calcSimilarity(List<SourceTextEntry> untranslatedEntries, MatchStatCounts counts) {
        for (SourceTextEntry ste : untranslatedEntries) {
            this.checkInterrupted();
            String srcNoXmlTags = ste.getSrcText();
            for (ProtectedPart pp : ste.getProtectedParts()) {
                srcNoXmlTags = srcNoXmlTags.replace(pp.getTextInSourceSegment(), pp.getReplacementMatchCalculation());
            }
            int maxSimilarity = -1;
            try {
                maxSimilarity = this.finder.search(Core.getProject(), srcNoXmlTags, true, this::isInterrupted);
            }
            catch (FindMatches.StoppedException ex) {
                return;
            }
            StatCount count = new StatCount(ste);
            counts.addForPercents(maxSimilarity, count);
            this.entryProcessed();
        }
    }

    void entryProcessed() {
        ++this.treated;
        int newPercent = this.treated * 100 / this.entriesToProcess;
        if (this.percent != newPercent) {
            this.callback.showProgress(newPercent);
            this.percent = newPercent;
        }
    }
}

