/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.io.File;
import java.util.ArrayList;
import org.omegat.core.Core;
import org.omegat.core.data.IProject;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.data.TMXEntry;
import org.omegat.core.statistics.CalcStandardStatistics;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.statistics.Statistics;
import org.omegat.core.statistics.StatisticsInfo;
import org.omegat.util.OStrings;
import org.omegat.util.gui.TextUtil;

public class CalcStandardProjectStatistics
extends CalcStandardStatistics {
    public CalcStandardProjectStatistics(IStatisticsPanel.Standard callback) {
        super(callback);
    }

    @Override
    public void run() {
        IProject p = Core.getProject();
        String result = CalcStandardProjectStatistics.buildProjectStats(p, null, this.callback);
        this.callback.setTextData(result);
        this.callback.finishData();
        String internalDir = p.getProjectProperties().getProjectInternal();
        try {
            File oldstats = new File(internalDir + "word_counts");
            if (oldstats.exists()) {
                oldstats.delete();
            }
        }
        catch (Exception oldstats) {
            // empty catch block
        }
        String fn = internalDir + "project_stats.txt";
        Statistics.writeStat(fn, result);
        this.callback.setDataFile(fn);
    }

    public static String buildProjectStats(IProject project, StatisticsInfo hotStat) {
        return CalcStandardProjectStatistics.buildProjectStats(project, hotStat, null);
    }

    public static String buildProjectStats(IProject project, StatisticsInfo hotStat, IStatisticsPanel.Standard callback) {
        CalcStandardStatistics.FileData global = new CalcStandardStatistics.FileData(null);
        ArrayList<CalcStandardStatistics.FileData> counts = new ArrayList<CalcStandardStatistics.FileData>();
        for (IProject.FileInfo file : project.getProjectFiles()) {
            CalcStandardStatistics.FileData numbers = new CalcStandardStatistics.FileData(file.filePath);
            counts.add(numbers);
            for (SourceTextEntry ste : file.entries) {
                String src = ste.getSrcText();
                for (ProtectedPart pp : ste.getProtectedParts()) {
                    src = src.replace(pp.getTextInSourceSegment(), pp.getReplacementUniquenessCalculation());
                }
                TMXEntry tr = project.getTranslationInfo(ste.getKey());
                global.register(src, tr.isTranslated());
                numbers.register(src, tr.isTranslated());
            }
            global.addFile(numbers);
        }
        StringBuilder result = new StringBuilder();
        result.append(OStrings.getString("CT_STATS_Project_Statistics"));
        result.append("\n\n");
        String[][] headerTable = CalcStandardProjectStatistics.calcHeaderTable(new StatCount[]{global.total, global.remaining, global.unique, global.remainingUnique});
        if (callback != null) {
            callback.setProjectTableData(htHeaders, headerTable);
        }
        result.append(TextUtil.showTextTable(htHeaders, headerTable, htAlign));
        result.append("\n\n");
        result.append(OStrings.getString("CT_STATS_FILE_Statistics"));
        result.append("\n\n");
        String[][] filesTable = CalcStandardProjectStatistics.calcFilesTable(project.getProjectProperties().getSourceRoot(), counts);
        if (callback != null) {
            callback.setFilesTableData(ftHeaders, filesTable);
        }
        result.append(TextUtil.showTextTable(ftHeaders, filesTable, ftAlign));
        if (hotStat != null) {
            hotStat.numberOfSegmentsTotal = global.total.segments;
            hotStat.numberofTranslatedSegments = global.unique.segments - global.remainingUnique.segments;
            hotStat.numberOfUniqueSegments = global.unique.segments;
            hotStat.uniqueCountsByFile.clear();
            for (CalcStandardStatistics.FileData fd : counts) {
                hotStat.uniqueCountsByFile.put(fd.filename, fd.unique.segments);
            }
        }
        return result.toString();
    }
}

