/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.statistics;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.omegat.core.statistics.IStatisticsPanel;
import org.omegat.core.statistics.StatCount;
import org.omegat.core.threads.LongProcessThread;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;

public abstract class CalcStandardStatistics
extends LongProcessThread {
    protected static final String[] htHeaders = new String[]{"", OStrings.getString("CT_STATS_Segments"), OStrings.getString("CT_STATS_Words"), OStrings.getString("CT_STATS_Characters_NOSP"), OStrings.getString("CT_STATS_Characters"), OStrings.getString("CT_STATS_Files")};
    protected static final String[] htRows = new String[]{OStrings.getString("CT_STATS_Total"), OStrings.getString("CT_STATS_Remaining"), OStrings.getString("CT_STATS_Unique"), OStrings.getString("CT_STATS_Unique_Remaining")};
    protected static final boolean[] htAlign = new boolean[]{false, true, true, true, true, true};
    protected static final String[] ftHeaders = new String[]{OStrings.getString("CT_STATS_FILE_Name"), OStrings.getString("CT_STATS_FILE_Total_Segments"), OStrings.getString("CT_STATS_FILE_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Segments"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Segments"), OStrings.getString("CT_STATS_FILE_Total_Words"), OStrings.getString("CT_STATS_FILE_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Unique_Words"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Words"), OStrings.getString("CT_STATS_FILE_Total_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters_NOSP"), OStrings.getString("CT_STATS_FILE_Total_Characters"), OStrings.getString("CT_STATS_FILE_Remaining_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Characters"), OStrings.getString("CT_STATS_FILE_Unique_Remaining_Characters")};
    protected static final boolean[] ftAlign = new boolean[]{false, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    protected final IStatisticsPanel.Standard callback;

    public CalcStandardStatistics(IStatisticsPanel.Standard callback) {
        this.callback = callback;
    }

    @Override
    public abstract void run();

    protected static String[][] calcHeaderTable(StatCount[] result) {
        String[][] table = new String[result.length][6];
        for (int i = 0; i < result.length; ++i) {
            table[i][0] = htRows[i];
            table[i][1] = Integer.toString(result[i].segments);
            table[i][2] = Integer.toString(result[i].words);
            table[i][3] = Integer.toString(result[i].charsWithoutSpaces);
            table[i][4] = Integer.toString(result[i].charsWithSpaces);
            table[i][5] = Integer.toString(result[i].files);
        }
        return table;
    }

    protected static String[][] calcFilesTable(String root, List<FileData> counts) {
        String[][] table = new String[counts.size()][17];
        int r = 0;
        for (FileData numbers : counts) {
            table[r][0] = StaticUtils.makeFilenameRelative(numbers.filename, root);
            table[r][1] = Integer.toString(numbers.total.segments);
            table[r][2] = Integer.toString(numbers.remaining.segments);
            table[r][3] = Integer.toString(numbers.unique.segments);
            table[r][4] = Integer.toString(numbers.remainingUnique.segments);
            table[r][5] = Integer.toString(numbers.total.words);
            table[r][6] = Integer.toString(numbers.remaining.words);
            table[r][7] = Integer.toString(numbers.unique.words);
            table[r][8] = Integer.toString(numbers.remainingUnique.words);
            table[r][9] = Integer.toString(numbers.total.charsWithoutSpaces);
            table[r][10] = Integer.toString(numbers.remaining.charsWithoutSpaces);
            table[r][11] = Integer.toString(numbers.unique.charsWithoutSpaces);
            table[r][12] = Integer.toString(numbers.remainingUnique.charsWithoutSpaces);
            table[r][13] = Integer.toString(numbers.total.charsWithSpaces);
            table[r][14] = Integer.toString(numbers.remaining.charsWithSpaces);
            table[r][15] = Integer.toString(numbers.unique.charsWithSpaces);
            table[r][16] = Integer.toString(numbers.remainingUnique.charsWithSpaces);
            ++r;
        }
        return table;
    }

    public static class FileData {
        public String filename;
        public StatCount total;
        public StatCount unique;
        public StatCount remaining;
        public StatCount remainingUnique;
        private Set<String> translatedSegments = new HashSet<String>();
        private Set<String> uniqueSegments = new HashSet<String>();

        public FileData(String path) {
            this.filename = path;
            this.total = new StatCount();
            this.unique = new StatCount();
            this.remaining = new StatCount();
            this.remainingUnique = new StatCount();
        }

        public void register(String src, boolean isTranslated) {
            StatCount count = new StatCount(src);
            this.total.add(count);
            if (isTranslated) {
                this.translatedSegments.add(src);
            } else {
                this.remaining.add(count);
            }
            if (!this.uniqueSegments.contains(src)) {
                this.unique.add(count);
                if (!isTranslated) {
                    this.remainingUnique.add(count);
                }
                this.uniqueSegments.add(src);
            }
        }

        public void addFile(FileData file) {
            if (file.total.segments > 0) {
                this.total.addFiles(1);
            }
            if (file.unique.segments > 0) {
                this.unique.addFiles(1);
            }
            if (file.remaining.segments > 0) {
                this.remaining.addFiles(1);
            }
            if (file.remainingUnique.segments > 0) {
                this.remainingUnique.addFiles(1);
            }
        }
    }
}

