/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.team;

import java.io.File;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import org.omegat.core.Core;
import org.omegat.core.team.IRemoteRepository;
import org.omegat.util.Log;
import org.omegat.util.StringUtil;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNCommitInfo;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthStoreHandler;
import org.tmatesoft.svn.core.internal.wc.ISVNAuthenticationStorageOptions;
import org.tmatesoft.svn.core.internal.wc.ISVNGnomeKeyringPasswordProvider;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNStatus;
import org.tmatesoft.svn.core.wc.SVNStatusType;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class SVNRemoteRepository
implements IRemoteRepository {
    private static final Logger LOGGER = Logger.getLogger(SVNRemoteRepository.class.getName());
    public static boolean SHOW_UNKNOWN_ERRORS = true;
    File baseDirectory;
    SVNClientManager ourClientManager;
    boolean readOnly;
    static ISVNAuthenticationStorageOptions FORCE_SAVE_PLAIN_PASSWORD = new ISVNAuthenticationStorageOptions(){

        public boolean isNonInteractive() throws SVNException {
            return false;
        }

        public ISVNAuthStoreHandler getAuthStoreHandler() throws SVNException {
            return FORCE_SAVE_PLAIN_PASSWORD_HANDLER;
        }

        public boolean isSSLPassphrasePromptSupported() {
            return false;
        }

        public ISVNGnomeKeyringPasswordProvider getGnomeKeyringPasswordProvider() {
            return null;
        }
    };
    static ISVNAuthStoreHandler FORCE_SAVE_PLAIN_PASSWORD_HANDLER = new ISVNAuthStoreHandler(){

        public boolean canStorePlainTextPassphrases(String realm, SVNAuthentication auth) throws SVNException {
            return false;
        }

        public boolean canStorePlainTextPasswords(String realm, SVNAuthentication auth) throws SVNException {
            return true;
        }
    };

    public static boolean isSVNDirectory(File localDirectory) {
        File svnDir = new File(localDirectory, ".svn");
        return svnDir.exists() && svnDir.isDirectory();
    }

    @Override
    public boolean isFilesLockingAllowed() {
        return true;
    }

    public SVNRemoteRepository(File localDirectory) throws Exception {
        this.baseDirectory = localDirectory;
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager();
        this.ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
    }

    @Override
    public boolean isChanged(File file) throws Exception {
        SVNStatus status = null;
        try {
            status = this.ourClientManager.getStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().getCode() == 155007) {
                return false;
            }
            throw e;
        }
        if (status == null) {
            return false;
        }
        SVNStatusType statusType = status.getContentsStatus();
        return statusType != SVNStatusType.STATUS_NORMAL && statusType != SVNStatusType.STATUS_UNVERSIONED && statusType != SVNStatusType.STATUS_NONE;
    }

    @Override
    public boolean isUnderVersionControl(File file) throws Exception {
        SVNStatus status = null;
        try {
            status = this.ourClientManager.getStatusClient().doStatus(file, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode().getCode() == 155007) {
                return false;
            }
            throw e;
        }
        if (status == null) {
            return false;
        }
        SVNStatusType statusType = status.getContentsStatus();
        return statusType != SVNStatusType.STATUS_UNVERSIONED && statusType != SVNStatusType.STATUS_NONE;
    }

    @Override
    public void setCredentials(IRemoteRepository.Credentials credentials) {
        if (credentials == null) {
            return;
        }
        this.ourClientManager.dispose();
        DefaultSVNAuthenticationManager authManager = new DefaultSVNAuthenticationManager(null, true, credentials.username, new String(credentials.password));
        if (credentials.saveAsPlainText) {
            authManager.setAuthenticationStorageOptions(FORCE_SAVE_PLAIN_PASSWORD);
        }
        DefaultSVNOptions options = SVNWCUtil.createDefaultOptions((boolean)true);
        this.ourClientManager = SVNClientManager.newInstance((ISVNOptions)options, (ISVNAuthenticationManager)authManager);
        this.setReadOnly(credentials.readOnly);
    }

    @Override
    public void setReadOnly(boolean value) {
        this.readOnly = value;
    }

    @Override
    public void updateFullProject() throws SocketException, Exception {
        Log.logInfoRB("SVN_START", "update");
        try {
            long rev = this.ourClientManager.getUpdateClient().doUpdate(this.baseDirectory, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            Log.logDebug(LOGGER, "SVN updated to revision {0}", rev);
            Log.logInfoRB("SVN_FINISH", "update");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("SVN_ERROR", "update", ex.getMessage());
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (SVNException ex) {
            Log.logErrorRB("SVN_ERROR", "update", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "update", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void checkoutFullProject(String repositoryURL) throws Exception {
        Log.logInfoRB("SVN_START", "checkout");
        SVNURL url = SVNURL.parseURIDecoded((String)repositoryURL);
        try {
            long rev = this.ourClientManager.getUpdateClient().doCheckout(url, this.baseDirectory, SVNRevision.HEAD, SVNRevision.HEAD, SVNDepth.INFINITY, false);
            Log.logDebug(LOGGER, "SVN checked out to revision {0}", rev);
            Log.logInfoRB("SVN_FINISH", "checkout");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("TEAM_WRONG_AUTHENTICATION", new Object[0]);
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "checkout", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public String getBaseRevisionId(File file) throws Exception {
        SVNInfo info = this.ourClientManager.getWCClient().doInfo(file, SVNRevision.BASE);
        Log.logDebug(LOGGER, "SVN committed revision for file {0} is {1}", file, info.getCommittedRevision().getNumber());
        return Long.toString(info.getCommittedRevision().getNumber());
    }

    @Override
    public void restoreBase(File[] files) throws Exception {
        this.ourClientManager.getWCClient().doRevert(files, SVNDepth.EMPTY, null);
        Log.logDebug(LOGGER, "SVN restore base for {0}", this.toList(files));
    }

    @Override
    public void download(File[] files) throws SocketException, Exception {
        Log.logInfoRB("SVN_START", "download");
        try {
            long[] revs = this.ourClientManager.getUpdateClient().doUpdate(files, SVNRevision.HEAD, SVNDepth.INFINITY, false, false);
            Log.logDebug(LOGGER, "SVN updated files {0} to revisions {1}", this.toList(files), this.toList(revs));
            Log.logInfoRB("SVN_FINISH", "download");
        }
        catch (SVNException ex) {
            Log.logErrorRB("SVN_ERROR", "download", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "download", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void reset() throws Exception {
        Log.logInfoRB("SVN_START", "reset");
        try {
            Log.logDebug(LOGGER, "SVN revert all files in {0}", this.baseDirectory);
            this.ourClientManager.getWCClient().doRevert(new File[]{this.baseDirectory}, SVNDepth.INFINITY, (Collection)null);
            Log.logInfoRB("SVN_FINISH", "reset");
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "reset", ex.getMessage());
            throw ex;
        }
    }

    @Override
    public void upload(File file, String commitMessage) throws SocketException, Exception {
        if (this.readOnly) {
            Log.logInfoRB("SVN_READONLY", new Object[0]);
            return;
        }
        Log.logInfoRB("SVN_START", "upload");
        try {
            SVNCommitInfo info = this.ourClientManager.getCommitClient().doCommit(new File[]{file}, false, commitMessage, null, null, false, false, SVNDepth.INFINITY);
            Log.logDebug(LOGGER, "SVN committed file {0} into new revision {1}", file, info.getNewRevision());
            Log.logInfoRB("SVN_FINISH", "upload");
        }
        catch (SVNAuthenticationException ex) {
            Log.logWarningRB("SVN_ERROR", "update", ex.getMessage());
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (SVNException ex) {
            if (Arrays.asList(SVNErrorCode.FS_TXN_OUT_OF_DATE, SVNErrorCode.WC_NOT_UP_TO_DATE, SVNErrorCode.FS_CONFLICT).contains(ex.getErrorMessage().getErrorCode())) {
                Log.logWarningRB("SVN_CONFLICT", new Object[0]);
                return;
            }
            Log.logErrorRB("SVN_ERROR", "upload", ex.getMessage());
            this.checkNetworkException((Exception)((Object)ex));
            if (SHOW_UNKNOWN_ERRORS) {
                Core.getMainWindow().showErrorDialogRB("SVN_UPLOAD_ERROR_TITLE", "SVN_UPLOAD_ERROR", ex.getMessage());
            }
            throw ex;
        }
        catch (Exception ex) {
            Log.logErrorRB("SVN_ERROR", "upload", ex.getMessage());
            throw ex;
        }
    }

    List<File> toList(File[] files) {
        return Arrays.asList(files);
    }

    List<Long> toList(long[] arr) {
        ArrayList<Long> result = new ArrayList<Long>(arr.length);
        for (long v : arr) {
            result.add(v);
        }
        return result;
    }

    void checkNetworkException(Exception ex) throws IRemoteRepository.NetworkException {
        SVNException se;
        if (ex.getCause() instanceof SocketException) {
            throw new IRemoteRepository.NetworkException(ex.getCause());
        }
        if (ex instanceof SVNException && (se = (SVNException)((Object)ex)).getErrorMessage().getErrorCode().getCategory() == 175000) {
            throw new IRemoteRepository.NetworkException(se);
        }
    }

    public static boolean isSVNRepository(String url, IRemoteRepository.Credentials credentials) throws IRemoteRepository.AuthenticationException {
        if (url.startsWith("git://")) {
            return false;
        }
        try {
            ISVNAuthenticationManager authManager;
            SVNURL svnurl = SVNURL.parseURIDecoded((String)url);
            SVNClientManager manager = SVNClientManager.newInstance();
            if (credentials != null) {
                DefaultSVNAuthenticationManager defaultManager = new DefaultSVNAuthenticationManager(null, true, credentials.username, new String(credentials.password));
                if (credentials.saveAsPlainText) {
                    defaultManager.setAuthenticationStorageOptions(FORCE_SAVE_PLAIN_PASSWORD);
                }
                authManager = defaultManager;
            } else {
                authManager = SVNWCUtil.createDefaultAuthenticationManager();
            }
            manager.setAuthenticationManager(authManager);
            manager.getWCClient().doInfo(svnurl, SVNRevision.HEAD, SVNRevision.HEAD);
        }
        catch (SVNAuthenticationException ex) {
            throw new IRemoteRepository.AuthenticationException((Exception)((Object)ex));
        }
        catch (SVNException ex) {
            return false;
        }
        return true;
    }

    public static String guessRepoName(String url) {
        url = StringUtil.stripFromEnd(url, "/", "/trunk", "/branches", "/tags", "/svn");
        return url.substring(url.lastIndexOf(47) + 1);
    }
}

