/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.threads;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omegat.core.Core;
import org.omegat.core.KnownException;
import org.omegat.core.data.IProject;
import org.omegat.core.threads.IAutoSave;
import org.omegat.util.Preferences;

public class SaveThread
extends Thread
implements IAutoSave {
    private static final Logger LOGGER = Logger.getLogger(SaveThread.class.getName());
    private int waitDuration;
    private boolean needToSaveNow;
    private boolean enabled;

    public SaveThread() {
        this.setName("Save thread");
        this.setWaitDuration(Preferences.getPreferenceDefault("auto_save_interval", 180));
        Preferences.addPropertyChangeListener(new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("auto_save_interval")) {
                    SaveThread.this.setWaitDuration((Integer)evt.getNewValue());
                    SaveThread saveThread = SaveThread.this;
                    synchronized (saveThread) {
                        SaveThread.this.notify();
                    }
                }
            }
        });
    }

    private void setWaitDuration(int seconds) {
        this.waitDuration = seconds * 1000;
    }

    @Override
    public synchronized void disable() {
        LOGGER.fine("Disable autosave");
        this.enabled = false;
    }

    @Override
    public synchronized void enable() {
        LOGGER.fine("Enable autosave");
        this.enabled = true;
        this.needToSaveNow = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            while (true) {
                SaveThread saveThread = this;
                synchronized (saveThread) {
                    this.needToSaveNow = true;
                    this.wait(this.waitDuration);
                }
                if (!this.needToSaveNow || !this.enabled) continue;
                IProject dataEngine = Core.getProject();
                LOGGER.fine("Start project save from SaveThread");
                try {
                    dataEngine.saveProject();
                    Core.getMainWindow().showStatusMessageRB("ST_PROJECT_AUTOSAVED", DateFormat.getTimeInstance(3).format(new Date()));
                }
                catch (KnownException ex) {
                    Core.getMainWindow().showStatusMessageRB(ex.getMessage(), ex.getParams());
                }
                LOGGER.fine("Finish project save from SaveThread");
            }
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.WARNING, "Save thread interrupted", ex);
            return;
        }
    }
}

