/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.filechooser.FileSystemView;
import org.omegat.core.Core;
import org.omegat.core.search.TextExpression;
import org.omegat.filehooks.XliffFileHook;
import org.omegat.util.Log;
import org.omegat.util.Preferences;

public class SdlxliffFileHook
extends XliffFileHook {
    @Override
    public void postCompile(File destDir, String midName) {
        block8: {
            this.lastCompileException = null;
            try {
                if (Preferences.getPreferenceDefault("trados_command_line", "").length() > 0) {
                    try {
                        Log.log("Using command-line compiler");
                        this.callTradosCommandLine(destDir.getCanonicalPath() + File.separator + midName);
                    }
                    catch (Exception e) {
                        Log.log("Error in calling Studio: " + e);
                        Log.log(e);
                        if (Preferences.isPreferenceDefault("trados_use_cross_compile", false)) {
                            super.postCompile(destDir, midName);
                            break block8;
                        }
                        this.lastCompileException = e;
                    }
                    break block8;
                }
                if (Preferences.isPreferenceDefault("trados_use_cross_compile", false)) {
                    super.postCompile(destDir, midName);
                } else {
                    this.lastCompileException = new Exception("Trados command line path not configured and cross-compilation inactive: cannot generate target files");
                }
            }
            catch (Exception e) {
                this.lastCompileException = e;
                e.printStackTrace();
                Log.log(e);
            }
        }
    }

    private void callTradosCommandLine(String omegatTargetXliff) throws Exception {
        String line;
        Object tradosTargetXliff = SdlxliffFileHook.readOriginalFileName(omegatTargetXliff).getCanonicalPath();
        boolean dummy = false;
        File f = new File((String)tradosTargetXliff);
        if (!f.exists() && !(f = new File(((String)tradosTargetXliff).toString() + ".sdlxliff")).exists()) {
            Log.log("SDLXLIFF is not in " + f + ", searching in Trados configured path");
            f = SdlxliffFileHook.findTradosProject(omegatTargetXliff);
            if (f == null) {
                f = new File(this.createLocalTradosProject(new File(omegatTargetXliff)));
                dummy = true;
            }
        }
        StringBuffer parents = new StringBuffer();
        block10: while (true) {
            f = f.getParentFile();
            parents.insert(0, f.getName() + File.separator);
            if (f == null) {
                this.lastCompileException = new Exception(new File((String)tradosTargetXliff).getName() + " is not in an Trados project.\n A correct Trados project in your computer is needed to convert sdlxliff to docx");
                return;
            }
            File[] fileArray = f.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block10;
                File child = fileArray[n2];
                if (child.getName().endsWith(".sdlproj")) break block10;
                ++n2;
            }
            break;
        }
        parents.delete(0, parents.indexOf(File.separator) + File.separator.length());
        parents.delete(0, parents.indexOf(File.separator));
        tradosTargetXliff = f.getCanonicalPath() + File.separator + Core.getProject().getProjectProperties().getTargetLanguage() + parents.toString() + ((String)tradosTargetXliff).substring(((String)tradosTargetXliff).lastIndexOf(File.separator) + File.separator.length());
        Files.copy(Paths.get(omegatTargetXliff, new String[0]), Paths.get((String)tradosTargetXliff + ".sdlxliff", new String[0]), StandardCopyOption.REPLACE_EXISTING);
        Core.getMainWindow().showProgressMessage("Calling Trados Studio to build binary file");
        String[] execParams = Preferences.getPreference("trados_command_line").split(" ");
        if (!execParams[0].contains("\\") && !execParams[0].contains("/")) {
            execParams[0] = Preferences.getPreference("trados_path") + "\\" + execParams[0];
        }
        for (int i = 1; i < execParams.length; ++i) {
            execParams[i] = execParams[i].replace("%s", f.getCanonicalPath() + File.separator + f.getName() + ".sdlproj").replace("%projPath", f.getCanonicalPath() + File.separator + f.getName() + ".sdlproj");
            if (!execParams[i].contains("%file")) continue;
            File otFile = new File(omegatTargetXliff);
            execParams[i] = execParams[i].replace("%fileName", otFile.getName()).replace("%fileOmegatPath", otFile.getCanonicalPath().substring(Core.getProject().getProjectProperties().getTargetRoot().length()));
        }
        Log.log("Running '" + execParams[0] + "' '" + execParams[1] + "'");
        if (!new File(execParams[0]).exists()) {
            this.lastCompileException = new Exception("Trados converter not found.\n Please check your configuration and try again.");
            Log.log("Trados caller program not found : " + execParams[0]);
            Log.log("Exe not found: '" + execParams[0] + "'");
            return;
        }
        Core.getMainWindow().showProgressMessage("Running Trados");
        Log.log("Starting process");
        Process proc = Runtime.getRuntime().exec(execParams);
        String tradosError = null;
        Log.log("Reading getInputStream");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
            while ((line = reader.readLine()) != null) {
                Log.log("[TRADOS OUT]: " + line);
                if (!line.startsWith("[Error]")) continue;
                tradosError = line;
            }
        }
        Log.log("Reading getErrorStream");
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            while ((line = reader.readLine()) != null) {
                Log.log("[TRADOS OUT]: " + line);
                if (!line.startsWith("[Error]")) continue;
                tradosError = line;
            }
        }
        finally {
            reader.close();
        }
        proc.waitFor();
        Log.log("Searching for " + (String)tradosTargetXliff);
        if (new File((String)tradosTargetXliff).lastModified() > new File(omegatTargetXliff).lastModified()) {
            File nativeDest = new File(Core.getProject().getProjectProperties().getProjectRoot(), "target-native");
            nativeDest.mkdirs();
            nativeDest = new File(nativeDest, ((String)tradosTargetXliff).substring(((String)tradosTargetXliff).lastIndexOf(File.separator) + File.separator.length()));
            if (Preferences.isPreferenceDefault("trados_rename_method", false)) {
                Object name = nativeDest.getName();
                name = dummy ? ((String)name).substring(0, ((String)name).lastIndexOf(46)) + "-dummyProject" + ((String)name).substring(((String)name).lastIndexOf(46)) : ((String)name).substring(0, ((String)name).lastIndexOf(46)) + "-existingProject" + ((String)name).substring(((String)name).lastIndexOf(46));
                nativeDest = new File(nativeDest.getParentFile(), (String)name);
            }
            Files.copy(Paths.get((String)tradosTargetXliff, new String[0]), nativeDest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.nativeTarget = nativeDest.getCanonicalPath();
        } else {
            this.lastCompileException = tradosError != null ? new Exception("Could not open file generated by Trados.\nTrados says:\n" + tradosError) : new Exception("Could not open file generated by Trados.\nPlease see log for details.");
        }
    }

    public static File findTradosProject(String otSdlxliff) throws IOException {
        String tradosPath = Preferences.getPreference("trados_proj_path");
        if ((tradosPath == null || tradosPath.length() == 0) && (tradosPath = Preferences.getPreference("trados_path")) != null && tradosPath.length() > 0) {
            if (tradosPath.contains("\\")) {
                tradosPath = tradosPath.substring(tradosPath.lastIndexOf("\\") + 1);
            }
            if (tradosPath.endsWith("Studio2")) {
                tradosPath = "Studio 2011";
            } else if (tradosPath.endsWith("Studio3")) {
                tradosPath = "Studio 2014";
            } else if (tradosPath.endsWith("Studio4")) {
                tradosPath = "Studio 2015";
            } else if (tradosPath.endsWith("Studio5")) {
                tradosPath = "Studio 2017";
            } else if (tradosPath.endsWith("Studio6")) {
                tradosPath = "Studio 2019";
            } else if (tradosPath.endsWith("Studio7") || tradosPath.endsWith("Studio16")) {
                tradosPath = "Studio 2021";
            }
            tradosPath = new File(FileSystemView.getFileSystemView().getDefaultDirectory(), tradosPath + "\\Projects").toString();
        }
        if (tradosPath != null && tradosPath.length() > 0) {
            Log.log("Exploring " + tradosPath);
            XliffFileHook.FileInfo info = SdlxliffFileHook.readOriginalFileInfo(new File(otSdlxliff));
            if (info.traLang == null) {
                info.traLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguage();
            }
            Object sxFileName = info.original.getCanonicalPath();
            sxFileName = ((String)sxFileName).substring(((String)sxFileName).lastIndexOf("\\") + 1) + ".sdlxliff";
            Object tradosProjModel = Preferences.getPreference("trados_proj_model");
            Predicate<File> validProject = null;
            if (tradosProjModel == null || ((String)tradosProjModel).length() == 0) {
                validProject = File::isDirectory;
            } else {
                Matcher MATCH_FILE;
                String fileModel = Preferences.getPreference("trados_file_model");
                if (fileModel != null && fileModel.length() > 0 && (MATCH_FILE = Pattern.compile(fileModel = fileModel.replace("?", "(.)").replace("*", "(.+?)")).matcher((CharSequence)sxFileName)).find()) {
                    Matcher replaceMatcher = TextExpression.RegexReplaceExpression.REGEX_REPLACE_VARIABLE.matcher((CharSequence)tradosProjModel);
                    while (replaceMatcher.find()) {
                        int varId = Integer.parseInt(replaceMatcher.group(2));
                        tradosProjModel = ((String)tradosProjModel).substring(0, replaceMatcher.start()) + replaceMatcher.group(1) + MATCH_FILE.group(varId).replace("\\", "\\\\").replace("$", "\\$") + ((String)tradosProjModel).substring(replaceMatcher.end());
                        replaceMatcher.reset((CharSequence)tradosProjModel);
                    }
                }
                Pattern PTN_PROJ = Pattern.compile(((String)tradosProjModel).replace("?", "(.)").replace("*", "(.+?)"));
                Log.log("Trados project model for " + fileModel + " = " + (String)tradosProjModel);
                validProject = child -> {
                    if (!child.isDirectory()) {
                        return false;
                    }
                    return PTN_PROJ.matcher(child.getName()).find();
                };
            }
            for (String tp : tradosPath.split(";")) {
                for (File child2 : new File(tp).listFiles()) {
                    if (!validProject.test(child2)) continue;
                    Log.log("Exploring " + child2 + " for " + info.traLang + "\\" + (String)sxFileName);
                    File f = new File(child2, info.traLang + "\\" + (String)sxFileName);
                    if (!f.exists()) continue;
                    Log.log("In-project file found at " + f);
                    return f;
                }
            }
        }
        return null;
    }

    private String createLocalTradosProject(File omegatTargetXliff) throws IOException {
        XliffFileHook.FileInfo info = SdlxliffFileHook.readOriginalFileInfo(omegatTargetXliff);
        if (info.srcLang == null) {
            info.srcLang = Core.getProject().getProjectProperties().getSourceLanguage().getLanguage();
        }
        if (info.traLang == null) {
            info.traLang = Core.getProject().getProjectProperties().getTargetLanguage().getLanguage();
        }
        try {
            return this.createCommandTradosProject(omegatTargetXliff, info);
        }
        catch (Exception e) {
            return this.createDummyTradosProject(omegatTargetXliff, info);
        }
    }

    private String createCommandTradosProject(File omegatTargetXliff, XliffFileHook.FileInfo info) throws Exception {
        String line;
        String[] execParams = Preferences.getPreference("trados_command_line").split(" ");
        if (!execParams[0].contains("\\") && !execParams[0].contains("/")) {
            execParams[0] = Preferences.getPreference("trados_path") + "\\" + execParams[0];
        }
        if (!new File(execParams[0]).exists()) {
            throw new FileNotFoundException(execParams[0]);
        }
        execParams = new String[]{execParams[0], "--create-full", Core.getProject().getProjectProperties().getProjectRoot() + File.separator + "Studio", info.srcLang, info.traLang, omegatTargetXliff.toString()};
        Core.getMainWindow().showProgressMessage("Running Trados");
        Log.log("Starting process");
        Process proc = Runtime.getRuntime().exec(execParams);
        String tradosError = null;
        Log.log("Reading getInputStream");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
            while ((line = reader.readLine()) != null) {
                Log.log("[TRADOS OUT]: " + line);
                if (!line.startsWith("[Error]")) continue;
                tradosError = line;
            }
        }
        Log.log("Reading getErrorStream");
        reader = new BufferedReader(new InputStreamReader(proc.getErrorStream()));
        try {
            while ((line = reader.readLine()) != null) {
                Log.log("[TRADOS OUT]: " + line);
                if (!line.startsWith("[Error]")) continue;
                tradosError = line;
            }
        }
        finally {
            reader.close();
        }
        proc.waitFor();
        File res = new File(Core.getProject().getProjectProperties().getProjectRoot() + File.separator + "Studio");
        if (!res.exists()) {
            throw new Exception("Could not create project");
        }
        if (!(res = new File(res, info.traLang + File.separator + omegatTargetXliff)).exists()) {
            throw new Exception("Could not create project");
        }
        return res.toString();
    }

    private String createDummyTradosProject(File omegatTargetXliff, XliffFileHook.FileInfo info) throws IOException {
        String root = Core.getProject().getProjectProperties().getProjectRoot();
        try {
            Files.createDirectory(Paths.get(root + "\\Studio", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            // empty catch block
        }
        String fileStr = omegatTargetXliff.getName();
        fileStr = fileStr.substring(0, fileStr.length() - 9);
        try (PrintWriter out2 = new PrintWriter(new File(root + "\\Studio\\Studio.sdlproj"), "UTF-8");){
            out2.println("<?xml version=\"1.0\"?>");
            out2.println("<Project xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" Version=\"4.0.0.0\">");
            out2.println("  <LanguageDirections>");
            out2.println("    <LanguageDirection TargetLanguageCode=\"" + info.traLang + "\" SourceLanguageCode=\"" + info.srcLang + "\" />");
            out2.println("  </LanguageDirections>");
            out2.println("  <GeneralProjectInfo />");
            out2.println("  <SourceLanguageCode>" + info.srcLang + "</SourceLanguageCode>");
            out2.println("  <ProjectFiles>");
            out2.println("    <ProjectFile Path=\"\" Role=\"Translatable\" Name=\"" + fileStr + "\">");
            out2.println("      <LanguageFiles>");
            out2.println("         <LanguageFile LanguageCode=\"" + info.traLang + "\">");
            out2.println("             <FileVersions>");
            out2.println("                 <FileVersion PhysicalPath=\"" + info.traLang + "\\" + omegatTargetXliff.getName() + "\" />");
            out2.println("             </FileVersions>");
            out2.println("         </LanguageFile>");
            out2.println("      </LanguageFiles>");
            out2.println("    </ProjectFile>");
            out2.println("  </ProjectFiles>");
            out2.println("</Project>");
        }
        try {
            Files.createDirectory(Paths.get(root + "\\Studio\\" + info.traLang, new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException out2) {
            // empty catch block
        }
        File destFile = new File(root + "\\Studio\\" + info.traLang + "\\" + fileStr + ".sdlxliff");
        if (info.original.exists()) {
            Log.log("convertDummyProject: original file exists as declared in <original>");
            Files.copy(omegatTargetXliff.toPath(), destFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        } else if (new File(root + "\\original\\" + fileStr).exists()) {
            Log.log("convertDummyProject: original file exists in project/original directory");
            SdlxliffFileHook.CopyXliffChangePath(omegatTargetXliff, destFile, root + "\\original\\" + fileStr, null);
        } else if (new File(root + "\\source-native\\" + fileStr).exists()) {
            Log.log("convertDummyProject: original file exists in project/original directory");
            SdlxliffFileHook.CopyXliffChangePath(omegatTargetXliff, destFile, root + "\\source-native\\" + fileStr, null);
        } else {
            Log.log("convertDummyProject: extract original file from <internal>");
            Core.getMainWindow().showProgressMessage("Extracting Base64 from " + omegatTargetXliff);
            StringBuffer buf = new StringBuffer();
            String sourceNativeFileName = root + "\\Studio\\" + info.srcLang + "\\" + fileStr;
            SdlxliffFileHook.CopyXliffChangePath(omegatTargetXliff, destFile, sourceNativeFileName, buf);
            try {
                Files.createDirectory(Paths.get(root + "\\Studio\\" + info.srcLang, new String[0]), new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            SdlxliffFileHook.base64ToFile(buf, sourceNativeFileName);
        }
        String destFileName = destFile.getCanonicalPath();
        destFileName = destFileName.substring(0, destFileName.lastIndexOf("."));
        return destFileName;
    }

    private static void CopyXliffChangePath(File sdlxliff, File dest, String originalPath, StringBuffer base64Buffer) throws IOException {
        Log.log("CopyXliffChangePath (" + sdlxliff.getCanonicalPath() + " -> " + dest + ") (original => " + originalPath + ")");
        try (FileInputStream is = new FileInputStream(sdlxliff);
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
             PrintWriter xliffOut = new PrintWriter(dest, "UTF-8");){
            String line = "";
            do {
                line = reader.readLine();
                xliffOut.println(ORI_FIND_PATTERN.matcher(line).replaceAll("original = \"" + originalPath.replace("\\", "\\\\") + "\""));
            } while (!line.contains("<internal-file"));
            if (base64Buffer != null) {
                line = line.substring(line.indexOf("<internal-file"));
                line = line.substring(line.indexOf(62) + 1);
                base64Buffer.append(line);
                do {
                    line = reader.readLine();
                    base64Buffer.append(line);
                    xliffOut.println(line);
                } while (!line.contains("</internal-file>"));
                base64Buffer.setLength(base64Buffer.indexOf("<"));
            }
            while ((line = reader.readLine()) != null) {
                xliffOut.println(line);
            }
        }
    }
}

