/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filehooks;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.StringConcatFactory;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.omegat.core.Core;
import org.omegat.core.data.EntryKey;
import org.omegat.core.data.PrepareTMXEntry;
import org.omegat.core.data.ProjectProperties;
import org.omegat.core.data.RealProject;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.segmentation.Segmenter;
import org.omegat.core.threads.LongProcessInterruptedException;
import org.omegat.filehooks.IFileHook;
import org.omegat.filters4.xml.xliff.AbstractXliffFilter;
import org.omegat.util.Log;
import org.omegat.util.Preferences;
import org.omegat.util.StaticUtils;

public class XliffFileHook
implements IFileHook {
    public static final String ORIGINAL_NATIVE_DIR = "original";
    public static final String SOURCE_NATIVE_DIR = "source-native";
    public static final String COMPILED_NATIVE_DIR = "target-native";
    public static final Pattern ORI_FIND_PATTERN = Pattern.compile("original\\s*=\\s*\\\"(.+?)\\\"");
    public static final Pattern SRC_LANG_PATTERN = Pattern.compile("source-language\\s*=\\s*\\\"(.+?)\\\"");
    public static final Pattern TRA_LANG_PATTERN = Pattern.compile("target-language\\s*=\\s*\\\"(.+?)\\\"");
    protected Exception lastCompileException = null;
    protected String nativeTarget = null;

    public static FileInfo readOriginalFileInfo(File sdlxliff) throws IOException {
        try (FileInputStream is = new FileInputStream(sdlxliff);){
            FileInfo fileInfo;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = "";
                while (!(line = reader.readLine()).contains("<file")) {
                }
                FileInfo res = new FileInfo();
                Matcher m = ORI_FIND_PATTERN.matcher(line);
                if (m.find()) {
                    res.original = new File(m.group(1));
                }
                if ((m = SRC_LANG_PATTERN.matcher(line)).find()) {
                    res.srcLang = m.group(1);
                }
                if ((m = TRA_LANG_PATTERN.matcher(line)).find()) {
                    res.traLang = m.group(1);
                }
                Log.log("readOriginalFileName In file " + sdlxliff + ": <file original='" + res.original + "'>");
                fileInfo = res;
            }
            return fileInfo;
        }
    }

    public static File readOriginalFileName(String sdlxliff) throws IOException {
        return XliffFileHook.readOriginalFileInfo((File)new File((String)sdlxliff)).original;
    }

    public static void extractBase64(File xliff, String subFileName, String outputFileName) throws IOException {
        StringBuffer buf = new StringBuffer();
        boolean inFile = false;
        try (FileInputStream is = new FileInputStream(xliff.getPath());
             BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));){
            String line = "";
            do {
                Matcher m;
                if (!(m = ORI_FIND_PATTERN.matcher(line = reader.readLine())).find()) continue;
                inFile = subFileName == null ? true : subFileName.equals(m.group(1));
            } while (!inFile || !line.contains("<internal-file"));
            line = line.substring(line.indexOf("<internal-file"));
            line = line.substring(line.indexOf(62) + 1);
            buf.append(line);
            do {
                line = reader.readLine();
                buf.append(line);
            } while (!line.contains("</internal-file>"));
            buf.setLength(buf.indexOf("<"));
        }
        XliffFileHook.base64ToFile(buf, outputFileName);
    }

    protected static void base64ToFile(StringBuffer buf, String outputFileName) throws IOException {
        try (FileOutputStream os = new FileOutputStream(outputFileName);){
            int len;
            byte[] base64Zip = Base64.getDecoder().decode(buf.toString());
            ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(base64Zip));
            ZipEntry ZE = zis.getNextEntry();
            byte[] buffer = new byte[1024];
            while ((len = zis.read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, len);
            }
        }
    }

    @Override
    public String getNativeSourceFile(String currentFile, SourceTextEntry entry) {
        return this.getNativeSourceFile(currentFile, entry, Core.getProject().getProjectProperties().getSourceRoot());
    }

    public String getNativeSourceFile(String currentFile, SourceTextEntry entry, String baseDir) {
        currentFile = ((String)currentFile).replace("/", File.separator);
        String paramFileName = currentFile;
        File handler = new File((String)(currentFile = ((String)currentFile).substring(0, ((String)currentFile).lastIndexOf(46))));
        if (handler.exists()) {
            try {
                return handler.getCanonicalPath();
            }
            catch (Exception e) {
                return currentFile;
            }
        }
        currentFile = ((String)currentFile).substring(baseDir.length());
        handler = new File(baseDir).getParentFile();
        handler = new File(handler, ORIGINAL_NATIVE_DIR);
        currentFile = handler.getCanonicalPath() + File.separator + (String)currentFile;
        handler = new File((String)currentFile);
        if (handler.exists()) {
            return currentFile;
        }
        handler = new File(handler.getParentFile().getParentFile(), SOURCE_NATIVE_DIR);
        currentFile = ((String)currentFile).substring(Core.getProject().getProjectProperties().getProjectRoot().length() + ORIGINAL_NATIVE_DIR.length() + 1);
        currentFile = handler.getCanonicalPath() + File.separator + (String)currentFile;
        if ((handler = new File((String)currentFile)).exists()) {
            return currentFile;
        }
        try {
            currentFile = entry.getKey().path;
            currentFile = ((String)currentFile).substring(0, ((String)currentFile).indexOf("##"));
            System.err.println("For entry " + entry.entryNum() + " key = " + (String)currentFile);
            handler = new File((String)currentFile);
            if (handler.exists()) {
                return currentFile;
            }
            handler = new File(Core.getProject().getProjectProperties().getProjectRoot());
            handler = new File(handler, SOURCE_NATIVE_DIR);
            Object key = currentFile;
            currentFile = ((String)currentFile).replace("\\", File.separator);
            currentFile = ((String)currentFile).substring(((String)currentFile).lastIndexOf(File.separator) + File.separator.length());
            currentFile = handler.getCanonicalPath() + File.separator + (String)currentFile;
            XliffFileHook.extractBase64(new File(paramFileName), (String)key, (String)currentFile);
            return currentFile;
        }
        catch (Exception e) {
            try {
                Log.log(e);
                handler = XliffFileHook.readOriginalFileInfo((File)new File((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001\u0001"}, (String)baseDir, (String)paramFileName.substring((int)baseDir.length()))))).original;
                if (handler.exists()) {
                    return handler.getCanonicalPath();
                }
                String ext = handler.getName();
                ext = ext.substring(ext.lastIndexOf(46));
                handler = new File(Core.getProject().getProjectProperties().getProjectRoot());
                handler = new File(handler, SOURCE_NATIVE_DIR);
                currentFile = paramFileName.substring(baseDir.length());
                if (((String)currentFile).contains(File.separator)) {
                    handler = new File(handler, (String)currentFile).getParentFile();
                }
                handler.mkdirs();
                currentFile = handler.getCanonicalPath() + File.separator + paramFileName.substring(paramFileName.lastIndexOf(File.separator) + 1);
                currentFile = ((String)currentFile).substring(0, ((String)currentFile).lastIndexOf(46));
                if (!((String)currentFile).substring(((String)currentFile).lastIndexOf(File.separator) + 1).contains(".")) {
                    currentFile = (String)currentFile + ext;
                }
                XliffFileHook.extractBase64(new File(paramFileName), null, (String)currentFile);
                return currentFile;
            }
            catch (Exception e2) {
                Log.log(e2);
                return currentFile;
            }
        }
    }

    @Override
    public Exception lastCompileException() {
        return this.lastCompileException;
    }

    @Override
    public String getNativeTargetFile(String currentFile) {
        return this.nativeTarget;
    }

    @Override
    public boolean supportsPseudoTags() {
        return AbstractXliffFilter.class.isAssignableFrom(IFileHook.getFilterClass(Core.getEditor().getCurrentFile(), Core.getProject()));
    }

    @Override
    public void postCompile(File destDir, String midName) {
        this.postCompile(destDir, midName, Core.getProject().getProjectProperties().getSourceRoot());
    }

    public void postCompile(File destDir, String midName, String sourceRoot) {
        this.lastCompileException = null;
        ProjectProperties oriProps = Core.getProject().getProjectProperties();
        try {
            String oriFile = this.getNativeSourceFile(sourceRoot + Core.getEditor().getCurrentFile(), Core.getEditor().getCurrentEntry());
            File fori = new File(oriFile);
            if (!fori.exists()) {
                this.lastCompileException = new FileNotFoundException("Original file (" + oriFile + ") not found");
                return;
            }
            Core.getMainWindow().showProgressMessage("Try to call cross-compilation");
            File root = new File(oriProps.getProjectRoot() + File.separator + "X-compile");
            root.mkdirs();
            ProjectProperties xProps = new ProjectProperties(root);
            xProps.setSourceRoot(fori.getParent() + File.separator);
            xProps.setGlossaryRoot(oriProps.getGlossaryRoot());
            xProps.setWriteableGlossary(oriProps.getWriteableGlossary());
            xProps.setTMRoot(oriProps.getTMRoot());
            xProps.setDictRoot(oriProps.getDictRoot());
            xProps.setSourceLanguage(oriProps.getSourceLanguage());
            xProps.setTargetLanguage(oriProps.getTargetLanguage());
            xProps.setSourceTokenizer(oriProps.getSourceTokenizer());
            xProps.setTargetTokenizer(oriProps.getTargetTokenizer());
            RealProject p = new RealProject(xProps);
            p.createProject();
            p.closeProject();
            Files.copy(Paths.get(oriProps.getProjectRoot() + "/omegat/project_save.tmx", new String[0]), new File(root, "/omegat/project_save.tmx").toPath(), StandardCopyOption.REPLACE_EXISTING);
            p = new RealProject(xProps);
            p.loadProject(true);
            int untranslatedBefore = 0;
            int undercuts = 0;
            boolean overcuts = false;
            Segmenter segmenter = Core.getSegmenter();
            LinkedList spaces = new LinkedList();
            LinkedList defaultEntries = new LinkedList();
            p.iterateByDefaultTranslations((source, trans) -> {
                List<String> segSrc = segmenter.segment(oriProps.getSourceLanguage(), source, spaces, null);
                if (segSrc.size() < 2) {
                    return;
                }
                List<String> segTra = segmenter.segment(oriProps.getTargetLanguage(), trans.translation, spaces, null);
                if (segSrc.size() == segTra.size()) {
                    for (int i = 0; i < segSrc.size(); ++i) {
                        PrepareTMXEntry pte = new PrepareTMXEntry();
                        pte.source = segSrc.get(i);
                        pte.translation = segTra.get(i);
                        defaultEntries.add(pte);
                    }
                }
            });
            HashMap altEntries = new HashMap();
            p.iterateByMultipleTranslations((source, trans) -> {
                List<String> segSrc = segmenter.segment(oriProps.getSourceLanguage(), trans.source, spaces, null);
                if (segSrc.size() < 2) {
                    return;
                }
                List<String> segTra = segmenter.segment(oriProps.getTargetLanguage(), trans.translation, spaces, null);
                if (segSrc.size() == segTra.size()) {
                    PrepareTMXEntry[] tab = new PrepareTMXEntry[segSrc.size()];
                    altEntries.put(source, tab);
                    for (int i = 0; i < segSrc.size(); ++i) {
                        PrepareTMXEntry pte = new PrepareTMXEntry();
                        pte.source = segSrc.get(i);
                        pte.translation = segTra.get(i);
                        tab[i] = pte;
                    }
                }
            });
            for (PrepareTMXEntry prepareTMXEntry : defaultEntries) {
                p.setTranslation(new SourceTextEntry(new EntryKey(null, prepareTMXEntry.source, null, null, null, null), -1, null, Collections.EMPTY_LIST, true), prepareTMXEntry, true, null);
            }
            for (Map.Entry entry : altEntries.entrySet()) {
                if (((EntryKey)entry.getKey()).prev != null) {
                    for (int i = 0; i < ((PrepareTMXEntry[])entry.getValue()).length; ++i) {
                        EntryKey eKey = i == 0 ? new EntryKey(null, ((PrepareTMXEntry[])entry.getValue())[i].source, null, ((EntryKey)entry.getKey()).prev, ((PrepareTMXEntry[])entry.getValue())[i + 1].source, null) : (i == ((PrepareTMXEntry[])entry.getValue()).length - 1 ? new EntryKey(null, ((PrepareTMXEntry[])entry.getValue())[i].source, null, ((PrepareTMXEntry[])entry.getValue())[i - 1].source, ((EntryKey)entry.getKey()).next, null) : new EntryKey(null, ((PrepareTMXEntry[])entry.getValue())[i].source, null, ((PrepareTMXEntry[])entry.getValue())[i - 1].source, ((PrepareTMXEntry[])entry.getValue())[i + 1].source, null));
                        p.setTranslation(new SourceTextEntry(eKey, -1, null, Collections.EMPTY_LIST, true), ((PrepareTMXEntry[])entry.getValue())[i], false, null);
                    }
                    continue;
                }
                for (PrepareTMXEntry pte : (PrepareTMXEntry[])entry.getValue()) {
                    p.setTranslation(new SourceTextEntry(new EntryKey(null, pte.source, null, null, null, null), -1, null, Collections.EMPTY_LIST, true), pte, true, null);
                }
            }
            for (SourceTextEntry sourceTextEntry : p.getAllEntries()) {
                if (p.getTranslationInfo(sourceTextEntry.getKey()).isTranslated()) continue;
                ++untranslatedBefore;
                undercuts += XliffFileHook.checkSuperSegmentation(p, sourceTextEntry);
                if (sourceTextEntry.getDuplicate() != SourceTextEntry.DUPLICATE.NONE) continue;
                RealProject p2 = p;
                p.iterateByMultipleTranslations((source, trans) -> {
                    if (!source.sourceText.equals(ste.getSrcText())) {
                        return;
                    }
                    p2.setTranslation(ste, new PrepareTMXEntry(trans), true, null);
                });
            }
            p.saveProject(false);
            p.compileProject(oriFile.substring(xProps.getSourceRoot().length()));
            p.closeProject();
            this.nativeTarget = xProps.getTargetRoot() + p.getTargetPathForSourceFile(fori.getName());
            File nativeDest = new File(oriProps.getProjectRoot(), COMPILED_NATIVE_DIR);
            nativeDest.mkdirs();
            nativeDest = new File(nativeDest, p.getTargetPathForSourceFile(fori.getName()));
            Files.copy(Paths.get(this.nativeTarget, new String[0]), nativeDest.toPath(), StandardCopyOption.REPLACE_EXISTING);
            if (Preferences.isPreferenceDefault("trados_rename_method", false)) {
                String string2 = nativeDest.getName();
                string2 = string2.substring(0, string2.lastIndexOf(46)) + "-xCompile" + string2.substring(string2.lastIndexOf(46));
                nativeDest.renameTo(new File(nativeDest.getParentFile(), string2));
            }
            this.nativeTarget = nativeDest.getCanonicalPath();
            if (!Preferences.isPreferenceDefault("trados_keep_intermediate", false)) {
                StaticUtils.deltree(root);
            }
            System.err.println("Before undercut : " + untranslatedBefore + "/" + p.getAllEntries().size());
            System.err.println("After undercut : " + (untranslatedBefore + undercuts) + "/" + p.getAllEntries().size());
            System.err.println("After overcut : " + (untranslatedBefore + undercuts + defaultEntries.size() + altEntries.size()) + "/" + p.getAllEntries().size());
        }
        catch (Exception e) {
            this.lastCompileException = e;
            e.printStackTrace();
        }
    }

    private static int checkSuperSegmentation(RealProject p, SourceTextEntry ste) {
        StringBuffer sourceText = new StringBuffer(ste.getSrcText());
        StringBuffer tra = new StringBuffer();
        LinkedList addedEntries = new LinkedList();
        while (sourceText.length() > 0) {
            try {
                p.iterateByDefaultTranslations((source, trans) -> {
                    if (sourceText.toString().equals(source)) {
                        PrepareTMXEntry pte = new PrepareTMXEntry();
                        pte.source = ste.getSrcText();
                        pte.translation = tra.toString();
                        p.setTranslation(ste, pte, true, null);
                        addedEntries.add(pte);
                        sourceText.setLength(0);
                        throw new LongProcessInterruptedException();
                    }
                    if (sourceText.toString().startsWith(source)) {
                        tra.append(trans.translation);
                        sourceText.delete(0, source.length());
                        while (sourceText.toString().startsWith(" ")) {
                            tra.append(" ");
                            sourceText.delete(0, 1);
                        }
                        throw new LongProcessInterruptedException();
                    }
                });
                if (tra.length() > 0) {
                    PrepareTMXEntry pte = new PrepareTMXEntry();
                    pte.source = ste.getSrcText();
                    pte.translation = tra.toString() + sourceText;
                    p.setTranslation(ste, pte, true, null);
                }
                return addedEntries.size();
            }
            catch (LongProcessInterruptedException pte) {
            }
            catch (Exception other) {
                return addedEntries.size();
            }
        }
        return addedEntries.size();
    }

    @Override
    public boolean supportsOpenInStudio(String file) {
        return file.endsWith(".sdlxliff");
    }

    protected static class FileInfo {
        File original;
        String srcLang;
        String traLang;

        protected FileInfo() {
        }

        public boolean exists() {
            return this.original.exists();
        }
    }
}

