/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.master;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Stream;
import org.omegat.core.Core;
import org.omegat.gui.editor.PopupMenuDisplayer;
import org.omegat.tokenizer.DefaultTokenizer;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.tokenizer.Tokenizer;
import org.omegat.util.Language;
import org.omegat.util.Log;
import org.omegat.util.OStrings;
import org.omegat.util.StaticUtils;
import org.omegat.util.StringUtil;

public final class PluginUtils {
    protected static ClassLoader pluginsClassLoader;
    protected static List<Class<?>> loadedPlugins;
    protected static List<Class<?>> filterClasses;
    protected static List<Class<?>> tokenizerClasses;
    protected static List<Class<?>> markerClasses;
    protected static List<Class<?>> machineTranslationClasses;
    protected static List<Class<?>> translationMemoryClasses;
    protected static List<Class<?>> glossaryClasses;
    protected static List<Class<?>> basePluginClasses;
    protected static List<Class<?>> dockableClasses;
    protected static List<Class<? extends PopupMenuDisplayer.IPopupMenuConstructor>> editorPopupClasses;
    protected static Map<String, Class<?>> tmFormatClasses;

    private PluginUtils() {
    }

    public static ClassLoader getPluginsClassLoader() {
        if (pluginsClassLoader != null) {
            return pluginsClassLoader;
        }
        pluginsClassLoader = PluginUtils.buildClassLoader(new File(StaticUtils.installDir(), "plugins"), pluginsClassLoader);
        pluginsClassLoader = PluginUtils.buildClassLoader(new File(StaticUtils.getConfigDir(), "plugins"), pluginsClassLoader);
        return pluginsClassLoader;
    }

    private static ClassLoader buildClassLoader(File location, ClassLoader parent) {
        if (parent == null) {
            parent = PluginUtils.class.getClassLoader();
        }
        if (!location.exists()) {
            return parent;
        }
        ArrayList urlList = new ArrayList();
        try (Stream<Path> fs = Files.walk(location.toPath(), new FileVisitOption[0]).filter(p -> p.toString().endsWith(".jar"));){
            fs.forEach(theFile -> {
                try {
                    URL toURL = theFile.toUri().toURL();
                    urlList.add(toURL);
                    Log.logInfoRB("PLUGIN_LOAD_JAR", toURL, new Date(theFile.toFile().lastModified()));
                }
                catch (Exception ex) {
                    Log.log(ex);
                }
            });
        }
        catch (Exception io) {
            Log.log(io);
        }
        if (urlList.size() > 0) {
            return new URLClassLoader(urlList.toArray(new URL[0]), parent);
        }
        return parent;
    }

    public static void loadPlugins(Map<String, String> params) {
        block25: {
            PluginUtils.getPluginsClassLoader();
            try {
                boolean foundMain = false;
                Enumeration<URL> mlist = pluginsClassLoader.getResources("META-INF/MANIFEST.MF");
                while (mlist.hasMoreElements()) {
                    try {
                        Manifest m;
                        URL mu = mlist.nextElement();
                        try (InputStream in = mu.openStream();){
                            m = new Manifest(in);
                        }
                        if ("org.omegat.Main".equals(m.getMainAttributes().getValue("Main-Class"))) {
                            foundMain = true;
                        }
                        PluginUtils.loadFromManifest(m, pluginsClassLoader);
                    }
                    catch (Exception iex1) {
                        Log.log(iex1);
                    }
                }
                if (foundMain) break block25;
                String manifests = params.get("dev-manifests");
                if (manifests == null) {
                    manifests = "manifest-template.mf";
                }
                for (String mf : manifests.split(File.pathSeparator)) {
                    try {
                        Manifest m;
                        try (FileInputStream in = new FileInputStream(mf);){
                            m = new Manifest(in);
                        }
                        PluginUtils.loadFromManifest(m, pluginsClassLoader);
                    }
                    catch (Exception iex2) {
                        Log.log(iex2);
                    }
                }
            }
            catch (Exception oex) {
                Log.log(oex);
            }
        }
        Collections.sort(tokenizerClasses, new Comparator<Class<?>>(){

            @Override
            public int compare(Class<?> c1, Class<?> c2) {
                return c1.getName().compareTo(c2.getName());
            }
        });
        for (Class<?> pl : basePluginClasses) {
            try {
                pl.newInstance();
            }
            catch (Exception ex) {
                Log.log(ex);
            }
        }
    }

    public static List<Class<?>> getFilterClasses() {
        return filterClasses;
    }

    public static List<Class<?>> getTokenizerClasses() {
        return tokenizerClasses;
    }

    public static Class<?> getTokenizerClassForLanguage(Language lang) {
        if (lang == null) {
            return DefaultTokenizer.class;
        }
        Class<?> exactResult = PluginUtils.searchForTokenizer(lang.getLanguage());
        if (PluginUtils.isDefault(exactResult)) {
            return exactResult;
        }
        Class<?> generalResult = PluginUtils.searchForTokenizer(lang.getLanguageCode());
        if (PluginUtils.isDefault(generalResult)) {
            return generalResult;
        }
        if (exactResult != null) {
            return exactResult;
        }
        if (generalResult != null) {
            return generalResult;
        }
        return DefaultTokenizer.class;
    }

    private static boolean isDefault(Class<?> c) {
        if (c == null) {
            return false;
        }
        Tokenizer ann = c.getAnnotation(Tokenizer.class);
        return ann == null ? false : ann.isDefault();
    }

    private static Class<?> searchForTokenizer(String lang) {
        if (lang.length() < 1) {
            return null;
        }
        lang = lang.toLowerCase();
        Class<?> fallback = null;
        for (Class<?> c : tokenizerClasses) {
            Tokenizer ann = c.getAnnotation(Tokenizer.class);
            if (ann == null) continue;
            String[] languages = ann.languages();
            try {
                if (languages.length == 1 && languages[0].equals("discoverAtRuntime")) {
                    languages = ((ITokenizer)c.newInstance()).getSupportedLanguages();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (String s : languages) {
                if (!lang.equals(s)) continue;
                if (ann.isDefault()) {
                    return c;
                }
                if (fallback != null) continue;
                fallback = c;
            }
        }
        return fallback;
    }

    public static List<Class<?>> getMarkerClasses() {
        return markerClasses;
    }

    public static List<Class<?>> getMachineTranslationClasses() {
        return machineTranslationClasses;
    }

    public static List<Class<?>> getTranslationMemoryClasses() {
        return translationMemoryClasses;
    }

    public static List<Class<?>> getGlossaryClasses() {
        return glossaryClasses;
    }

    public static List<Class<?>> getDockableClasses() {
        return dockableClasses;
    }

    public static List<Class<? extends PopupMenuDisplayer.IPopupMenuConstructor>> getEditorPopupClasses() {
        return editorPopupClasses;
    }

    protected static void loadFromManifest(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        String pluginClasses = m.getMainAttributes().getValue("OmegaT-Plugins");
        if (pluginClasses != null) {
            for (String clazz : pluginClasses.split("\\s+")) {
                if (clazz.trim().isEmpty()) continue;
                try {
                    Class<?> c = classLoader.loadClass(clazz);
                    Method load = c.getMethod("loadPlugins", new Class[0]);
                    load.invoke(c, new Object[0]);
                    loadedPlugins.add(c);
                    Log.logInfoRB("PLUGIN_LOAD_OK", clazz);
                }
                catch (Throwable ex) {
                    Log.logErrorRB(ex, "PLUGIN_LOAD_ERROR", clazz, ex.getClass().getSimpleName(), ex.getMessage());
                    Core.pluginLoadingError(StringUtil.format(OStrings.getString("PLUGIN_LOAD_ERROR"), clazz, ex.getClass().getSimpleName(), ex.getMessage()));
                }
            }
        }
        PluginUtils.loadFromManifestOld(m, classLoader);
        PluginUtils.loadFormatsFromManifest(m, classLoader);
    }

    public static void unloadPlugins() {
        for (Class<?> p : loadedPlugins) {
            try {
                Method load = p.getMethod("unloadPlugins", new Class[0]);
                load.invoke(p, new Object[0]);
            }
            catch (Throwable ex) {
                Log.logErrorRB(ex, "PLUGIN_UNLOAD_ERROR", p.getClass().getSimpleName(), ex.getMessage());
            }
        }
    }

    protected static void loadFromManifestOld(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        block13: for (Map.Entry<String, Attributes> e : entries.entrySet()) {
            PLUGIN_TYPE pType;
            String key = e.getKey();
            Attributes attrs = e.getValue();
            String sType = attrs.getValue("OmegaT-Plugin");
            if ("true".equals(attrs.getValue("OmegaT-Tokenizer"))) {
                sType = "tokenizer";
            }
            if (sType == null) continue;
            try {
                pType = PLUGIN_TYPE.valueOf(sType.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                pType = PLUGIN_TYPE.UNKNOWN;
            }
            switch (pType) {
                case FILTER: {
                    filterClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case TOKENIZER: {
                    tokenizerClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case MARKER: {
                    markerClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case MACHINETRANSLATOR: {
                    machineTranslationClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case TRANSLATION_MEMORY: {
                    translationMemoryClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case BASE: {
                    basePluginClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case GLOSSARY: {
                    glossaryClasses.add(classLoader.loadClass(key));
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block13;
                }
                case DOCKABLE: {
                    dockableClasses.add(classLoader.loadClass(key));
                    continue block13;
                }
                case EDITORPOPUPS: {
                    editorPopupClasses.add(classLoader.loadClass(key));
                    continue block13;
                }
            }
            Log.logErrorRB("PLUGIN_UNKNOWN", key);
        }
    }

    public static Map<String, Class<?>> getTranslationMemoryFormatClasses() {
        return tmFormatClasses;
    }

    protected static void loadFormatsFromManifest(Manifest m, ClassLoader classLoader) throws ClassNotFoundException {
        if (m.getMainAttributes().getValue("OmegaT-Plugin") == null) {
            return;
        }
        Map<String, Attributes> entries = m.getEntries();
        block5: for (String key : entries.keySet()) {
            PLUGIN_TYPE pType;
            System.err.println("Looking at " + key);
            Attributes attrs = entries.get(key);
            String sType = attrs.getValue("OmegaT-Format-Plugin");
            String sExtension = attrs.getValue("File-Extension");
            if (sType == null || sExtension == null) continue;
            try {
                pType = PLUGIN_TYPE.valueOf(sType.toUpperCase(Locale.ENGLISH));
            }
            catch (Exception ex) {
                pType = PLUGIN_TYPE.UNKNOWN;
            }
            String[] extensions = sExtension.split(",");
            switch (pType) {
                case TRANSLATION_MEMORY: {
                    for (String ext : extensions) {
                        tmFormatClasses.put(ext, classLoader.loadClass(key));
                    }
                    Log.logInfoRB("PLUGIN_LOAD_OK", key);
                    continue block5;
                }
            }
            Log.logErrorRB("PLUGIN_UNKNOWN", key);
        }
    }

    static {
        loadedPlugins = new ArrayList();
        filterClasses = new ArrayList();
        tokenizerClasses = new ArrayList();
        markerClasses = new ArrayList();
        machineTranslationClasses = new ArrayList();
        translationMemoryClasses = new ArrayList();
        glossaryClasses = new ArrayList();
        basePluginClasses = new ArrayList();
        dockableClasses = new ArrayList();
        editorPopupClasses = new ArrayList<Class<? extends PopupMenuDisplayer.IPopupMenuConstructor>>();
        tmFormatClasses = new HashMap();
    }

    static enum PLUGIN_TYPE {
        FILTER,
        TOKENIZER,
        MARKER,
        MACHINETRANSLATOR,
        TRANSLATION_MEMORY,
        BASE,
        GLOSSARY,
        DOCKABLE,
        EDITORPOPUPS,
        UNKNOWN;

    }
}

