/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters2.text.dokuwiki;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.Instance;
import org.omegat.util.LinebreakPreservingReader;
import org.omegat.util.OStrings;

public class DokuWikiFilter
extends AbstractFilter {
    private Pattern codeTag = Pattern.compile("\\<code|\\<file|\\<html|\\<php|\\/\\*");

    @Override
    public String getFileFormatName() {
        return OStrings.getString("DWFILTER_FILTER_NAME");
    }

    @Override
    public boolean isSourceEncodingVariable() {
        return false;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return false;
    }

    @Override
    public Instance[] getDefaultInstances() {
        return new Instance[]{new Instance("*.txt", "UTF-8", "UTF-8")};
    }

    @Override
    protected boolean requirePrevNextFields() {
        return true;
    }

    @Override
    protected boolean isFileSupported(BufferedReader reader) {
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        try {
            String line;
            while ((line = lbpr.readLine()) != null) {
                String trimmed = line.trim();
                if (DokuWikiFilter.getHeadingLevel(trimmed) <= 0) continue;
                lbpr.close();
                return true;
            }
            lbpr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    @Override
    public void processFile(BufferedReader reader, BufferedWriter outfile, FilterContext fc) throws IOException {
        String line;
        LinebreakPreservingReader lbpr = new LinebreakPreservingReader(reader);
        StringBuilder text = new StringBuilder();
        while ((line = lbpr.readLine()) != null) {
            String trimmed = line.trim();
            if (trimmed.isEmpty()) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            int headingLevel = DokuWikiFilter.getHeadingLevel(trimmed);
            if (headingLevel > 0) {
                this.writeTranslate(outfile, text, lbpr);
                String header = trimmed.substring(headingLevel, trimmed.length() - headingLevel).trim();
                if (!header.isEmpty()) {
                    String trans = this.processEntry(header);
                    line = line.replace(header, trans);
                }
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            if (line.startsWith("  *") || line.startsWith("  -")) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line.substring(0, 3));
                outfile.write(32);
                this.writeTranslate(outfile, line.substring(3), lbpr);
                continue;
            }
            if (trimmed.startsWith("{{") && trimmed.endsWith("}}") || trimmed.startsWith("~~") && trimmed.endsWith("~~") && trimmed.length() > 5) {
                this.writeTranslate(outfile, text, lbpr);
                outfile.write(line + lbpr.getLinebreak());
                continue;
            }
            if (line.startsWith("|") || line.startsWith("^")) {
                int cp;
                this.writeTranslate(outfile, text, lbpr);
                int start = 0;
                int braceCount = 0;
                block6: for (int i = 0; i < line.length(); i += Character.charCount(cp)) {
                    cp = line.codePointAt(i);
                    switch (cp) {
                        case 94: 
                        case 124: {
                            if (braceCount != 0) continue block6;
                            String value = line.substring(start, i);
                            if (start > 0) {
                                outfile.write(32);
                                this.writeTranslate(outfile, value, null);
                                outfile.write(32);
                            }
                            outfile.write(Character.toChars(cp));
                            start = i + Character.charCount(cp);
                            continue block6;
                        }
                        case 123: {
                            ++braceCount;
                            continue block6;
                        }
                        case 125: {
                            --braceCount;
                        }
                    }
                }
                outfile.write(lbpr.getLinebreak());
                continue;
            }
            trimmed = this.skipCode(outfile, text, lbpr, line);
            if (trimmed == null) {
                return;
            }
            text.append(' ');
            text.append(trimmed);
        }
        this.writeTranslate(outfile, text, lbpr);
    }

    private static int getHeadingLevel(String line) {
        int level = 0;
        int start = 0;
        int end = line.length();
        while (start < end) {
            int scp = line.codePointAt(start);
            int ecp = line.codePointBefore(end);
            if (scp != 61 || ecp != 61) break;
            start += Character.charCount(scp);
            end -= Character.charCount(ecp);
            ++level;
        }
        if (line.codePointCount(start, end) > 1) {
            return level;
        }
        return 0;
    }

    private void writeTranslate(BufferedWriter outfile, StringBuilder text, LinebreakPreservingReader lbpr) throws IOException {
        if (text.length() > 0) {
            String value = text.toString();
            text.setLength(0);
            this.writeTranslate(outfile, value, lbpr);
        }
    }

    private void writeTranslate(BufferedWriter outfile, String value, LinebreakPreservingReader lbpr) throws IOException {
        if (!(value = value.trim()).isEmpty()) {
            String newValue;
            while (!(newValue = value.replace("  ", " ")).equals(value)) {
                value = newValue;
            }
            String trans = this.processEntry(value);
            outfile.write(trans);
            if (lbpr != null) {
                outfile.write(lbpr.getLinebreak());
            }
        }
    }

    private String skipCode(BufferedWriter outfile, StringBuilder text, LinebreakPreservingReader lbpr, String line) throws IOException {
        Matcher matcher;
        while ((matcher = this.codeTag.matcher(line)).find()) {
            int start = matcher.start();
            String tagName = line.substring(start + 1, matcher.end());
            boolean isAsterisk = tagName.equals("*");
            text.append(' ');
            text.append(line.substring(0, start));
            if (!isAsterisk) {
                this.writeTranslate(outfile, text, lbpr);
            }
            Object endTagPattern = isAsterisk ? "\\*\\/" : "\\</" + tagName + "\\>";
            Pattern endTag = Pattern.compile((String)endTagPattern);
            line = line.substring(start);
            matcher = endTag.matcher(line);
            while (!matcher.find()) {
                outfile.write(line + lbpr.getLinebreak());
                line = lbpr.readLine();
                if (line == null) {
                    return null;
                }
                matcher = endTag.matcher(line);
            }
            int end = matcher.end();
            outfile.write(line.substring(0, end) + lbpr.getLinebreak());
            line = line.substring(end);
        }
        return line;
    }
}

