/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.filters4;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.omegat.filters2.AbstractFilter;
import org.omegat.filters2.FilterContext;
import org.omegat.filters2.TranslationException;
import org.omegat.filters4.xml.AbstractXmlFilter;
import org.omegat.util.Log;
import org.omegat.util.xml.XMLReader;

public abstract class AbstractZipFilter
extends AbstractFilter {
    @Override
    public boolean isSourceEncodingVariable() {
        return true;
    }

    @Override
    public boolean isTargetEncodingVariable() {
        return true;
    }

    protected abstract boolean acceptEntry(ZipEntry var1, FilterContext var2);

    @Override
    public boolean isFileSupported(File inFile, Map<String, String> config, FilterContext context) {
        try {
            ZipFile file = new ZipFile(inFile);
            Enumeration<? extends ZipEntry> entries = file.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!this.acceptEntry(entry, context)) continue;
                file.close();
                return true;
            }
            file.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    protected abstract boolean mustTranslateEntry(ZipEntry var1, boolean var2, FilterContext var3);

    protected boolean mustDeleteEntry(ZipEntry entry, boolean writeMode, FilterContext context) {
        return false;
    }

    protected abstract AbstractXmlFilter getFilter(ZipEntry var1);

    protected Comparator<ZipEntry> getEntryComparator() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processFile(File inFile, File outFile, FilterContext fc) throws IOException, TranslationException {
        ZipFile zf = new ZipFile(inFile);
        ZipOutputStream zipout = null;
        if (outFile != null) {
            zipout = new ZipOutputStream(new FileOutputStream(outFile));
        }
        try {
            Enumeration<? extends ZipEntry> zipcontents = zf.entries();
            LinkedList<ZipEntry> toTranslate = new LinkedList<ZipEntry>();
            Comparator<ZipEntry> cmp = this.getEntryComparator();
            while (zipcontents.hasMoreElements()) {
                ZipEntry ze = zipcontents.nextElement();
                if (this.mustTranslateEntry(ze, outFile != null, fc)) {
                    if (cmp == null || outFile != null) {
                        this.translateEntry(zf, zipout, fc, ze);
                        continue;
                    }
                    toTranslate.add(ze);
                    continue;
                }
                if (this.mustDeleteEntry(ze, outFile != null, fc) || zipout == null) continue;
                ZipEntry outEntry = new ZipEntry(ze.getName());
                zipout.putNextEntry(outEntry);
                IOUtils.copy((InputStream)zf.getInputStream(ze), (OutputStream)zipout);
                zipout.closeEntry();
            }
            if (cmp != null) {
                Collections.sort(toTranslate, cmp);
            }
            for (ZipEntry ze : toTranslate) {
                this.translateEntry(zf, zipout, fc, ze);
            }
        }
        finally {
            if (zipout != null) {
                zipout.close();
            }
            zf.close();
        }
    }

    private void translateEntry(ZipFile zf, ZipOutputStream zipout, FilterContext fc, ZipEntry ze) {
        try {
            AbstractXmlFilter xmlfilter = this.getFilter(ze);
            XMLReader xReader = new XMLReader(zf.getInputStream(ze));
            BufferedReader reader = new BufferedReader(xReader);
            if (zipout == null) {
                xmlfilter.processFile(reader, null, fc);
            } else {
                ZipEntry outEntry = new ZipEntry(ze.getName());
                zipout.putNextEntry(outEntry);
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zipout, xReader.getEncoding()));
                xmlfilter.processFile(reader, writer, fc);
                zipout.closeEntry();
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
    }

    @Override
    protected void processFile(BufferedReader inFile, BufferedWriter outFile, FilterContext fc) throws IOException, TranslationException {
        throw new IOException("Not implemented");
    }
}

