/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.omegat.core.Core;
import org.omegat.gui.editor.autotext.Autotext;
import org.omegat.gui.editor.autotext.AutotextPair;
import org.omegat.gui.editor.autotext.AutotextTableModel;
import org.omegat.util.OStrings;
import org.omegat.util.Preferences;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;
import org.openide.awt.Mnemonics;

public class AutotextAutoCompleterOptionsDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    public int returnStatus = 0;
    AutotextTableModel model = new AutotextTableModel();
    File theFile = null;
    File[] files;
    final JFileChooser fc = new JFileChooser();
    private JButton addNewRowButton;
    private JButton cancelButton;
    private JTable entryTable;
    private Box.Filler filler1;
    private Box.Filler filler2;
    private Box.Filler filler3;
    private JPanel jPanel1;
    private JPanel jPanel10;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanel5;
    private JPanel jPanel6;
    private JPanel jPanel7;
    private JPanel jPanel8;
    private JPanel jPanel9;
    private JScrollPane jScrollPane2;
    private JButton loadButton;
    private JButton okButton;
    private JButton removeEntryButton;
    private JButton saveButton;
    private JCheckBox sortAlphabeticallyCheckBox;
    private JCheckBox sortByLengthCheckBox;
    private JCheckBox sortFullTextCheckBox;

    public AutotextAutoCompleterOptionsDialog(Frame parent) {
        super(parent, true);
        this.initComponents();
        StaticUIUtils.setEscapeClosable(this);
        this.getRootPane().setDefaultButton(this.okButton);
        this.sortByLengthCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_by_length"));
        this.sortAlphabeticallyCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_alphabetically"));
        this.sortFullTextCheckBox.setSelected(Preferences.isPreference("ac_autotext_sort_full_text"));
        this.sortFullTextCheckBox.setEnabled(this.sortAlphabeticallyCheckBox.isSelected());
        this.fc.setDialogType(0);
        FileNameExtensionFilter filter = new FileNameExtensionFilter(OStrings.getString("AC_AUTOTEXT_FILE"), "autotext");
        this.fc.addChoosableFileFilter(filter);
        this.model.load();
        this.entryTable.setModel(this.model);
        this.model.addTableModelListener(this.entryTable);
        this.setPreferredSize(new Dimension(500, 500));
        this.pack();
        DockingUI.displayCentered(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jPanel6 = new JPanel();
        this.jPanel3 = new JPanel();
        this.jPanel9 = new JPanel();
        this.sortByLengthCheckBox = new JCheckBox();
        this.sortAlphabeticallyCheckBox = new JCheckBox();
        this.sortFullTextCheckBox = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.jPanel8 = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.entryTable = new JTable(){

            @Override
            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                if (c instanceof JComponent) {
                    JComponent jc = (JComponent)c;
                    jc.setToolTipText(this.getValueAt(row, column).toString());
                }
                return c;
            }
        };
        this.jPanel10 = new JPanel();
        this.filler3 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel7 = new JPanel();
        this.loadButton = new JButton();
        this.saveButton = new JButton();
        this.filler1 = new Box.Filler(new Dimension(0, 20), new Dimension(0, 20), new Dimension(Short.MAX_VALUE, 20));
        this.addNewRowButton = new JButton();
        this.removeEntryButton = new JButton();
        this.filler2 = new Box.Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
        this.jPanel4 = new JPanel();
        this.jPanel5 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 100, Short.MAX_VALUE));
        this.setDefaultCloseOperation(2);
        this.setTitle(OStrings.getString("AC_AUTOTEXT_OPTIONS_TITLE"));
        this.jPanel6.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.jPanel6.setLayout(new BorderLayout());
        this.jPanel3.setBorder(BorderFactory.createTitledBorder(OStrings.getString("AC_AUTOTEXT_DISPLAY_PANEL")));
        this.jPanel3.setLayout(new BorderLayout());
        this.jPanel9.setLayout(new GridBagLayout());
        this.sortByLengthCheckBox.setText(OStrings.getString("AC_AUTOTEXT_SORT_BY_LENGTH"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.sortByLengthCheckBox, gridBagConstraints);
        this.sortAlphabeticallyCheckBox.setText(OStrings.getString("AC_AUTOTEXT_ALPHABETICALLY"));
        this.sortAlphabeticallyCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.sortAlphabeticallyCheckBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        this.jPanel9.add((Component)this.sortAlphabeticallyCheckBox, gridBagConstraints);
        this.sortFullTextCheckBox.setText(OStrings.getString("AC_AUTOTEXT_SORT_FULL_TEXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 25, 5, 0);
        this.jPanel9.add((Component)this.sortFullTextCheckBox, gridBagConstraints);
        this.jPanel3.add((Component)this.jPanel9, "West");
        this.jPanel6.add((Component)this.jPanel3, "North");
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(OStrings.getString("AC_AUTOTEXT_ENTRIES_PANEL")));
        this.jPanel2.setLayout(new BorderLayout());
        this.jPanel8.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 0));
        this.jPanel8.setLayout(new BorderLayout());
        this.entryTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null}, {null, null, null}, {null, null, null}, {null, null, null}}, new String[]{"Shortcut", "Full text", "Comment"}));
        this.entryTable.setFillsViewportHeight(true);
        this.jScrollPane2.setViewportView(this.entryTable);
        if (this.entryTable.getColumnModel().getColumnCount() > 0) {
            this.entryTable.getColumnModel().getColumn(0).setHeaderValue(OStrings.getString("AC_AUTOTEXT_ABBREVIATION"));
            this.entryTable.getColumnModel().getColumn(1).setHeaderValue(OStrings.getString("AC_AUTOTEXT_TEXT"));
            this.entryTable.getColumnModel().getColumn(2).setHeaderValue(OStrings.getString("AC_AUTOTEXT_COMMENT"));
        }
        this.jPanel8.add((Component)this.jScrollPane2, "Center");
        this.jPanel10.setLayout(new BoxLayout(this.jPanel10, 1));
        this.jPanel10.add(this.filler3);
        this.jPanel7.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jPanel7.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText(this.loadButton, OStrings.getString("AC_AUTOTEXT_BUTTON_LOAD"));
        this.loadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.loadButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.loadButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.saveButton, OStrings.getString("AC_AUTOTEXT_BUTTON_SAVE"));
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.saveButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.saveButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        this.jPanel7.add((Component)this.filler1, gridBagConstraints);
        Mnemonics.setLocalizedText(this.addNewRowButton, OStrings.getString("BUTTON_ADD_NODOTS"));
        this.addNewRowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.addNewRowButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.addNewRowButton, gridBagConstraints);
        Mnemonics.setLocalizedText(this.removeEntryButton, OStrings.getString("BUTTON_REMOVE"));
        this.removeEntryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.removeEntryButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.jPanel7.add((Component)this.removeEntryButton, gridBagConstraints);
        this.jPanel10.add(this.jPanel7);
        this.jPanel10.add(this.filler2);
        this.jPanel8.add((Component)this.jPanel10, "East");
        this.jPanel2.add((Component)this.jPanel8, "Center");
        this.jPanel6.add((Component)this.jPanel2, "Center");
        this.getContentPane().add((Component)this.jPanel6, "Center");
        this.jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.jPanel4.setLayout(new BorderLayout());
        this.jPanel5.setLayout(new BoxLayout(this.jPanel5, 2));
        Mnemonics.setLocalizedText(this.okButton, OStrings.getString("BUTTON_OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.okButton);
        Mnemonics.setLocalizedText(this.cancelButton, OStrings.getString("BUTTON_CANCEL"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AutotextAutoCompleterOptionsDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel5.add(this.cancelButton);
        this.jPanel4.add((Component)this.jPanel5, "East");
        this.getContentPane().add((Component)this.jPanel4, "South");
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        int result = this.fc.showOpenDialog(this);
        if (result == 0) {
            File selectedFile = this.fc.getSelectedFile();
            try {
                Core.getAutoText().load(selectedFile.getCanonicalPath());
                this.model.load();
            }
            catch (IOException ex) {
                Logger.getLogger(AutotextAutoCompleterOptionsDialog.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void saveButtonActionPerformed(ActionEvent evt) {
        Autotext autoText = new Autotext(null);
        int result = this.fc.showSaveDialog(this);
        if (result != 0) {
            return;
        }
        this.model.store(autoText);
        try {
            autoText.save(this.fc.getSelectedFile().getCanonicalPath());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, OStrings.getString("AC_AUTOTEXT_UNABLE_TO_SAVE"));
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        TableCellEditor editor = this.entryTable.getCellEditor();
        if (editor != null) {
            editor.stopCellEditing();
        }
        Autotext autoText = Core.getAutoText();
        this.model.store(autoText);
        try {
            autoText.save();
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, OStrings.getString("AC_AUTOTEXT_UNABLE_TO_SAVE"));
        }
        Preferences.setPreference("ac_autotext_sort_by_length", this.sortByLengthCheckBox.isSelected());
        Preferences.setPreference("ac_autotext_sort_alphabetically", this.sortAlphabeticallyCheckBox.isSelected());
        Preferences.setPreference("ac_autotext_sort_full_text", this.sortFullTextCheckBox.isSelected());
        this.doClose(1);
    }

    private void sortAlphabeticallyCheckBoxActionPerformed(ActionEvent evt) {
        this.sortFullTextCheckBox.setEnabled(this.sortAlphabeticallyCheckBox.isSelected());
    }

    private void addNewRowButtonActionPerformed(ActionEvent evt) {
        int newRow = this.model.addRow(new AutotextPair("", "", ""), this.entryTable.getSelectedRow());
        this.entryTable.changeSelection(newRow, 0, false, false);
        this.entryTable.changeSelection(newRow, this.entryTable.getColumnCount() - 1, false, true);
        this.entryTable.editCellAt(newRow, 0);
        this.entryTable.transferFocus();
    }

    private void removeEntryButtonActionPerformed(ActionEvent evt) {
        if (this.entryTable.getSelectedRow() != -1) {
            this.model.removeRow(this.entryTable.getSelectedRow());
        }
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        this.setVisible(false);
        this.dispose();
    }
}

