/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.editor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Utilities;
import org.omegat.core.Core;
import org.omegat.core.data.ProtectedPart;
import org.omegat.core.data.SourceTextEntry;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.gui.editor.IEditor;
import org.omegat.gui.glossary.TransTips;
import org.omegat.tokenizer.ITokenizer;
import org.omegat.util.Preferences;
import org.omegat.util.StringUtil;
import org.omegat.util.TagUtil;
import org.omegat.util.Token;

public class EditorUtils {
    public static boolean isRTL(String language) {
        return "ar".equalsIgnoreCase(language) || "iw".equalsIgnoreCase(language) || "he".equalsIgnoreCase(language) || "fa".equalsIgnoreCase(language) || "ur".equalsIgnoreCase(language) || "ug".equalsIgnoreCase(language) || "ji".equalsIgnoreCase(language) || "yi".equalsIgnoreCase(language);
    }

    public static boolean localeIsRTL() {
        String language = Locale.getDefault().getLanguage().toLowerCase();
        return EditorUtils.isRTL(language);
    }

    public static int getWordStart(JTextComponent c, int offs) throws BadLocationException {
        int result = Utilities.getWordStart(c, offs);
        char ch = c.getDocument().getText(result, 1).charAt(0);
        if (EditorUtils.isDirectionChar(ch)) {
            ++result;
        }
        return result;
    }

    public static int getWordEnd(JTextComponent c, int offs) throws BadLocationException {
        char ch;
        int result = Utilities.getWordEnd(c, offs);
        if (result > 0 && EditorUtils.isDirectionChar(ch = c.getDocument().getText(result - 1, 1).charAt(0))) {
            --result;
        }
        return result;
    }

    private static boolean isDirectionChar(char ch) {
        return ch == '\u202a' || ch == '\u202b' || ch == '\u202c' || ch == '\u200e' || ch == '\u200f';
    }

    public static String removeDirectionChars(String text) {
        return text.replaceAll("[\u202a\u202b\u202c\u200e\u200f]", "");
    }

    public static String removeDirectionCharsAroundTags(String text, SourceTextEntry ste) {
        for (ProtectedPart pp : ste.getProtectedParts()) {
            int pos = -1;
            while ((pos = ((String)text).indexOf(pp.getTextInSourceSegment(), pos + 1)) >= 0) {
                if (!EditorUtils.hasBidiAroundTag((String)text, pp.getTextInSourceSegment(), pos)) continue;
                text = ((String)text).substring(0, pos - 2) + pp.getTextInSourceSegment() + ((String)text).substring(pos + pp.getTextInSourceSegment().length() + 2);
            }
        }
        return text;
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat) {
        Locale locale = Core.getProject().getProjectProperties().getTargetLanguage().getLocale();
        ITokenizer tokenizer = Core.getProject().getTargetTokenizer();
        return EditorUtils.doChangeCase(input, toWhat, locale, tokenizer);
    }

    public static String doChangeCase(String input, IEditor.CHANGE_CASE_TO toWhat, Locale locale, ITokenizer tokenizer) {
        Token[] tokenList = tokenizer.tokenizeVerbatim(input);
        if (toWhat == IEditor.CHANGE_CASE_TO.CYCLE) {
            int lower = 0;
            int upper = 0;
            int title = 0;
            int ambiguous = 0;
            int mixed = 0;
            for (Token token : tokenList) {
                String word = token.getTextFromString(input);
                if (!EditorUtils.canChangeTokenCase(word)) continue;
                if (StringUtil.isLowerCase(word)) {
                    ++lower;
                    continue;
                }
                boolean isTitle = StringUtil.isTitleCase(word);
                boolean isUpper = StringUtil.isUpperCase(word);
                if (isTitle && isUpper) {
                    ++ambiguous;
                    continue;
                }
                if (isTitle) {
                    ++title;
                    continue;
                }
                if (isUpper) {
                    ++upper;
                    continue;
                }
                if (!StringUtil.isMixedCase(word)) continue;
                ++mixed;
            }
            if (lower == 0 && title == 0 && upper == 0 && mixed == 0 && ambiguous == 0) {
                return input;
            }
            toWhat = EditorUtils.determineTargetCase(lower, upper, title, mixed, ambiguous);
        }
        StringBuilder buffer = new StringBuilder(input);
        int lengthIncrement = 0;
        for (Token token : tokenList) {
            String result;
            String tokText = token.getTextFromString(input);
            if (!EditorUtils.canChangeTokenCase(tokText)) continue;
            if (toWhat == IEditor.CHANGE_CASE_TO.LOWER) {
                result = tokText.toLowerCase(locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.UPPER) {
                result = tokText.toUpperCase(locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.TITLE) {
                result = StringUtil.toTitleCase(tokText, locale);
            } else if (toWhat == IEditor.CHANGE_CASE_TO.SENTENCE) {
                result = StringUtil.toTitleCase(tokText, locale);
                toWhat = IEditor.CHANGE_CASE_TO.LOWER;
            } else {
                result = tokText;
            }
            buffer.replace(token.getOffset() + lengthIncrement, token.getLength() + token.getOffset() + lengthIncrement, result);
            lengthIncrement += result.length() - token.getLength();
        }
        return buffer.toString();
    }

    private static boolean canChangeTokenCase(String token) {
        return Character.isLetter(token.codePointAt(0));
    }

    private static IEditor.CHANGE_CASE_TO determineTargetCase(int lower, int upper, int title, int mixed, int ambiguous) {
        int presentCaseTypes = 0;
        if (lower > 0) {
            ++presentCaseTypes;
        }
        if (upper > 0) {
            ++presentCaseTypes;
        }
        if (title > 0) {
            ++presentCaseTypes;
        }
        if (mixed > 0) {
            ++presentCaseTypes;
        }
        if ((title > 0 || ambiguous > 0) && lower > 0 && upper == 0 && mixed == 0) {
            return IEditor.CHANGE_CASE_TO.TITLE;
        }
        if (mixed > 0 || presentCaseTypes > 1) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (lower > 0) {
            return IEditor.CHANGE_CASE_TO.SENTENCE;
        }
        if (title > 0) {
            return IEditor.CHANGE_CASE_TO.UPPER;
        }
        if (upper > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        if (ambiguous > 0) {
            return IEditor.CHANGE_CASE_TO.LOWER;
        }
        return IEditor.CHANGE_CASE_TO.UPPER;
    }

    public static String replaceGlossaryEntries(String text) {
        Locale locale = Core.getProject().getProjectProperties().getSourceLanguage().getLocale();
        return EditorUtils.replaceGlossaryEntries(text, Core.getGlossaryManager().getGlossaryEntries(text));
    }

    public static String replaceGlossaryEntries(String text, List<GlossaryEntryStore> entries) {
        if (StringUtil.isEmpty(text) || entries == null || entries.isEmpty()) {
            return text;
        }
        Collections.sort(entries, (a, b) -> b.getSrcText().length() - a.getSrcText().length());
        StringBuffer buf = new StringBuffer(text);
        boolean pref = Preferences.isPreferenceDefault("glossary_remove_tags", false);
        if (pref) {
            Preferences.setPreference("glossary_remove_tags", false);
        }
        ArrayList lStart = new ArrayList();
        ArrayList lEnd = new ArrayList();
        for (GlossaryEntryStore e : entries) {
            int shift = 0;
            lStart.clear();
            lEnd.clear();
            TransTips.search(buf.toString(), e, (ge, start, end) -> {
                lStart.add(start);
                lEnd.add(end);
            }, true);
            for (int i = 0; i < lEnd.size(); ++i) {
                buf.replace((Integer)lStart.get(i) + shift, (Integer)lEnd.get(i) + shift, e.getLocText());
                shift += e.getLocText().length() - ((Integer)lEnd.get(i) - (Integer)lStart.get(i));
            }
        }
        if (pref) {
            Preferences.setPreference("glossary_remove_tags", pref);
        }
        return buf.toString();
    }

    public static String addBidiAroundTags(String text, SourceTextEntry ste) {
        List<TagUtil.Tag> tags = TagUtil.buildTagList(text, ste.getProtectedParts());
        int pos = 0;
        StringBuilder s = new StringBuilder(text.length() * 12 / 10);
        for (TagUtil.Tag t : tags) {
            if (pos < t.pos) {
                s.append(text.substring(pos, t.pos));
            }
            s.append('\u200f');
            s.append('\u200e');
            s.append(t.tag);
            s.append('\u200e');
            s.append('\u200f');
            pos = t.pos + t.tag.length();
        }
        if (pos < text.length()) {
            s.append(text.substring(pos));
        }
        return s.toString();
    }

    public static boolean hasBidiAroundTag(String text, String tag, int pos) {
        try {
            boolean has = true;
            if (text.charAt(pos - 1) != '\u200e' || text.charAt(pos - 2) != '\u200f') {
                has = false;
            }
            if (text.charAt(pos + tag.length()) != '\u200e' || text.charAt(pos + tag.length() + 1) != '\u200f') {
                has = false;
            }
            return has;
        }
        catch (StringIndexOutOfBoundsException ex) {
            return false;
        }
    }
}

