/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.gui.glossary;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.omegat.core.glossaries.FileGlossary;
import org.omegat.core.glossaries.GlossaryEntryStore;
import org.omegat.core.glossaries.IWritableGlossary;
import org.omegat.util.EncodingDetector;
import org.omegat.util.Language;
import org.omegat.util.StringUtil;

public class GlossaryReaderTSV
extends FileGlossary
implements IWritableGlossary {
    public GlossaryReaderTSV(File file) throws IOException {
        super(file);
        this.entries = GlossaryReaderTSV.read(file, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<GlossaryEntryStore> read(File file, GlossaryReaderTSV origin) throws IOException {
        String encoding;
        String fname_lower = file.getName().toLowerCase();
        if (fname_lower.endsWith(".tab") || fname_lower.endsWith(".txt")) {
            encoding = EncodingDetector.detectEncodingDefault(file, Charset.defaultCharset().name());
        } else if (fname_lower.endsWith(".utf8")) {
            encoding = "UTF-8";
        } else {
            return null;
        }
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        ArrayList<GlossaryEntryStore> result = new ArrayList<GlossaryEntryStore>();
        try (BufferedReader in = new BufferedReader(reader);){
            in.mark(1);
            int ch = in.read();
            if (ch != 65279) {
                in.reset();
            }
            String s = in.readLine();
            while (s != null) {
                String[] tokens;
                if (!s.startsWith("#") && (tokens = s.split("\t")).length >= 2 && !tokens[0].isEmpty()) {
                    String comment = "";
                    if (tokens.length >= 3) {
                        comment = tokens[2];
                    }
                    result.add(new GlossaryEntryStore(tokens[0], tokens[1], comment, origin));
                }
                s = in.readLine();
            }
        }
        return result;
    }

    @Override
    public void addEntry(Language sLang, Language tLang, String src, String tra, String comment) throws IOException {
        String encoding = "UTF-8";
        File dest = this.getOriginFile();
        if (!dest.exists()) {
            File parentFile = dest.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            dest.createNewFile();
        } else {
            encoding = EncodingDetector.detectEncodingDefault(dest, "UTF-8");
        }
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(dest, true), encoding);
        ((Writer)wr).append(src).append('\t').append(tra);
        if (!StringUtil.isEmpty(comment)) {
            wr.append('\t').append(comment);
        }
        ((Writer)wr).append(System.getProperty("line.separator"));
        ((Writer)wr).close();
    }
}

